package com.ejianc.foundation.print.service.impl;

import java.util.List;

import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.service.ITemplateService;
import com.ejianc.foundation.print.vo.PublishDataVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.print.mapper.DataTransferMapper;
import com.ejianc.foundation.print.service.IDataTransferService;
import com.ejianc.framework.core.response.CommonResponse;

@Service
public class DataTransferService implements IDataTransferService {

	@Autowired
	private DataTransferMapper dataTransferMapper;
	@Autowired
	private IBusinessObjectService businessObjectService;
	@Autowired
	private ITemplateService templateService;
	
	@Override
	public CommonResponse<String> executeSql(List<String> sqls) {
		String sqlUnion = "";
		for(String sql : sqls){
			sqlUnion += (sql+";");
		}
		dataTransferMapper.executeSql(sqlUnion);
		return CommonResponse.success("发布成功");
	}

	@Override
	public void transferByData(PublishDataVO vo) {
		/*************业务对象管理start*************/
		if("businessObject".equals(vo.getType())){
			String idStr = "";
			for (Long id : vo.getIds()) {
				idStr = idStr + "'" + id + "',";
			}
			idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
			String baseTableName = "ejc_print_business_object";
			String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr;
			dataTransferMapper.executeSql(deleteBaseSql);

			if(vo.getBusinessObjectEntities()!=null && vo.getBusinessObjectEntities().size()>0){
				businessObjectService.saveOrUpdateBatch(vo.getBusinessObjectEntities(), vo.getBusinessObjectEntities().size(), false);
			}
		}
		/*************业务对象管理end*************/

		/*************打印模板start*************/
		if("template".equals(vo.getType())){
			String idStr = "";
			for (Long id : vo.getIds()) {
				idStr = idStr + "'" + id + "',";
			}
			idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
			String baseTableName = "ejc_print_template";
			String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr;
			dataTransferMapper.executeSql(deleteBaseSql);
			if(vo.getTemplateEntities()!=null && vo.getTemplateEntities().size()>0){
				templateService.saveOrUpdateBatch(vo.getTemplateEntities(), vo.getTemplateEntities().size(), false);
			}
		}
		/*************打印模板end*************/
	}

}
