/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.print.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.api.IMdProjectApi;
import com.ejianc.foundation.metadata.vo.CustomFieldVO;
import com.ejianc.foundation.metadata.vo.CustomObjVO;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.util.DataTransferUtil;
import com.ejianc.foundation.print.util.HttpTookit;
import com.ejianc.foundation.print.vo.BusinessObjectVO;
import com.ejianc.foundation.print.vo.PublishDataVO;
import com.ejianc.foundation.print.vo.PublishVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bomanage/"})
public class BusinessObjectController {
    private Gson gson = new Gson();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${oms.tenantid}")
    private Long BASE_TENANT_ID;
    @Autowired
    private IBusinessObjectService businessObjectService;
    @Autowired
    private IMdClassApi mdClassApi;
    @Autowired
    private IMdProjectApi mdProjectApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private EnvironmentTools environmentTools;
    private final String QUERY_CLAUSE_LIST_BY_CATEGORY_ID_URL = "ejc-contractbase-web/api/clauseSetting/getListByCategoryId";

    @PostMapping(value={"save"})
    public CommonResponse<BusinessObjectVO> save(@RequestBody BusinessObjectVO vo) {
        BusinessObjectEntity dbEntity = null;
        if (null != vo.getId()) {
            dbEntity = this.businessObjectService.queryDetail(vo.getId());
            dbEntity.setContent(vo.getContent());
            dbEntity.setName(vo.getName());
            dbEntity.setCode(vo.getCode());
            dbEntity.setQrcode(vo.getQrcode());
            dbEntity.setShowPrintNumber(vo.getShowPrintNumber());
        } else {
            dbEntity = this.businessObjectService.getByCode(vo.getCode());
            if (null != dbEntity) {
                return CommonResponse.error((String)"\u7f16\u7801\u91cd\u590d\uff0c\u4fdd\u5b58\u5931\u8d25\uff01");
            }
            dbEntity = (BusinessObjectEntity)((Object)BeanMapper.map((Object)vo, BusinessObjectEntity.class));
        }
        this.businessObjectService.saveOrUpdate((Object)dbEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u4e1a\u52a1\u5bf9\u8c61\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)dbEntity), BusinessObjectVO.class));
    }

    @PostMapping(value={"page"})
    public CommonResponse<JSONObject> page(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        resp.put("data", this.pageList(param));
        return CommonResponse.success((Object)resp);
    }

    @GetMapping(value={"/pageRefer"})
    public CommonResponse<IPage<BusinessObjectEntity>> pageRefer(@RequestParam(value="pageNumber", required=false, defaultValue="1") int pageNumber, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="relyCondition", required=false) String relyCondition, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("createTime", "desc");
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        return CommonResponse.success(this.pageList(queryParam));
    }

    private IPage<BusinessObjectEntity> pageList(QueryParam queryParam) {
        return this.businessObjectService.queryPage(queryParam, false);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> del(@RequestBody Long id) {
        this.businessObjectService.removeById(id, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"detail"})
    public CommonResponse<BusinessObjectVO> detail(@RequestParam Long id) {
        BusinessObjectEntity entity = this.businessObjectService.queryDetail(id);
        if (null == entity) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
        }
        BusinessObjectVO vo = (BusinessObjectVO)BeanMapper.map((Object)((Object)entity), BusinessObjectVO.class);
        this.fillAttrDetail(vo);
        return CommonResponse.success((Object)vo);
    }

    private void fillAttrDetail(BusinessObjectVO vo) {
        CommonResponse projectResp = this.mdProjectApi.queryDetail(vo.getProjectId());
        CommonResponse clsResp = this.mdClassApi.queryDetail(vo.getEntityId());
        vo.setProject((MdProjectVO)projectResp.getData());
        vo.setEntity((MdClassVO)clsResp.getData());
        CommonResponse commonResponse = this.mdClassApi.queryCustomObjInfoByEntityId(vo.getEntityId());
        this.logger.info("\u6253\u5370\u6a21\u677f\uff0c\u67e5\u8be2\u6269\u5c55\u5b57\u6bb5\u4fe1\u606f\uff1a---{}", (Object)JSONObject.toJSONString((Object)commonResponse));
        if (commonResponse.getData() != null && ListUtil.isNotEmpty((List)((CustomObjVO)commonResponse.getData()).getCustomFieldList())) {
            List cfl = ((CustomObjVO)commonResponse.getData()).getCustomFieldList();
            String strContent = vo.getContent();
            if (StringUtils.isNotEmpty((CharSequence)strContent)) {
                JSONObject content = JSONObject.parseObject((String)strContent);
                JSONObject bo = content.getJSONObject("bo");
                JSONArray bo_attrs = bo.getJSONArray("bo_attrs");
                for (CustomFieldVO fieldVO : cfl) {
                    JSONObject attr = new JSONObject();
                    attr.put("code", (Object)fieldVO.getAttributeName());
                    attr.put("fieldname", (Object)fieldVO.getAttributeName());
                    attr.put("typename", (Object)fieldVO.getAttributeName());
                    attr.put("name", (Object)fieldVO.getDisplayName());
                    attr.put("fieldtype", (Object)"string");
                    attr.put("key", (Object)IdWorker.getId());
                    attr.put("type", (Object)"attr");
                    attr.put("dataFormat", (Object)"");
                    attr.put("sourceType", (Object)"");
                    attr.put("isPrimary", (Object)0);
                    if (bo_attrs == null) {
                        bo_attrs = new JSONArray();
                    }
                    boolean has = false;
                    for (Object bo_attr : bo_attrs) {
                        JSONObject a = (JSONObject)bo_attr;
                        if (!a.getString("fieldname").equals(fieldVO.getAttributeName())) continue;
                        has = true;
                    }
                    if (has) continue;
                    bo_attrs.add((Object)attr);
                }
                bo.put("bo_attrs", (Object)bo_attrs);
                JSONArray sub_bos = bo.getJSONArray("sub_bos");
                if (sub_bos != null && sub_bos.size() > 0) {
                    for (Object sub_bo : sub_bos) {
                        JSONObject subBo = (JSONObject)sub_bo;
                        if (bo.getString("bo_code").equals("ApproveInfo")) continue;
                        bo_attrs = subBo.getJSONArray("bo_attrs");
                        for (CustomFieldVO fieldVO : cfl) {
                            JSONObject attr = new JSONObject();
                            if (bo_attrs == null) {
                                bo_attrs = new JSONArray();
                            }
                            attr.put("code", (Object)fieldVO.getAttributeName());
                            attr.put("fieldname", (Object)fieldVO.getAttributeName());
                            attr.put("typename", (Object)fieldVO.getAttributeName());
                            attr.put("name", (Object)fieldVO.getDisplayName());
                            attr.put("fieldtype", (Object)"string");
                            attr.put("key", (Object)IdWorker.getId());
                            attr.put("type", (Object)"attr");
                            attr.put("dataFormat", (Object)"");
                            attr.put("sourceType", (Object)"");
                            attr.put("isPrimary", (Object)0);
                            boolean has = false;
                            for (Object bo_attr : bo_attrs) {
                                JSONObject a = (JSONObject)bo_attr;
                                if (!a.getString("fieldname").equals(fieldVO.getAttributeName())) continue;
                                has = true;
                            }
                            if (has) continue;
                            bo_attrs.add((Object)attr);
                        }
                        subBo.put("bo_attrs", (Object)bo_attrs);
                    }
                }
                bo.put("sub_bos", (Object)sub_bos);
                vo.setContent(content.toJSONString());
            }
        }
    }

    @GetMapping(value={"detailByBillType"})
    public CommonResponse<BusinessObjectVO> detailByBillType(@RequestParam String billTypeCode, @RequestParam(value="tenantId", required=false) Long tenantId, @RequestParam(value="contractCategoryId", required=false) String contractCategoryId, HttpServletRequest request) {
        CommonResponse mdReferVOResp = this.billTypeApi.queryMetadataByBillType(billTypeCode);
        if (!mdReferVOResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b\u7f16\u7801billTypeCode-{}\u83b7\u53d6\u5bf9\u5e94\u5143\u6570\u636e\u5931\u8d25,\u539f\u56e0:{}", (Object)billTypeCode, (Object)mdReferVOResp.getMsg());
            return CommonResponse.error((String)"\u6839\u636e\u5355\u636e\u7c7b\u578b\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25\uff01");
        }
        MdReferVO mdReferVO = (MdReferVO)mdReferVOResp.getData();
        BusinessObjectEntity entity = this.businessObjectService.getByEntityIdAndProjectId(mdReferVO.getMetadataId(), mdReferVO.getProjectId());
        if (null == entity) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
        }
        BusinessObjectVO vo = (BusinessObjectVO)BeanMapper.map((Object)((Object)entity), BusinessObjectVO.class);
        this.fillAttrDetail(vo);
        if (StringUtils.isNotBlank((CharSequence)vo.getContent())) {
            this.fillContractClauseMetadata(vo, request.getHeader("authority"), billTypeCode, contractCategoryId, mdReferVO);
        }
        return CommonResponse.success((Object)vo);
    }

    private void fillContractClauseMetadata(BusinessObjectVO vo, String authority, String billTypeCode, String contractCategoryId, MdReferVO mdReferVO) {
        try {
            String respStr;
            String entityNameFmt = mdReferVO.getEntityName().replace("Entity", "");
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("authority", authority);
            HashMap<String, String> params = new HashMap<String, String>();
            JSONObject clauseListJson = null;
            if (null != contractCategoryId) {
                params.put("categoryId", contractCategoryId);
                respStr = HttpTookit.get(this.environmentTools.getBaseHost() + "ejc-contractbase-web/api/clauseSetting/getListByCategoryId", params, header);
                this.logger.error("\u67e5\u8be2\u53ef\u7528\u5408\u540c\u6761\u6b3e\u7ed3\u679c\uff1a{} ", (Object)respStr);
                CommonResponse resp = (CommonResponse)JSONObject.parseObject((String)respStr, CommonResponse.class);
                if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
                    clauseListJson = new JSONObject();
                    ArrayList<JSONObject> attrs = new ArrayList<JSONObject>();
                    clauseListJson.put("bo_code", (Object)"ContractClause");
                    clauseListJson.put("bo_name", (Object)"\u5408\u540c\u6761\u6b3e");
                    clauseListJson.put("bo_attrs", attrs);
                    JSONObject tmp = null;
                    for (JSONObject clause : (List)resp.getData()) {
                        tmp = new JSONObject();
                        tmp.put("id", (Object)clause.getLong("id"));
                        tmp.put("code", (Object)("::clauseNameId$clauseContent$" + clause.getLong("id")));
                        tmp.put("fieldname", (Object)("::clauseNameId$clauseContent$" + clause.getLong("id")));
                        tmp.put("clauseCode", (Object)clause.getString("code"));
                        tmp.put("name", (Object)clause.getString("clauseName"));
                        tmp.put("type", (Object)"attr");
                        tmp.put("fieldtype", (Object)"text");
                        attrs.add(tmp);
                    }
                }
            } else {
                params.put("billType", billTypeCode);
                respStr = HttpTookit.get(this.environmentTools.getBaseHost() + mdReferVO.getProjectName() + "/" + entityNameFmt.substring(0, 1).toLowerCase() + entityNameFmt.substring(1) + "Clause/getContractClauses", params, header);
                this.logger.error("\u67e5\u8be2\u53ef\u7528\u5408\u540c\u6761\u6b3e\u7ed3\u679c\uff1a{} ", (Object)respStr);
                CommonResponse resp = (CommonResponse)JSONObject.parseObject((String)respStr, CommonResponse.class);
                if (resp.isSuccess() && null != resp.getData()) {
                    clauseListJson = (JSONObject)resp.getData();
                }
            }
            if (null != clauseListJson) {
                JSONObject content = JSONObject.parseObject((String)vo.getContent());
                content.getJSONObject("bo").getJSONArray("sub_bos").add((Object)clauseListJson);
                vo.setContent(JSONObject.toJSONString((Object)content));
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u53ef\u7528\u5408\u540c\u6761\u6b3e\u5f02\u5e38, ", (Throwable)e);
        }
    }

    @GetMapping(value={"detailByCode"})
    public CommonResponse<BusinessObjectVO> detailByCode(@RequestParam String code, @RequestParam(value="tenantId", required=false) Long tenantId) {
        BusinessObjectEntity entity = this.businessObjectService.getByCode(code);
        if (null == entity) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
        }
        BusinessObjectVO vo = (BusinessObjectVO)BeanMapper.map((Object)((Object)entity), BusinessObjectVO.class);
        this.fillAttrDetail(vo);
        return CommonResponse.success((Object)vo);
    }

    @GetMapping(value={"detailForDatav"})
    public CommonResponse<JSONArray> detailForDatav(@RequestParam Long id) {
        JSONArray resp = new JSONArray();
        BusinessObjectEntity entity = this.businessObjectService.queryDetail(id);
        if (null == entity) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getContent())) {
            JSONObject content = JSONObject.parseObject((String)entity.getContent());
            JSONObject boJson = JSONObject.parseObject((String)content.getString("bo"));
            this.formatBoData(boJson, resp);
        }
        return CommonResponse.success((Object)resp);
    }

    public void formatBoData(JSONObject boJson, JSONArray boArr) {
        JSONObject mainEntity = this.entityDataTranslate(boJson);
        boArr.add((Object)mainEntity);
        List attrs = JSONArray.parseArray((String)boJson.getString("bo_attrs"), JSONObject.class);
        ArrayList<JSONObject> children = new ArrayList<JSONObject>();
        for (JSONObject attr : attrs) {
            if (attr.containsKey((Object)"bo_attrs")) {
                this.parseEntityAttr(attr, boArr);
                continue;
            }
            children.add(this.attrDataTranslate(attr));
        }
        mainEntity.put("children", children);
        if (boJson.containsKey((Object)"sub_bos") && StringUtils.isNotBlank((CharSequence)boJson.getString("sub_bos"))) {
            List subBos = JSONArray.parseArray((String)boJson.getString("sub_bos"), JSONObject.class);
            for (JSONObject subBo : subBos) {
                this.formatBoData(subBo, boArr);
            }
        }
    }

    private JSONObject entityDataTranslate(JSONObject entityJson) {
        JSONObject resp = new JSONObject();
        String code = entityJson.getString("bo_code");
        code = code.indexOf(".") >= 0 ? code.substring(code.lastIndexOf(".") + 1) : code;
        resp.put("id", entityJson.get((Object)"key"));
        resp.put("code", (Object)code);
        resp.put("title", entityJson.get((Object)"bo_name"));
        resp.put("type", (Object)0);
        resp.put("isList", (Object)"1");
        resp.put("expand", (Object)true);
        resp.put("dataFormat", null);
        resp.put("fieldText", entityJson.get((Object)"bo_name"));
        resp.put("fieldtype", entityJson.get((Object)"fieldtype"));
        resp.put("sourceType", entityJson.get((Object)"sourceType"));
        return resp;
    }

    private JSONObject attrDataTranslate(JSONObject attr) {
        JSONObject resp = new JSONObject();
        resp.put("id", attr.get((Object)"key"));
        resp.put("code", attr.get((Object)"fieldname"));
        resp.put("title", attr.get((Object)"name"));
        resp.put("type", (Object)0);
        resp.put("isList", (Object)"1");
        resp.put("expand", (Object)true);
        resp.put("fieldtype", attr.get((Object)"fieldtype"));
        resp.put("sourceType", attr.get((Object)"sourceType"));
        resp.put("dataFormat", (Object)attr.getString("dataFormat"));
        resp.put("fieldText", attr.get((Object)"name"));
        return resp;
    }

    private void parseEntityAttr(JSONObject attrJson, JSONArray pChildren) {
        JSONObject resp = this.attrDataTranslate(attrJson);
        List attrs = JSONArray.parseArray((String)attrJson.getString("bo_attrs"), JSONObject.class);
        ArrayList<JSONObject> children = new ArrayList<JSONObject>();
        resp.put("children", children);
        pChildren.add((Object)resp);
        for (JSONObject attr : attrs) {
            if (attr.containsKey((Object)"bo_attrs")) {
                this.parseEntityAttr(attr, pChildren);
                continue;
            }
            children.add(this.attrDataTranslate(attr));
        }
    }

    @GetMapping(value={"boCheck"})
    public CommonResponse<BusinessObjectVO> boCheck(@RequestParam String code) {
        BusinessObjectVO vo = null;
        BusinessObjectEntity e = this.businessObjectService.getByCode(code);
        if (null != e) {
            vo = (BusinessObjectVO)BeanMapper.map((Object)((Object)e), BusinessObjectVO.class);
        }
        return CommonResponse.success(vo);
    }

    @ResponseBody
    @RequestMapping(value={"publish"})
    public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
        String targetEnv = publishVO.getTarget();
        if (StringUtils.isBlank((CharSequence)targetEnv)) {
            return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u76ee\u6807\u73af\u5883\u57df\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Long userId = this.getUserId(publishVO.getTarget());
        if (userId == null) {
            return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u8be5\u73af\u5883\u7684\u7528\u6237id!");
        }
        ArrayList<Long> ids = null;
        List baseEntities = null;
        if (publishVO.getIdList() == null || publishVO.getIdList().size() <= 0) {
            return CommonResponse.error((String)"\u672a\u9009\u4e2d\u8981\u53d1\u5e03\u7684\u6570\u636e");
        }
        baseEntities = (List)this.businessObjectService.listByIds(publishVO.getIdList());
        if (ids == null || ids.isEmpty()) {
            ids = new ArrayList<Long>(baseEntities.size());
            for (BusinessObjectEntity entity : baseEntities) {
                if (entity.getId() == null) continue;
                ids.add(entity.getId());
            }
        }
        if (baseEntities != null && baseEntities.size() > 0) {
            baseEntities.forEach(e -> {
                e.setCreateUserCode(null);
                e.setCreateTime(null);
                e.setUpdateUserCode(null);
                e.setUpdateTime(null);
            });
        }
        PublishDataVO publishDataVO = new PublishDataVO();
        publishDataVO.setBusinessObjectEntities(baseEntities);
        publishDataVO.setIds(ids);
        publishDataVO.setType("businessObject");
        String url = publishVO.getTarget() + "/ejc-print-web/dataTransfer/transferByData";
        String paramterStr = this.gson.toJson((Object)publishDataVO);
        this.logger.info("\u53d1\u5e03\u6570\u636e\u7684url\uff1a---------------" + url);
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            String contextUrl = publishVO.getTarget() + "/portal/usercontext/getcontext";
            HashMap<String, Long> contextParams = new HashMap<String, Long>();
            contextParams.put("userid", userId);
            String resultContext = HttpTookit.get(contextUrl, contextParams, headers);
            CommonResponse back = (CommonResponse)this.gson.fromJson(resultContext, CommonResponse.class);
            if (back.isSuccess()) {
                Map context = (Map)back.getData();
                String authority = "userType=" + context.get("userType") + ";userCode=" + context.get("userCode") + ";userName=" + context.get("userName") + ";orgId=" + context.get("orgId") + ";orgName=" + context.get("orgName") + ";tenantid=" + context.get("tenantid") + ";token=" + context.get("token") + ";u_logints=" + context.get("u_logints") + ";u_usercode=" + context.get("u_usercode") + ";userId=" + context.get("userId");
                headers.put("authority", authority);
                String result = HttpTookit.postByJson(url, paramterStr, headers);
                this.logger.info("\u53d1\u5e03\u6570\u636e\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
                return (CommonResponse)this.gson.fromJson(result, CommonResponse.class);
            }
            return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u83b7\u53d6\u5bf9\u5e94\u73af\u5883\u4e0a\u4e0b\u6587\u5931\u8d25");
        }
        catch (Exception e2) {
            try {
                e2.printStackTrace();
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25");
            }
            catch (Exception e3) {
                return CommonResponse.error((String)("\u53d1\u5e03\u6570\u636e\u5931\u8d25:" + e3.getMessage()));
            }
        }
    }

    private List<String> getDeleteSql(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        String idStr = "";
        for (Long id : ids) {
            idStr = idStr + "'" + id + "',";
        }
        idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
        String baseTableName = "ejc_print_business_object";
        String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr;
        sqlList.add(deleteBaseSql);
        return sqlList;
    }

    private List<String> getInsertSql(List<BusinessObjectEntity> baseEntityList) throws Exception {
        ArrayList<String> retList = new ArrayList<String>();
        List<String> baseInsertSql = DataTransferUtil.getInsertSql(baseEntityList);
        if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
            retList.addAll(baseInsertSql);
        }
        return retList;
    }

    private Long getUserId(String targetEnv) {
        Long userId = null;
        switch (targetEnv) {
            case "https://dev.17elian.com": {
                userId = 303581417601122400L;
                break;
            }
            case "https://portal.17elian.com": {
                userId = 303581417601122400L;
                break;
            }
            case "http://testqlh.baju.com.cn:8087": {
                userId = 303581417601122400L;
                break;
            }
            case "https://qlh.baju.com.cn": {
                userId = 303581417601122400L;
                break;
            }
            case "http://wei.cscec5b.com.cn:9082": {
                userId = 303581417601122400L;
                break;
            }
            case "http://wei.cscec5b.com.cn:9080": {
                userId = 303581417601122400L;
                break;
            }
            case "http://testpm.ynsbj.com": {
                userId = 303581417601122400L;
                break;
            }
            default: {
                userId = 303581417601122400L;
            }
        }
        return userId;
    }

    @ResponseBody
    @RequestMapping(value={"/exportSQL"})
    public void exportSQL(HttpServletRequest req, HttpServletResponse response, @RequestBody PublishVO publishVO) {
        try {
            ArrayList<Long> ids = null;
            ArrayList<String> codes = null;
            List baseEntities = null;
            if (publishVO.getIdList() == null || publishVO.getIdList().size() <= 0) {
                throw new BusinessException("\u672a\u9009\u4e2d\u8981\u5bfc\u51fa\u811a\u672c\u7684\u6570\u636e!");
            }
            baseEntities = (List)this.businessObjectService.listByIds(publishVO.getIdList());
            if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
                ids = new ArrayList<Long>(baseEntities.size());
                codes = new ArrayList<String>(baseEntities.size());
                for (BusinessObjectEntity entity : baseEntities) {
                    if (entity.getId() != null) {
                        ids.add(entity.getId());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)entity.getCode())) continue;
                    codes.add(entity.getCode());
                }
            }
            ArrayList<String> sqls = new ArrayList<String>();
            List<String> deleteSql = this.getDeleteSql(ids);
            List<String> insertSql = this.getInsertSql(baseEntities);
            if (deleteSql != null && !deleteSql.isEmpty()) {
                sqls.addAll(deleteSql);
            }
            if (insertSql != null && !insertSql.isEmpty()) {
                sqls.addAll(insertSql);
            }
            StringBuffer fileName = new StringBuffer();
            fileName.append("billType.sql");
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            out.write(String.join((CharSequence)"\r\n", sqls).getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            response.setStatus(400);
        }
    }
}

