/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.print.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.print.bean.NumberEntity;
import com.ejianc.foundation.print.bean.TemplateEntity;
import com.ejianc.foundation.print.mapper.NumberMapper;
import com.ejianc.foundation.print.service.INumberService;
import com.ejianc.foundation.print.service.ITemplateService;
import com.ejianc.foundation.print.vo.NumberVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="numberService")
public class NumberServiceImpl
extends BaseServiceImpl<NumberMapper, NumberEntity>
implements INumberService {
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private NumberMapper numberMapper;

    @Override
    public CommonResponse<NumberVO> printNumer(Long templateId, String templateCode, Long billId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"template_id", (Object)templateId);
        wrapper.eq((Object)"template_code", (Object)templateCode);
        wrapper.eq((Object)"bill_id", (Object)billId);
        wrapper.eq((Object)"dr", (Object)0);
        NumberEntity entity = (NumberEntity)((Object)this.getOne((Wrapper)wrapper));
        if (entity != null) {
            if (entity.getNumber() != null) {
                Long number = entity.getNumber() + 1L;
                entity.setNumber(number);
            } else {
                entity.setNumber(1L);
            }
        } else {
            entity = new NumberEntity();
            entity.setNumber(1L);
            entity.setTemplateCode(templateCode);
            entity.setTemplateId(templateId);
            entity.setUserId(InvocationInfoProxy.getUserid());
            entity.setBillId(billId);
        }
        this.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), NumberVO.class));
    }

    @Override
    public CommonResponse<List<NumberVO>> queryPrintNumerList(Long billId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"bill_id", (Object)billId);
        wrapper.eq((Object)"dr", (Object)0);
        List entitys = this.list((Wrapper)wrapper);
        List vos = new ArrayList();
        if (entitys != null && entitys.size() > 0) {
            vos = BeanMapper.mapList((Iterable)entitys, NumberVO.class);
            for (NumberVO vo : vos) {
                TemplateEntity template = this.templateService.detail(vo.getTemplateId());
                if (template == null) continue;
                vo.setTemplateName(template.getTemplateName());
            }
        }
        return CommonResponse.success(vos);
    }
}

