package com.ejianc.foundation.print.util;

import java.beans.Transient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;


import org.apache.commons.lang3.StringUtils;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 发布数据工具(仅适用单实体)
 * 
 * @author xg
 * @date 2018-05-14
 */
public class DataTransferUtil {

	public static final String DATA_TRANSFER_REST_URL2 = "/ejc-print-web/dataTransfer/transferByData";
	
	public static final String GETCONTEXT = "/portal/usercontext/getcontext";

	/**
	 * 获取实体所有的数据库字段
	 * 
	 * @param clazz
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	public static List<String> getAllDbFieldNames(Class clazz) {
		List<String> retList = new ArrayList<String>();
		List<Field> allFields = new ArrayList<Field>();
		List<Method> allMethods = new ArrayList<Method>();
		Field[] fields = clazz.getDeclaredFields();
		if (fields != null && fields.length > 0) {
			allFields.addAll(Arrays.asList(fields));
		}
		addParentFields(allFields, clazz);
		Method[] methods = clazz.getDeclaredMethods();
		if (methods != null && methods.length > 0) {
			allMethods.addAll(Arrays.asList(methods));
		}
		addParentMethods(allMethods, clazz);
		// 遍历属性
		for (Field field : allFields) {
			// 过滤掉不持久化的字段
			Transient t = field.getAnnotation(Transient.class);
			if (t != null) {
				continue;
			}
			TableField column = field.getAnnotation(TableField.class);
			if (column != null) {
				String dbFieldName = null;
				if (StringUtils.isBlank(column.value())) {
					dbFieldName = field.getName();
				} else {
					dbFieldName = column.value();
				}
				retList.add(dbFieldName);
			}
		}
		// 遍历getter方法
		String rule = "get(\\w+)";
		Pattern getterMethod = Pattern.compile(rule);
		for (Method method : allMethods) {
			String methodName = method.getName();
			if (!getterMethod.matcher(methodName).matches()) { // 不是getter方法
				continue;
			}
			Transient t = method.getAnnotation(Transient.class);
			if (t != null) {
				continue;
			}
			TableField column = method.getAnnotation(TableField.class);
			if (column != null) {
				String dbFieldName = null;
				String fieldName = toLowerCaseFirstOne(methodName.substring(3));
				if (StringUtils.isBlank(column.value())) {
					dbFieldName = fieldName;
				} else {
					dbFieldName = column.value();
				}
				retList.add(dbFieldName);
			}
		}
		return retList;
	}

	/**
	 * 获取数据库字段与实体属性名的映射
	 * 
	 * @param clazz
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	public static Map<String, String> getColumnFieldMap(Class clazz) {
		Map<String, String> retMap = new HashMap<String, String>();
		List<Field> allFields = new ArrayList<Field>();
		List<Method> allMethods = new ArrayList<Method>();
		Field[] fields = clazz.getDeclaredFields();
		if (fields != null && fields.length > 0) {
			allFields.addAll(Arrays.asList(fields));
		}
		addParentFields(allFields, clazz);
		Method[] methods = clazz.getDeclaredMethods();
		if (methods != null && methods.length > 0) {
			allMethods.addAll(Arrays.asList(methods));
		}
		addParentMethods(allMethods, clazz);
		// 遍历属性
		for (Field field : allFields) {
			// 过滤掉不持久化的字段
			Transient t = field.getAnnotation(Transient.class);
			if (t != null) {
				continue;
			}
			// 过滤掉不进行同步的字段
			TableField utf = field.getAnnotation(TableField.class);
			if (utf != null && !utf.exist()) {
				continue;
			}
			TableField column = field.getAnnotation(TableField.class);
			if (column != null) {
				String dbFieldName = null;
				if (StringUtils.isBlank(column.value())) {
					dbFieldName = field.getName();
				} else {
					dbFieldName = column.value();
				}
				retMap.put(dbFieldName, field.getName());
			}
		}
		// 遍历getter方法
		String rule = "get(\\w+)";
		Pattern getterMethod = Pattern.compile(rule);
		for (Method method : allMethods) {
			String methodName = method.getName();
			if (!getterMethod.matcher(methodName).matches()) { // 不是getter方法
				continue;
			}
			Transient t = method.getAnnotation(Transient.class);
			if (t != null) {
				continue;
			}
//			UnTransferField utf = method.getAnnotation(UnTransferField.class);
//			if (utf != null) {
//				continue;
//			}
			TableField column = method.getAnnotation(TableField.class);
			if (column != null) {
				String dbFieldName = null;
				String fieldName = toLowerCaseFirstOne(methodName.substring(3));
				if (StringUtils.isBlank(column.value())) {
					dbFieldName = fieldName;
				} else {
					dbFieldName = column.value();
				}
				retMap.put(dbFieldName, fieldName);
			}
		}
		return retMap;
	}

	/**
	 * 获取实体对应的表名
	 * 
	 * @param clazz
	 * @return
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static String getTableName(Class clazz) {
		if (clazz == null) {
			return null;
		}
		Annotation anno = clazz.getAnnotation(TableName.class);
		if (anno == null) {
			return null;
		}
		TableName table = (TableName) anno;
		return table.value();
	}

	/**
	 * 获取两个List中的差异元素
	 * 
	 * @param source
	 * @param target
	 * @return
	 */
	public static List<String> getDiffrent(List<String> source, List<String> target) {
		Map<String, Integer> map = new HashMap<String, Integer>(source.size() + target.size());
		List<String> diff = new ArrayList<String>();
		for (String str : source) {
			if (!map.containsKey(str)) {
				map.put(str, 1);
			}
		}
		for (String str : target) {
			Integer cc = map.get(str);
			if (cc != null) {
				map.put(str, ++cc);
				continue;
			}
			map.put(str, 1);
		}
		for (Map.Entry<String, Integer> entry : map.entrySet()) {
			if (entry.getValue() == 1) {
				diff.add(entry.getKey());
			}
		}
		return diff;
	}

	/**
	 * 获取父类的属性(递归方式)
	 * 
	 * @param fields
	 * @param clazz
	 */
	@SuppressWarnings("rawtypes")
	public static void addParentFields(List<Field> fields, Class clazz) {
		if (clazz != null && clazz.getSuperclass() != null) {
			Field[] fs = clazz.getSuperclass().getDeclaredFields();
			if (fs != null && fs.length > 0) {
				fields.addAll(Arrays.asList(fs));
			}
			addParentFields(fields, clazz.getSuperclass());
		}
	}

	/**
	 * 获取父类的方法(递归方式)
	 * 
	 * @param methods
	 * @param clazz
	 */
	@SuppressWarnings("rawtypes")
	public static void addParentMethods(List<Method> methods, Class clazz) {
		if (clazz != null && clazz.getSuperclass() != null) {
			Method[] ms = clazz.getSuperclass().getDeclaredMethods();
			if (ms != null && ms.length > 0) {
				methods.addAll(Arrays.asList(ms));
			}
			addParentMethods(methods, clazz.getSuperclass());
		}
	}

	/**
	 * 首字母小写
	 * 
	 * @param str
	 * @return
	 */
	public static String toLowerCaseFirstOne(String str) {
		if (StringUtils.isBlank(str) || Character.isLowerCase(str.charAt(0))) {
			return str;
		}
		return Character.toLowerCase(str.charAt(0)) + str.substring(1);
	}

	/**
	 * 构造insert语句
	 * 
	 * @param data
	 * @return
	 * @throws SecurityException 
	 * @throws NoSuchMethodException 
	 * @throws InvocationTargetException 
	 * @throws IllegalArgumentException 
	 * @throws IllegalAccessException 
	 */
	public static List<String> getInsertSql(List<? extends BaseEntity> entities) throws NoSuchFieldException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
		if (entities == null || entities.isEmpty()) {
			return null;
		}
		List<String> retList = new ArrayList<String>(entities.size());
		Class<? extends BaseEntity> clazz = entities.get(0).getClass();
		String tableName = getTableName(clazz);
		StringBuffer sql = null;
		Map<String, String> columnFieldMap = getColumnFieldMap(clazz);
		Set<String> keys = columnFieldMap.keySet();
		String[] dbFields = keys.toArray(new String[keys.size()]);
		for (BaseEntity entity : entities) {
			sql = new StringBuffer(" insert into " + tableName + "(");
			for (int i = 0; i < dbFields.length; i++) {
				sql.append("`"+dbFields[i]+"`");
				if (dbFields.length - 1 != i) {
					sql.append(",");
				}
			}
			sql.append(") values ");
			sql.append("(");
			for (int j = 0; j < dbFields.length; j++) {
				String fieldName = columnFieldMap.get(dbFields[j]);
				
				/** 获取get方法*/
				Method m =  clazz.getMethod("get"+fieldName.substring(0,1).toUpperCase()+fieldName.substring(1),  null);
				/** 获取数据 */
				Object fieldValue = m.invoke(entity, (Object[]) null);
				
//				Object fieldValue = entity.getAttributeValue(fieldName);
				if ("dr".equalsIgnoreCase(fieldName)) { // 偷懒, 不想递归去获取父类这个属性
					sql.append(fieldValue);
					if (dbFields.length - 1 != j) {
						sql.append(",");
					}
					continue;
				}
				Field field = null;
				String fieldType = null;
				if(isBaseFileds(fieldName)){
					field = clazz.getSuperclass().getDeclaredField(fieldName);
				}else{
					field = clazz.getDeclaredField(fieldName);
				}
				if (field != null) {
					fieldType = field.getGenericType().getTypeName();
				}
				if (Integer.class.getTypeName().equalsIgnoreCase(fieldType)) {
					sql.append(fieldValue);
				} else if (Long.class.getTypeName().equalsIgnoreCase(fieldType)) {
					sql.append(fieldValue);
				} else if (Boolean.class.getTypeName().equalsIgnoreCase(fieldType)) {
					if (fieldValue == null) {
						sql.append(fieldValue);
					} else if ("flase".equalsIgnoreCase(fieldValue.toString())) {
						sql.append(0);
					} else if ("true".equalsIgnoreCase(fieldValue.toString())) {
						sql.append(1);
					} else {
						sql.append(fieldValue);
					}
				} else if (boolean.class.getTypeName().equalsIgnoreCase(fieldType)) {
					if (fieldValue == null) {
						sql.append(fieldValue);
					} else if ("flase".equalsIgnoreCase(fieldValue.toString())) {
						sql.append(0);
					} else if ("true".equalsIgnoreCase(fieldValue.toString())) {
						sql.append(1);
					} else {
						sql.append(fieldValue);
					}
				} else if (Date.class.getTypeName().equalsIgnoreCase(fieldType)) {
					if (fieldValue != null) {
						SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
						fieldValue = sdf.format(fieldValue);
						sql.append("'").append(fieldValue).append("'");
					} else {
						sql.append(fieldValue);
					}
				}  else if (java.util.Date.class.getTypeName().equalsIgnoreCase(fieldType)) {
					if (fieldValue != null) {
						SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
						fieldValue = sdf.format(fieldValue);
						sql.append("'").append(fieldValue).append("'");
					} else {
						sql.append(fieldValue);
					}
				} else {
					sql.append("'");
					if (fieldValue != null) {
						//当含有特殊字符如'等
						if(fieldValue.toString().contains("'")){
							sql.append(fieldValue.toString().replaceAll("'", "\\\\'"));
						}else{
							//当字段为createUserCode或updateUserCode时数据为null（一般情况下人员code是不一样的）
							if("createUserCode".equals(fieldName)||"updateUserCode".equals(fieldName)){
								
							}else{
								sql.append(fieldValue);
							}
						}
					}
					sql.append("'");
				}
				if (dbFields.length - 1 != j) {
					sql.append(",");
				}
			}
			sql.append(")");
			retList.add(sql.toString());
		}
		return retList;
	}


	/**
	 * 构造insert语句
	 * 
	 * @param data,orgId
	 * @return
	 * @throws SecurityException 
	 * @throws NoSuchMethodException 
	 * @throws InvocationTargetException 
	 * @throws IllegalArgumentException 
	 * @throws IllegalAccessException 
	 */
	public static List<String> getInsertSql2(List<? extends BaseEntity> entities, Long orgId) throws NoSuchFieldException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
		if (entities == null || entities.isEmpty()) {
			return null;
		}
		List<String> retList = new ArrayList<String>(entities.size());
		Class<? extends BaseEntity> clazz = entities.get(0).getClass();
		String tableName = getTableName(clazz);
		StringBuffer sql = null;
		Map<String, String> columnFieldMap = getColumnFieldMap(clazz);
		Set<String> keys = columnFieldMap.keySet();
		String[] dbFields = keys.toArray(new String[keys.size()]);
		for (BaseEntity entity : entities) {
			sql = new StringBuffer(" insert into " + tableName + "(");
			for (int i = 0; i < dbFields.length; i++) {
				sql.append("`"+dbFields[i]+"`");
				if (dbFields.length - 1 != i) {
					sql.append(",");
				}
			}
			sql.append(") values ");
			sql.append("(");
			for (int j = 0; j < dbFields.length; j++) {
				String fieldName = columnFieldMap.get(dbFields[j]);
				
				/** 获取get方法*/
				Method m =  clazz.getMethod("get"+fieldName.substring(0,1).toUpperCase()+fieldName.substring(1),  null);
				/** 获取数据 */
				Object fieldValue = m.invoke(entity, (Object[]) null);
				
//				Object fieldValue = entity.getAttributeValue(fieldName);
				if ("dr".equalsIgnoreCase(fieldName)) { // 偷懒, 不想递归去获取父类这个属性
					sql.append(fieldValue);
					if (dbFields.length - 1 != j) {
						sql.append(",");
					}
					continue;
				}
				Field field = null;
				String fieldType = null;
				if(isBaseFileds(fieldName)){
					field = clazz.getSuperclass().getDeclaredField(fieldName);
				}else{
					field = clazz.getDeclaredField(fieldName);
				}
				if (field != null) {
					fieldType = field.getGenericType().getTypeName();
				}
				if (Integer.class.getTypeName().equalsIgnoreCase(fieldType)) {
					sql.append(fieldValue);
				} else if (Long.class.getTypeName().equalsIgnoreCase(fieldType)) {
					if("orgId".equals(fieldName)){
						sql.append(orgId);
					}else{
						sql.append(fieldValue);
					}
				} else if (Boolean.class.getTypeName().equalsIgnoreCase(fieldType)) {
					if (fieldValue == null) {
						sql.append(fieldValue);
					} else if ("flase".equalsIgnoreCase(fieldValue.toString())) {
						sql.append(0);
					} else if ("true".equalsIgnoreCase(fieldValue.toString())) {
						sql.append(1);
					} else {
						sql.append(fieldValue);
					}
				} else if (boolean.class.getTypeName().equalsIgnoreCase(fieldType)) {
					if (fieldValue == null) {
						sql.append(fieldValue);
					} else if ("flase".equalsIgnoreCase(fieldValue.toString())) {
						sql.append(0);
					} else if ("true".equalsIgnoreCase(fieldValue.toString())) {
						sql.append(1);
					} else {
						sql.append(fieldValue);
					}
				} else if (Date.class.getTypeName().equalsIgnoreCase(fieldType)) {
					if (fieldValue != null) {
						SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
						fieldValue = sdf.format(fieldValue);
						sql.append("'").append(fieldValue).append("'");
					} else {
						sql.append(fieldValue);
					}
				}  else if (java.util.Date.class.getTypeName().equalsIgnoreCase(fieldType)) {
					if (fieldValue != null) {
						SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
						fieldValue = sdf.format(fieldValue);
						sql.append("'").append(fieldValue).append("'");
					} else {
						sql.append(fieldValue);
					}
				} else {
					sql.append("'");
					if (fieldValue != null) {
						//当含有特殊字符如'等
						if(fieldValue.toString().contains("'")){
							sql.append(fieldValue.toString().replaceAll("'", "\\\\'"));
						}else{
							//当字段为createUserCode或updateUserCode时数据为null（一般情况下人员code是不一样的）
							if("createUserCode".equals(fieldName)||"updateUserCode".equals(fieldName)){
								
							}else{
								sql.append(fieldValue);
							}
						}
					}
					sql.append("'");
				}
				if (dbFields.length - 1 != j) {
					sql.append(",");
				}
			}
			sql.append(")");
			retList.add(sql.toString());
		}
		return retList;
	}
	public static boolean isBaseFileds (String filed){
		boolean flag = false;
		switch(filed){
			case "id":
				flag = true;
				break;
			case "createUserCode":
				flag = true;
				break;
			case "createTime":
				flag = true;
				break;
			case "updateUserCode":
				flag = true;
				break;
			case "updateTime":
				flag = true;
				break;
			case "dr":
				flag = true;
				break;
			case "tenantId":
				flag = true;
				break;
			case "syncEsFlag":
				flag = true;
				break;
			case "version":
				flag = true;
				break;
			default: 
				break;
		}
		return flag;
	}
}
