package com.ejianc.foundation.print.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.print.bean.NumberEntity;
import com.ejianc.foundation.print.bean.TemplateEntity;
import com.ejianc.foundation.print.mapper.NumberMapper;
import com.ejianc.foundation.print.service.INumberService;
import com.ejianc.foundation.print.service.ITemplateService;
import com.ejianc.foundation.print.vo.NumberVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("numberService")
public class NumberServiceImpl extends BaseServiceImpl<NumberMapper, NumberEntity> implements INumberService {

    @Autowired
    private ITemplateService templateService;
    @Autowired
    private NumberMapper numberMapper;

    @Override
    public CommonResponse<NumberVO> printNumer(Long templateId, String templateCode, Long billId) {
        QueryWrapper<NumberEntity> wrapper = new QueryWrapper();
        wrapper.eq("template_id", templateId);
        wrapper.eq("template_code", templateCode);
        wrapper.eq("bill_id", billId);
        wrapper.eq("dr", 0);
        NumberEntity entity = this.getOne(wrapper);
        if(entity!=null){
            if(entity.getNumber()!=null){
                Long number = entity.getNumber() + 1;
                entity.setNumber(number);
            }else{
                entity.setNumber(1l);
            }
        }else{
            entity = new NumberEntity();
            entity.setNumber(1l);
            entity.setTemplateCode(templateCode);
            entity.setTemplateId(templateId);
            entity.setUserId(InvocationInfoProxy.getUserid());
            entity.setBillId(billId);
        }
        this.saveOrUpdate(entity, false);
        return CommonResponse.success(BeanMapper.map(entity, NumberVO.class));
    }

    @Override
    public CommonResponse<List<NumberVO>> queryPrintNumerList(Long billId) {
        QueryWrapper<NumberEntity> wrapper = new QueryWrapper();
        wrapper.eq("bill_id", billId);
        wrapper.eq("dr", 0);
        List<NumberEntity> entitys = this.list(wrapper);
        List<NumberVO> vos = new ArrayList<>();
        if(entitys!=null && entitys.size()>0){
            vos = BeanMapper.mapList(entitys, NumberVO.class);
            for(NumberVO vo : vos){
                TemplateEntity template = templateService.detail(vo.getTemplateId());
                if(template!=null){
                    vo.setTemplateName(template.getTemplateName());
                }
            }
        }
        return CommonResponse.success(vos);
    }
}
