package com.ejianc.business.riskmargin.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 风险保证金
 *
 * @author CJ
 * @Description:
 * @date 2021/7/19 11:31
 */
public class RiskMarginVO extends BaseVO {
    private static final long serialVersionUID = -2580747703542601693L;

    /**
     * 保证金类型：扣保证金
     */
    public static final String BILL_TYPE_DEDUCT_CASH_DEPOSIT = "1";
    /**
     * 保证金类型：退保证金
     */
    public static final String BILL_TYPE_BACK_CASH_DEPOSIT = "2";
    /**
     * 保证金单据来源：自动生成
     */
    public static final String SOURCE_TYPE_AUTOG_ENERATION = "1";
    /**
     * 保证金单据来源：手动生成
     */
    public static final String SOURCE_TYPE_BACK_MAUAL_ENERATION = "2";

    /**
     * 单据编号
     */
    private String billCode;

    /**
     * 单据类型: 1-扣保证金，2-退保证金
     */
    private String billType;

    /**
     * 单据来源：1-自动生成，2-手动生成
     */
    private String sourceType;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 申请主题
     */
    private String applySubject;

    /**
     * 申请金额
     */
    private BigDecimal applyAmt;

    /**
     * 申请日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date applyDate;

    /**
     * 经办人Id
     */
    private Long operatorId;

    /**
     * 经办人名称
     */
    private String operatorName;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 备注
     */
    private String remark;

    /**
     * 所属项目Id
     */
    private Long projectId;

    /**
     * 累计扣保证金
     */
    private BigDecimal totalDeductCashDeposit;

    /**
     * 累计退保证金
     */
    private BigDecimal totalBackCashDeposit;

    /**
     * 保证金结余
     */
    private BigDecimal spareDepositAmt;

    /**
     * 剩余可退金额
     */
    private BigDecimal remremainingRefundableAmt;

    /**
     * 所属组织Id
     */
    private Long orgId;

    /**
     * 所属组织名称
     */
    private String orgName;

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getTotalDeductCashDeposit() {
        return totalDeductCashDeposit;
    }

    public void setTotalDeductCashDeposit(BigDecimal totalDeductCashDeposit) {
        this.totalDeductCashDeposit = totalDeductCashDeposit;
    }

    public BigDecimal getTotalBackCashDeposit() {
        return totalBackCashDeposit;
    }

    public void setTotalBackCashDeposit(BigDecimal totalBackCashDeposit) {
        this.totalBackCashDeposit = totalBackCashDeposit;
    }

    public BigDecimal getSpareDepositAmt() {
        return spareDepositAmt;
    }

    public void setSpareDepositAmt(BigDecimal spareDepositAmt) {
        this.spareDepositAmt = spareDepositAmt;
    }

    public BigDecimal getRemremainingRefundableAmt() {
        return remremainingRefundableAmt;
    }

    public void setRemremainingRefundableAmt(BigDecimal remremainingRefundableAmt) {
        this.remremainingRefundableAmt = remremainingRefundableAmt;
    }

    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getApplySubject() {
        return applySubject;
    }

    public void setApplySubject(String applySubject) {
        this.applySubject = applySubject;
    }

    public BigDecimal getApplyAmt() {
        return applyAmt;
    }

    public void setApplyAmt(BigDecimal applyAmt) {
        this.applyAmt = applyAmt;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    @ReferDeserialTransfer
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
