package com.ejianc.business.prjfinance.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目收支台账 -- 联营费用VO
 */
public class OperationCostVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 实际业务单据id
     */
    private Long id;

    /**
     * 穿透的业务单据id
     */
    private Long billId;

    /**
     * 业务单据编码
     */
    private String opbillCode;


    /**
     * 业务单据名称
     */
    private String billName;

    /**
     * 费用类型
     */
    private String costType;

    /**
     * 金额
     */
    private BigDecimal mny;

    /**
     * 经办人
     */
    private String employeeId;

    /**
     * 经办人
     */
    private String employeeName;

    /**
     * 经办时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate;

    /**
     * 联营费用
     */
    private BigDecimal costMny;

    public Long getBillId() {
        return billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOpbillCode() {
        return opbillCode;
    }

    public void setOpbillCode(String opbillCode) {
        this.opbillCode = opbillCode;
    }

    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }

    public String getCostType() {
        return costType;
    }

    public void setCostType(String costType) {
        this.costType = costType;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public String getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
}
