package com.ejianc.business.prjfinance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 项目借款
 * 
 * @author generator
 * 
 */
public class ProjectLoanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private String name; // 主题
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private BigDecimal loanMoney; // 借款金额
    private BigDecimal returnMoney; // 本单据累计已还金额
    private BigDecimal loanMoneyLeft; // 本单据借款结余
    private BigDecimal interest; // 本单据累计已结利息
    private Long agentId; // 经办人id
    private String agentName; // 经办人姓名
    private String memo; // 备注
    private Long interestTypeId; // 计息方式id
    private String interestTypeName; // 计息方式名称
    private String interestMemo; // 计息描述
    private BigDecimal yearInterest; // 年利率
    /**
     * 单据状态名称
     */
    private String billStateName;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startInterest; // 计息开始日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planReturnDate; // 计划还款日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date processDate; // 办理日期
    private BigDecimal totalLoanMoney; // 累计借款金额
    private BigDecimal totalReturnMoney; // 累计还款金额
    private BigDecimal totalLoanBalance; // 累计借款结余
    private Integer loanMoneyYornState;



    /**
     * 所属组织Id
     */
    private Long orgId;

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 主题
     */
    public String getName() {
        return name;
    }

    /**
     * 主题
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 借款金额
     */
    public BigDecimal getLoanMoney() {
        return loanMoney;
    }

    /**
     * 借款金额
     */
    public void setLoanMoney(BigDecimal loanMoney) {
        this.loanMoney = loanMoney;
    }
    /**
     * 已还金额
     */
    public BigDecimal getReturnMoney() {
        return returnMoney;
    }

    /**
     * 已还金额
     */
    public void setReturnMoney(BigDecimal returnMoney) {
        this.returnMoney = returnMoney;
    }
    /**
     * 已结利息
     */
    public BigDecimal getInterest() {
        return interest;
    }

    /**
     * 已结利息
     */
    public void setInterest(BigDecimal interest) {
        this.interest = interest;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 计息方式id
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getInterestTypeId() {
        return interestTypeId;
    }

    /**
     * 计息方式id
     */
    @ReferDeserialTransfer
    public void setInterestTypeId(Long interestTypeId) {
        this.interestTypeId = interestTypeId;
    }
    /**
     * 计息方式名称
     */
    public String getInterestTypeName() {
        return interestTypeName;
    }

    /**
     * 计息方式名称
     */
    public void setInterestTypeName(String interestTypeName) {
        this.interestTypeName = interestTypeName;
    }
    /**
     * 计息描述
     */
    public String getInterestMemo() {
        return interestMemo;
    }

    /**
     * 计息描述
     */
    public void setInterestMemo(String interestMemo) {
        this.interestMemo = interestMemo;
    }
    /**
     * 年利率
     */
    public BigDecimal getYearInterest() {
        return yearInterest;
    }

    /**
     * 年利率
     */
    public void setYearInterest(BigDecimal yearInterest) {
        this.yearInterest = yearInterest;
    }
    /**
     * 计息开始日期
     */
    public Date getStartInterest() {
        return startInterest;
    }

    /**
     * 计息开始日期
     */
    public void setStartInterest(Date startInterest) {
        this.startInterest = startInterest;
    }
    /**
     * 计划还款日期
     */
    public Date getPlanReturnDate() {
        return planReturnDate;
    }

    /**
     * 计划还款日期
     */
    public void setPlanReturnDate(Date planReturnDate) {
        this.planReturnDate = planReturnDate;
    }
    /**
     * 办理日期
     */
    public Date getProcessDate() {
        return processDate;
    }

    /**
     * 办理日期
     */
    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }
    /**
     * 累计借款金额
     */
    public BigDecimal getTotalLoanMoney() {
        return totalLoanMoney;
    }

    /**
     * 累计借款金额
     */
    public void setTotalLoanMoney(BigDecimal totalLoanMoney) {
        this.totalLoanMoney = totalLoanMoney;
    }
    /**
     * 累计还款金额
     */
    public BigDecimal getTotalReturnMoney() {
        return totalReturnMoney;
    }

    /**
     * 累计还款金额
     */
    public void setTotalReturnMoney(BigDecimal totalReturnMoney) {
        this.totalReturnMoney = totalReturnMoney;
    }
    /**
     * 累计借款结余
     */
    public BigDecimal getTotalLoanBalance() {
        return totalLoanBalance;
    }

    /**
     * 累计借款结余
     */
    public void setTotalLoanBalance(BigDecimal totalLoanBalance) {
        this.totalLoanBalance = totalLoanBalance;
    }

    public BigDecimal getLoanMoneyLeft() {
         return this.loanMoneyLeft;
    }

    public void setLoanMoneyLeft(BigDecimal loanMoneyLeft) {
        this.loanMoneyLeft = loanMoneyLeft;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Integer getLoanMoneyYornState() {
        return loanMoneyYornState;
    }

    public void setLoanMoneyYornState(Integer loanMoneyYornState) {
        this.loanMoneyYornState = loanMoneyYornState;
    }

}
