package com.ejianc.business.prjfinance.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目还款
 * 
 * @author generator
 * 
 */
public class ReturnMoneyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private String name; // 单据名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private BigDecimal totalLoanBalance; // 累计借款结余
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date dealDate; // 办理日期
    private BigDecimal currentTotalReturn; // 本期退还金额
    private Long dealPersonId; // 经办人id
    private String dealPerson; // 经办人
    private String memo; // 备注
    /**
     * 单据状态名称
     */
    private String billStateName;
    
    private List<ReturnMoneySubVO> returnMoneySubEntities = new ArrayList<>(); // 项目还款子表

    /**
     * 所属组织Id
     */
    private Long orgId;

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 单据名称
     */
    public String getName() {
        return name;
    }

    /**
     * 单据名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 累计借款结余
     */
    public BigDecimal getTotalLoanBalance() {
        return totalLoanBalance;
    }

    /**
     * 累计借款结余
     */
    public void setTotalLoanBalance(BigDecimal totalLoanBalance) {
        this.totalLoanBalance = totalLoanBalance;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 办理日期
     */
    public Date getDealDate() {
        return dealDate;
    }

    /**
     * 办理日期
     */
    public void setDealDate(Date dealDate) {
        this.dealDate = dealDate;
    }
    /**
     * 本期退还金额
     */
    public BigDecimal getCurrentTotalReturn() {
        return currentTotalReturn;
    }

    /**
     * 本期退还金额
     */
    public void setCurrentTotalReturn(BigDecimal currentTotalReturn) {
        this.currentTotalReturn = currentTotalReturn;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getDealPersonId() {
        return dealPersonId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setDealPersonId(Long dealPersonId) {
        this.dealPersonId = dealPersonId;
    }
    /**
     * 经办人
     */
    public String getDealPerson() {
        return dealPerson;
    }

    /**
     * 经办人
     */
    public void setDealPerson(String dealPerson) {
        this.dealPerson = dealPerson;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<ReturnMoneySubVO> getReturnMoneySubEntities() {
        return returnMoneySubEntities;
    }

    public void setReturnMoneySubEntities(List<ReturnMoneySubVO> returnMoneySubEntities) {
        this.returnMoneySubEntities = returnMoneySubEntities;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}
