package com.ejianc.business.prjfinance.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.prjfinance.bean.ReturnMoneySubEntity;
/**
 * 项目还款
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prjfinance_return_mny")
public class ReturnMoneyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="total_loan_balance")
    private BigDecimal totalLoanBalance; // 累计借款结余
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="deal_date")
    private Date dealDate; // 办理日期
    @TableField(value="current_total_return")
    private BigDecimal currentTotalReturn; // 本期退还金额
    @TableField(value="deal_person_id")
    private Long dealPersonId; // 经办人id
    @TableField(value="deal_person")
    private String dealPerson; // 经办人
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(exist=false)
    @SubEntity(serviceName="returnMoneySubService")
    private List<ReturnMoneySubEntity> returnMoneySubEntities = new ArrayList<>(); // 项目还款子表
    

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 单据名称
     */
    public String getName() {
        return name;
    }

    /**
     * 单据名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 累计借款结余
     */
    public BigDecimal getTotalLoanBalance() {
        return totalLoanBalance;
    }

    /**
     * 累计借款结余
     */
    public void setTotalLoanBalance(BigDecimal totalLoanBalance) {
        this.totalLoanBalance = totalLoanBalance;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 办理日期
     */
    public Date getDealDate() {
        return dealDate;
    }

    /**
     * 办理日期
     */
    public void setDealDate(Date dealDate) {
        this.dealDate = dealDate;
    }
    /**
     * 本期退还金额
     */
    public BigDecimal getCurrentTotalReturn() {
        return currentTotalReturn;
    }

    /**
     * 本期退还金额
     */
    public void setCurrentTotalReturn(BigDecimal currentTotalReturn) {
        this.currentTotalReturn = currentTotalReturn;
    }
    /**
     * 经办人id
     */
    public Long getDealPersonId() {
        return dealPersonId;
    }

    /**
     * 经办人id
     */
    public void setDealPersonId(Long dealPersonId) {
        this.dealPersonId = dealPersonId;
    }
    /**
     * 经办人
     */
    public String getDealPerson() {
        return dealPerson;
    }

    /**
     * 经办人
     */
    public void setDealPerson(String dealPerson) {
        this.dealPerson = dealPerson;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
    /**
     * 项目还款子表
     */
    public List<ReturnMoneySubEntity> getReturnMoneySubEntities() {
        return returnMoneySubEntities;
    }

    /**
     * 项目还款子表
     */
    public void setReturnMoneySubEntities(List<ReturnMoneySubEntity> returnMoneySubEntities) {
        this.returnMoneySubEntities = returnMoneySubEntities;
    }
}
