package com.ejianc.business.prjfinance.service;

import com.ejianc.business.prjfinance.bean.RiskMarginEntity;
import com.ejianc.business.prjfinance.vo.RiskMarginVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/7/19 11:32
 */
public interface IRiskMarginService extends IBaseService<RiskMarginEntity> {

    /**
     * 查询指定项目的风险保证金情况
     *
     * @param projectId
     * @return
     */
    Map<String, BigDecimal> getProjectCashDepositInfo(Long projectId);

    /**
     * 根据条件统计累计扣保证金以及累计退保证金
     *
     * @param queryParam
     * @return
     */
    Map<String, BigDecimal> sumCashDeposit(QueryParam queryParam);

    /**
     * 根据项目Id和单据类型查询符合条件的保证金单据列表
     *
     * @param projectId
     * @param billType
     * @param billId 要排除的单据ID
     * @return
     */
    List<RiskMarginVO> freeBillListByPrjId(Long projectId, String billType, Long billId);
}
