package com.ejianc.business.prjfinance.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.api.IReceiveManageApi;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterChangeClauseEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterChangeCostlistEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterChangeEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterClauseEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterCostlistEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterRecordClauseEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterRecordCostlistEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterRecordEntity;
import com.ejianc.business.prjfinance.bean.RiskMarginEntity;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterChangeService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterClauseService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterCostlistService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterRecordService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.service.IRiskMarginService;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterChangeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("projectDutyLetter")
public class ProjectDutyLetterBpmService implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String RISK_BILL_CODE_RULE = "RISK_MARGIN_01";

    @Autowired
    IProjectDutyLetterChangeService projectDutyLetterChangeService;

    @Autowired
    IProjectDutyLetterRecordService projectDutyLetterRecordService;

    @Autowired
    IProjectDutyLetterService projectDutyLetterService;

    @Autowired
    IProjectDutyLetterClauseService projectDutyLetterClauseService;

    @Autowired
    IProjectDutyLetterCostlistService projectDutyLetterCostlistService;
    
    @Autowired
    private IReceiveManageApi receiveManageApi;
    
    @Autowired
    private IRiskMarginService riskMarginService;
    
    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private IBillTypeApi billTypeApi;
    
	/**
	 * 审批节点审批中时节点审批后回调
	 * 
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
    @Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};
	
    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
    @Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
    	logger.info("审批通过后的回调开始-------------------");
    	//获取责任书信息
    	ProjectDutyLetterEntity dutyEntity = projectDutyLetterService.selectById(billId);
    	//风险保证金收取方式为：按已收工程款比例时生成风险保证经
    	if("bybeceived".equals(dutyEntity.getRiskMarginCollectionMethod())){
    		//新增的风险保证金
        	List<RiskMarginEntity> riskMarginList = new ArrayList<>();
        	//获取工程合同收款记录
        	CommonResponse<List<ReceiveVO>> receiveReturn = receiveManageApi.queryList(dutyEntity.getProjectId());
    		if(receiveReturn.isSuccess()){
    			List<ReceiveVO> receiveList = receiveReturn.getData();
    			BigDecimal allMoney = new BigDecimal(0);
    			for(int i=receiveList.size()-1; i>=0; i--){
    				ReceiveVO receiveVO = receiveList.get(i);
    				allMoney = allMoney.add(receiveVO.getReceiveMny());
    				RiskMarginEntity entity = new RiskMarginEntity();
    	            CommonResponse<String> billCodeResp = billCodeApi.getCodeBatchByRuleCode(RISK_BILL_CODE_RULE, InvocationInfoProxy.getTenantid());
    	            if(!billCodeResp.isSuccess()) {
    	                return CommonResponse.error("保存失败，自动生成编码失败。");
    	            }
    	            entity.setBillCode(billCodeResp.getData());
    				entity.setBillType("1");//扣保证金
    				entity.setSourceType("1");//自动生成
    				entity.setBillState(1);//已提交
    				entity.setProjectId(dutyEntity.getProjectId());
    				entity.setProjectName(dutyEntity.getProjectName());
    				entity.setApplySubject((DateFormatUtil.formatDate("yyyy-MM",receiveVO.getConfirmTime())+"扣保证金"));//主题
    				entity.setApplyDate(receiveVO.getConfirmTime());//申请日期
    				entity.setOperatorId(receiveVO.getEmployeeId());
    				entity.setOperatorName(receiveVO.getEmployeeName());
    				entity.setOrgId(dutyEntity.getProjectDepartmentId());
    				entity.setOrgName(dutyEntity.getProjectDepartmentName());
    				entity.setSourceId(receiveVO.getId());
    				/*a<b, 返回-1
    				a=b，返回0
    				a>b, 返回1*/
    				if(allMoney.compareTo(dutyEntity.getRiskGuaranteeAmount())==-1){
    					//累计金额小于风险保证金额，新增风险保证金
    					entity.setApplyAmt(receiveVO.getReceiveMny());
    					riskMarginList.add(entity);
    				}else if(allMoney.compareTo(dutyEntity.getRiskGuaranteeAmount())==0){
    					//相等，新增风险保证金
    					entity.setApplyAmt(receiveVO.getReceiveMny());
    					riskMarginList.add(entity);
    					break;
    				}else if(allMoney.compareTo(dutyEntity.getRiskGuaranteeAmount())==1){
    					//大于，累计金额-风险保证金 ，新增风险保证金
    					BigDecimal money = receiveVO.getReceiveMny().subtract(allMoney.subtract(dutyEntity.getRiskGuaranteeAmount()));
    					entity.setApplyAmt(money);
    					riskMarginList.add(entity);
    					break;
    				}
    			}
    		}
    		//生成风险保证金
    		if(riskMarginList!=null&&riskMarginList.size()>0){
    			riskMarginService.saveOrUpdateBatch(riskMarginList, riskMarginList.size(), false);
    		}
    	}
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
    	CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()) {
            logger.info("项目责任书单据【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}",billId,billTypeCode, resp.getMsg());
            return CommonResponse.error(resp.getMsg());
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
    	//获取责任书信息
    	ProjectDutyLetterEntity dutyEntity = projectDutyLetterService.selectById(billId);
    	QueryWrapper<RiskMarginEntity> queryWrapper = new QueryWrapper<>();
    	queryWrapper.eq("project_id", dutyEntity.getProjectId());
    	queryWrapper.eq("bill_type", "1");//扣保证金
    	queryWrapper.eq("project_id", "1");//自动生成
    	queryWrapper.eq("dr", 0);
		List<RiskMarginEntity> removeList = riskMarginService.list(queryWrapper);
		logger.info("删除风险保证金数据----"+removeList.toString());
		List<Long> ids = new ArrayList<>();
		if(removeList!=null&&removeList.size()>0){
			for(RiskMarginEntity entity : removeList){
				ids.add(entity.getId());
			}
			logger.info("删除风险保证金数据----"+ids.toString());
			riskMarginService.removeByIds(ids);
			logger.info("删除风险保证金数据成功！！！！----");
		}
        return CommonResponse.success();
    }

}
