/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prjfinance.bean.ProjectLoanEntity;
import com.ejianc.business.prjfinance.bean.ReturnMoneyEntity;
import com.ejianc.business.prjfinance.service.IProjectLoanService;
import com.ejianc.business.prjfinance.service.IReturnMoneyService;
import com.ejianc.business.prjfinance.vo.ProjectLoanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectLoan"})
public class ProjectLoanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "prjfrance-loan-001";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectLoanService service;
    @Autowired
    private IReturnMoneyService iReturnMoneyService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectLoanVO> saveOrUpdate(@RequestBody ProjectLoanVO saveorUpdateVO) {
        ProjectLoanEntity entity = (ProjectLoanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProjectLoanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectLoanVO vo = (ProjectLoanVO)BeanMapper.map((Object)((Object)entity), ProjectLoanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectLoanVO> queryDetail(Long id) {
        ProjectLoanEntity entity = (ProjectLoanEntity)((Object)this.service.selectById(id));
        ProjectLoanVO vo = (ProjectLoanVO)BeanMapper.map((Object)((Object)entity), ProjectLoanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectLoanVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectLoanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("agentName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectLoanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryTotalMoneyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryTotalMoneyData(@RequestParam(value="projectId") Long projectId) {
        List rme;
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List loanEntityList = this.service.queryList(param);
        JSONObject res = new JSONObject();
        BigDecimal totalLoan = BigDecimal.ZERO;
        BigDecimal totalReturn = BigDecimal.ZERO;
        BigDecimal remainLoan = BigDecimal.ZERO;
        if (ListUtil.isNotEmpty((List)loanEntityList)) {
            for (ProjectLoanEntity loanEntity : loanEntityList) {
                totalLoan = totalLoan.add(loanEntity.getLoanMoney());
            }
        }
        if (ListUtil.isNotEmpty((List)(rme = this.iReturnMoneyService.queryList(param)))) {
            for (ReturnMoneyEntity e : rme) {
                totalReturn = totalReturn.add(e.getCurrentTotalReturn());
            }
        }
        remainLoan = totalLoan.subtract(totalReturn);
        res.put("totalLoanMoney", (Object)totalLoan);
        res.put("totalReturnMoney", (Object)totalReturn);
        res.put("totalLoanBalance", (Object)remainLoan);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryLoanDataByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryLoanDataByProjectId(@RequestParam(value="projectId") Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List loanEntityList = this.service.queryList(param);
        List loanVOS = new ArrayList();
        JSONObject res = new JSONObject();
        BigDecimal remainLoan = BigDecimal.ZERO;
        if (ListUtil.isNotEmpty((List)loanEntityList)) {
            loanVOS = BeanMapper.mapList((Iterable)loanEntityList, ProjectLoanVO.class);
            Iterator iterator = loanVOS.iterator();
            while (iterator.hasNext()) {
                ProjectLoanVO vo;
                vo.setLoanMoneyLeft((vo = (ProjectLoanVO)iterator.next()).getReturnMoney() == null ? vo.getLoanMoney() : vo.getLoanMoney().subtract(vo.getReturnMoney()));
                remainLoan = remainLoan.add(vo.getLoanMoneyLeft() == null ? BigDecimal.ZERO : vo.getLoanMoneyLeft());
            }
        }
        res.put("loanBills", loanVOS);
        res.put("totalLoanBalance", (Object)remainLoan);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryLoanDataByProjectIdForDutyLetter"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryLoanDataByProjectIdForDutyLetter(@RequestParam(value="projectId") Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List loanEntityList = this.service.queryList(param);
        List loanVOS = new ArrayList();
        JSONObject res = new JSONObject();
        BigDecimal totalLoan = BigDecimal.ZERO;
        BigDecimal remainLoan = BigDecimal.ZERO;
        BigDecimal totalReturn = BigDecimal.ZERO;
        BigDecimal totalInterest = BigDecimal.ZERO;
        if (ListUtil.isNotEmpty((List)loanEntityList)) {
            loanVOS = BeanMapper.mapList((Iterable)loanEntityList, ProjectLoanVO.class);
            Iterator iterator = loanVOS.iterator();
            while (iterator.hasNext()) {
                ProjectLoanVO vo;
                vo.setLoanMoneyLeft((vo = (ProjectLoanVO)iterator.next()).getReturnMoney() == null ? vo.getLoanMoney() : vo.getLoanMoney().subtract(vo.getReturnMoney()));
                totalLoan = totalLoan.add(vo.getLoanMoney());
                remainLoan = remainLoan.add(vo.getLoanMoneyLeft() == null ? BigDecimal.ZERO : vo.getLoanMoneyLeft());
                totalReturn = totalReturn.add(vo.getReturnMoney() == null ? BigDecimal.ZERO : vo.getReturnMoney());
                totalInterest = totalInterest.add(vo.getInterest() == null ? BigDecimal.ZERO : vo.getInterest());
            }
        }
        res.put("loanBills", loanVOS);
        res.put("totalLoan", (Object)totalLoan);
        res.put("remainLoan", (Object)remainLoan);
        res.put("totalReturn", (Object)totalReturn);
        res.put("totalInterest", (Object)totalInterest);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("agentName");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("name");
        queryParam.setPageSize(-1);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(queryParam, false);
        List voList = new ArrayList();
        if (page.getTotal() > 0L) {
            voList = BeanMapper.mapList((Iterable)page.getRecords(), ProjectLoanVO.class);
            voList.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("project-loan-export.xlsx", beans, response);
    }
}

