/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.service.impl;

import com.ejianc.business.prjfinance.bean.RiskMarginEntity;
import com.ejianc.business.prjfinance.service.IRiskMarginService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="riskMargin")
public class RiskMarginBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRiskMarginService riskMarginService;

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.beforeBpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.beforeBpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> beforeBpmBackCheck(Long billId, Integer state, String billTypeCode) {
        RiskMarginEntity entity = (RiskMarginEntity)((Object)this.riskMarginService.selectById(billId));
        if ("1".equals(entity.getSourceType())) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u7684\u4fdd\u8bc1\u91d1\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\u3002");
        }
        if ("1".equals(entity.getBillType())) {
            Map<String, BigDecimal> info = this.riskMarginService.getProjectCashDepositInfo(entity.getProjectId());
            if (entity.getApplyAmt().compareTo(info.get("remremainingRefundableAmt")) > 0) {
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u5269\u4f59\u53ef\u9000\u8fd8\u91d1\u989d\u3002");
            }
        }
        return CommonResponse.success((String)"\u98ce\u9669\u4fdd\u8bc1\u91d1\u5f03\u5ba1\u524d\u6821\u9a8c\u6210\u529f\uff01");
    }
}

