/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prjfinance.bean.PrjQualitySafetyPenaltyEntity;
import com.ejianc.business.prjfinance.service.IPrjQualitySafetyPenaltyService;
import com.ejianc.business.prjfinance.vo.PrjQualitySafetyPenaltyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"prjQualitySafetyPenalty"})
public class PrjQualitySafetyPenaltyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPrjQualitySafetyPenaltyService service;
    @Autowired
    private IOrgApi orgApi;
    private static final String BILL_CODE = "quality-safety-penalty-001";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PrjQualitySafetyPenaltyVO> saveOrUpdate(@RequestBody PrjQualitySafetyPenaltyVO saveorUpdateVO) {
        PrjQualitySafetyPenaltyEntity entity = (PrjQualitySafetyPenaltyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, PrjQualitySafetyPenaltyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PrjQualitySafetyPenaltyVO vo = (PrjQualitySafetyPenaltyVO)BeanMapper.map((Object)((Object)entity), PrjQualitySafetyPenaltyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PrjQualitySafetyPenaltyVO> queryDetail(Long id) {
        PrjQualitySafetyPenaltyEntity entity = (PrjQualitySafetyPenaltyEntity)((Object)this.service.selectById(id));
        PrjQualitySafetyPenaltyVO vo = (PrjQualitySafetyPenaltyVO)BeanMapper.map((Object)((Object)entity), PrjQualitySafetyPenaltyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PrjQualitySafetyPenaltyVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("name");
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        param.getParams().put("orgId", new Parameter("in", childIds));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PrjQualitySafetyPenaltyVO.class));
        Map<String, BigDecimal> totalPenaltyMny = this.service.queryTotalPenaltyMnyAll(param);
        resp.put("total", (Object)pageData.getTotal());
        resp.put("current", (Object)pageData.getCurrent());
        resp.put("size", (Object)pageData.getSize());
        resp.put("pages", (Object)pageData.getPages());
        resp.put("records", (Object)pageData.getRecords());
        resp.put("totalPenaltyMny", (Object)totalPenaltyMny.get("totalPenaltyMny"));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @RequestMapping(value={"/queryTotalPenaltyMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> queryCurrentInterest(Long projectId) {
        Map<String, BigDecimal> map = this.service.queryTotalPenaltyMny(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u7d2f\u8ba1\u7f5a\u6b3e\u91d1\u989d\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/queryProjectDutyLetterList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<PrjQualitySafetyPenaltyEntity>> queryProjectDutyLetterList(Long projectId) {
        List<PrjQualitySafetyPenaltyEntity> list = this.service.queryProjectList(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u7d2f\u8ba1\u7f5a\u6b3e\u91d1\u989d\u6210\u529f\uff01", list);
    }
}

