/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.bean.RiskMarginEntity;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.service.IRiskMarginService;
import com.ejianc.business.prjfinance.vo.RiskMarginTransVO;
import com.ejianc.business.prjfinance.vo.RiskMarginVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/riskMargin/"})
public class PrjRiskMarginApi {
    @Autowired
    private IRiskMarginService riskMarginService;
    private final String BILL_CODE_RULE = "RISK_MARGIN_01";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectDutyLetterService projectDutyLetterService;

    /*
     * Enabled aggressive block sorting
     */
    @PostMapping(value={"generateByRecRecord"})
    public CommonResponse<Object> generateByRecRecord(@RequestBody RiskMarginTransVO saveVO) {
        JSONObject resp = new JSONObject();
        RiskMarginEntity saveEntity = (RiskMarginEntity)((Object)BeanMapper.map((Object)saveVO, RiskMarginEntity.class));
        ProjectDutyLetterEntity dutyEntity = this.projectDutyLetterService.selectByPrjojectId(saveEntity.getProjectId());
        BigDecimal dutyRiskBanlance = null;
        if (null == dutyEntity) {
            resp.put("code", (Object)"ungenerated");
            resp.put("msg", (Object)"\u5bf9\u5e94\u9879\u76ee\u4e0d\u5b58\u5728\u76ee\u6807\u8d23\u4efb\u4e66\uff0c\u65e0\u6cd5\u751f\u6210\u5bf9\u5e94\u7684\u9879\u76ee\u6263\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u3002");
            return CommonResponse.success((String)"\u670d\u52a1\u8c03\u7528\u6210\u529f", (Object)resp);
        }
        if (!"bybeceived".equals(dutyEntity.getRiskMarginCollectionMethod())) {
            resp.put("code", (Object)"ungenerated");
            resp.put("msg", (Object)"\u5bf9\u5e94\u9879\u76ee\u76ee\u6807\u8d23\u4efb\u4e66\u98ce\u9669\u4fdd\u8bc1\u91d1\u6536\u53d6\u65b9\u5f0f\u4e0d\u662f: \u6309\u5df2\u6536\u5de5\u7a0b\u6b3e\u6bd4\u4f8b, \u65e0\u6cd5\u751f\u6210\u5bf9\u5e94\u7684\u9879\u76ee\u6263\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u3002");
            return CommonResponse.success((String)"\u670d\u52a1\u8c03\u7528\u6210\u529f", (Object)resp);
        }
        Map<String, BigDecimal> info = this.riskMarginService.getProjectCashDepositInfo(saveEntity.getProjectId());
        dutyRiskBanlance = dutyEntity.getRiskGuaranteeAmount().subtract(info.get("totalDeductCashDeposit"));
        if (dutyRiskBanlance.compareTo(BigDecimal.ZERO) <= 0) {
            resp.put("code", (Object)"ungenerated");
            resp.put("msg", (Object)"\u5bf9\u5e94\u9879\u76ee\u5df2\u7d2f\u8ba1\u6263\u4fdd\u8bc1\u91d1\u91d1\u989d\u5df2\u8fbe\u5230\u76ee\u6807\u8d23\u4efb\u4e66\u8bbe\u7f6e\u98ce\u9669\u4fdd\u8bc1\u91d1\u989d\u4e0a\u9650, \u65e0\u6cd5\u751f\u6210\u5bf9\u5e94\u7684\u9879\u76ee\u6263\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u3002");
            return CommonResponse.success((String)"\u670d\u52a1\u8c03\u7528\u6210\u529f", (Object)resp);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708");
        CommonResponse billCodeResp = this.billCodeApi.getCodeBatchByRuleCode("RISK_MARGIN_01", InvocationInfoProxy.getTenantid());
        if (!billCodeResp.isSuccess()) {
            resp.put("code", (Object)"ungenerated");
            resp.put("msg", (Object)"\u751f\u6210\u6263\u4fdd\u8bc1\u91d1\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5355\u636e\u7f16\u7801\u5931\u8d25\u3002");
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u7f16\u7801\u5931\u8d25\u3002", (Object)resp);
        }
        saveEntity.setBillCode((String)billCodeResp.getData());
        saveEntity.setBillType("1");
        saveEntity.setSourceType("1");
        saveEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        saveEntity.setApplyAmt(saveEntity.getApplyAmt().multiply(dutyEntity.getSingleDeductionRatio().divide(new BigDecimal("100"), 8, 4)));
        saveEntity.setApplyAmt(dutyRiskBanlance.compareTo(saveEntity.getApplyAmt()) >= 0 ? saveEntity.getApplyAmt() : dutyRiskBanlance);
        saveEntity.setApplySubject(sdf.format(saveEntity.getApplyDate()) + "\u6263\u4fdd\u8bc1\u91d1");
        this.riskMarginService.saveOrUpdate((Object)saveEntity, false);
        resp.put("code", (Object)"generatedSuc");
        resp.put("msg", (Object)"\u751f\u6210\u5bf9\u5e94\u6263\u4fdd\u8bc1\u91d1\u5355\u636e\u6210\u529f\uff01");
        resp.put("data", BeanMapper.map((Object)((Object)saveEntity), RiskMarginVO.class));
        return CommonResponse.success((String)"\u670d\u52a1\u8c03\u7528\u6210\u529f", (Object)resp);
    }

    @GetMapping(value={"getPrjFinanceData"})
    public CommonResponse<Map> getPrjFinanceData(@RequestParam Long projectId) {
        Map<String, BigDecimal> riskInfo = this.riskMarginService.getPrjFinanceData(projectId);
        return CommonResponse.success(riskInfo);
    }

    @PostMapping(value={"delBySourceIds"})
    public CommonResponse<JSONObject> delBySourceIds(@RequestBody List<Long> sourceIds) {
        JSONObject resp = new JSONObject();
        this.riskMarginService.delBySourceIds(sourceIds);
        return CommonResponse.success((String)"\u5220\u9664\u5bf9\u5e94\u6263\u4fdd\u8bc1\u91d1\u5355\u636e\u6210\u529f\uff01", (Object)resp);
    }
}

