/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.api.IProjectBoardApi;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterChangeEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterClauseEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterCostlistEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterChangeService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterChangeClauseVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterChangeCostlistVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterChangeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projectDutyLetterChange/"})
public class ProjectDutyLetterChangeController {
    private static Logger logger = LoggerFactory.getLogger(ProjectDutyLetterChangeController.class);
    @Autowired
    IProjectDutyLetterChangeService projectDutyLetterChangeService;
    @Autowired
    IProjectDutyLetterService projectDutyLetterService;
    @Autowired
    private IProjectBoardApi iProjectBoardApi;

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<ProjectDutyLetterChangeVO> save(@RequestBody ProjectDutyLetterChangeVO projectDutyLetterChangeVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bill_id", new Parameter("eq", (Object)projectDutyLetterChangeVO.getBillId()));
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.COMMITED_STATE.getBillStateCode()));
        queryParam.getComplexParams().add(c1);
        queryParam.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryParam.getParams().put("id", new Parameter("ne", (Object)projectDutyLetterChangeVO.getId()));
        List list = this.projectDutyLetterChangeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u9879\u76ee\u8d23\u4efb\u4e66\u5b58\u5728\u672a\u5ba1\u6279\u901a\u8fc7\u7684\u53d8\u66f4\u8bb0\u5f55\uff01");
        }
        this.codeCheck(projectDutyLetterChangeVO.getBillId(), projectDutyLetterChangeVO.getBillCode());
        ProjectDutyLetterChangeVO resp = this.projectDutyLetterChangeService.save(projectDutyLetterChangeVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    public void codeCheck(Long id, String billCode) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billCode", new Parameter("eq", (Object)billCode));
        queryParam.getParams().put("id", new Parameter("ne", (Object)id));
        List list = this.projectDutyLetterService.queryList(queryParam, false);
        if (list != null && list.size() > 0) {
            throw new BusinessException("\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539");
        }
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<ProjectDutyLetterChangeVO> detail(@RequestParam(value="id", required=false) Long id, @RequestParam(value="dutyLetterId", required=false) Long dutyLetterId) {
        BaseEntity e;
        ProjectDutyLetterChangeVO vo = null;
        if (id != null && id != 111L) {
            e = (ProjectDutyLetterChangeEntity)((Object)this.projectDutyLetterChangeService.selectById(id));
            vo = (ProjectDutyLetterChangeVO)BeanMapper.map((Object)e, ProjectDutyLetterChangeVO.class);
        } else if (dutyLetterId != null) {
            ProjectDutyLetterChangeClauseVO v;
            ArrayList<ProjectDutyLetterChangeClauseVO> items;
            e = (ProjectDutyLetterEntity)((Object)this.projectDutyLetterService.selectById(dutyLetterId));
            vo = (ProjectDutyLetterChangeVO)BeanMapper.map((Object)e, ProjectDutyLetterChangeVO.class);
            vo.setBillId(e.getId());
            vo.setId(null);
            vo.setCreateTime(null);
            vo.setCreateUserCode(null);
            vo.setCreateUserName(null);
            vo.setUpdateTime(null);
            vo.setUpdateUserCode(null);
            vo.setTenantId(null);
            vo.setBillState(Integer.valueOf(0));
            if (e.getProjectDutyLetterClauseList() != null && e.getProjectDutyLetterClauseList().size() > 0) {
                items = new ArrayList<ProjectDutyLetterChangeClauseVO>();
                for (ProjectDutyLetterClauseEntity projectDutyLetterClauseEntity : e.getProjectDutyLetterClauseList()) {
                    v = (ProjectDutyLetterChangeClauseVO)BeanMapper.map((Object)((Object)projectDutyLetterClauseEntity), ProjectDutyLetterChangeClauseVO.class);
                    v.setRowState("add");
                    items.add(v);
                }
                vo.setProjectDutyLetterChangeClauseList(items);
            }
            if (e.getProjectDutyLetterCostList() != null && e.getProjectDutyLetterCostList().size() > 0) {
                items = new ArrayList();
                for (ProjectDutyLetterCostlistEntity projectDutyLetterCostlistEntity : e.getProjectDutyLetterCostList()) {
                    v = (ProjectDutyLetterChangeCostlistVO)BeanMapper.map((Object)((Object)projectDutyLetterCostlistEntity), ProjectDutyLetterChangeCostlistVO.class);
                    v.setRowState("add");
                    items.add(v);
                }
                vo.setProjectDutyLetterChangeCostList(items);
            }
        }
        CommonResponse inAndOut = this.iProjectBoardApi.queryIncoemAndExpendByProjectId(vo.getProjectId());
        if (inAndOut.isSuccess()) {
            JSONObject dataresultIncoemAndExpend = (JSONObject)inAndOut.getData();
            if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
            }
            if (vo.getProjectDutyLetterChangeCostList() != null && vo.getProjectDutyLetterChangeCostList().size() > 0) {
                List list = vo.getProjectDutyLetterChangeCostList();
                for (ProjectDutyLetterChangeCostlistVO cost : list) {
                    if (null != cost.getTaxCostId()) continue;
                    if (cost.getFormula() != null) {
                        String evalq = cost.getFormula();
                        for (String key : dataresultIncoemAndExpend.keySet()) {
                            String value = "0";
                            value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                            evalq = evalq.replaceAll(key, value);
                        }
                        ScriptEngineManager manager = new ScriptEngineManager();
                        ScriptEngine se = manager.getEngineByName("js");
                        BigDecimal money = new BigDecimal(0);
                        try {
                            money = new BigDecimal(Double.valueOf(se.eval(evalq).toString()));
                        }
                        catch (ScriptException e2) {
                            e2.printStackTrace();
                        }
                        cost.setAmount(money);
                        continue;
                    }
                    cost.setAmount(new BigDecimal(0));
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<ProjectDutyLetterChangeVO> vos) {
        this.projectDutyLetterChangeService.deleteById(vos.get(0).getId(), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

