/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IProjectBoardApi;
import com.ejianc.business.finance.api.IReceiveManageApi;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterCostlistEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterCostlistService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterCostlistVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterExportVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/projectDutyLetter/"})
public class ProjectDutyLetterController {
    private static Logger logger = LoggerFactory.getLogger(ProjectDutyLetterController.class);
    private static final String projectDutyLetter_BILL_CODE = "projectDutyLetter";
    @Autowired
    IProjectDutyLetterService projectDutyLetterService;
    @Autowired
    IProjectDutyLetterCostlistService projectDutyLetterCostlistService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectBoardApi iProjectBoardApi;
    @Autowired
    private IReceiveManageApi receiveManageApi;

    @RequestMapping(value={"saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectDutyLetterVO> saveOrUpdate(@RequestBody ProjectDutyLetterVO vo) {
        this.checkProject(vo);
        ProjectDutyLetterEntity entity = (ProjectDutyLetterEntity)((Object)BeanMapper.map((Object)vo, ProjectDutyLetterEntity.class));
        if (entity.getId() == null) {
            if (StringUtils.isBlank((CharSequence)vo.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(projectDutyLetter_BILL_CODE, InvocationInfoProxy.getTenantid());
                if (billCode.isSuccess()) {
                    entity.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity.setChangeState("0");
        }
        this.projectDutyLetterService.saveOrUpdate((Object)entity, false);
        ProjectDutyLetterVO backVo = (ProjectDutyLetterVO)BeanMapper.map((Object)((Object)entity), ProjectDutyLetterVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVo);
    }

    public void checkProject(ProjectDutyLetterVO vo) {
        List list;
        QueryParam queryParam = new QueryParam();
        if (StringUtils.isNotBlank((CharSequence)vo.getBillCode())) {
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("and");
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("or");
            c2.getParams().put("projectId", new Parameter("eq", (Object)vo.getProjectId()));
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("billCode", new Parameter("eq", (Object)vo.getBillCode()));
            c1.getComplexParams().add(c2);
            c1.getComplexParams().add(c3);
            queryParam.getComplexParams().add(c1);
        } else {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)vo.getProjectId()));
        }
        if (vo.getId() != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        if ((list = this.projectDutyLetterService.queryList(queryParam, false)) != null && list.size() > 0) {
            if (StringUtils.isNotBlank((CharSequence)vo.getBillCode())) {
                if (((ProjectDutyLetterEntity)((Object)list.get(0))).getBillCode().equals(vo.getBillCode())) {
                    throw new BusinessException("\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
                }
                if (((ProjectDutyLetterEntity)((Object)list.get(0))).getProjectId().equals(vo.getProjectId())) {
                    throw new BusinessException("\u9879\u76ee\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u9879\u76ee");
                }
            } else {
                throw new BusinessException("\u9879\u76ee\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u9879\u76ee");
            }
        }
    }

    @RequestMapping(value={"queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectDutyLetterVO> queryDetail(Long id, HttpServletRequest request) {
        ProjectDutyLetterEntity entity = (ProjectDutyLetterEntity)((Object)this.projectDutyLetterService.selectById(id));
        ProjectDutyLetterVO vo = (ProjectDutyLetterVO)BeanMapper.map((Object)((Object)entity), ProjectDutyLetterVO.class);
        CommonResponse inAndOut = this.iProjectBoardApi.queryIncoemAndExpendByProjectId(vo.getProjectId());
        if (inAndOut.isSuccess()) {
            JSONObject dataresultIncoemAndExpend = (JSONObject)inAndOut.getData();
            if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
            }
            if (vo.getProjectDutyLetterCostList() != null && vo.getProjectDutyLetterCostList().size() > 0) {
                List list = vo.getProjectDutyLetterCostList();
                for (ProjectDutyLetterCostlistVO cost : list) {
                    if (null != cost.getTaxCostId()) continue;
                    if (cost.getFormula() != null) {
                        String evalq = cost.getFormula();
                        for (String key : dataresultIncoemAndExpend.keySet()) {
                            String value = "0";
                            value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                            evalq = evalq.replaceAll(key, value);
                        }
                        ScriptEngineManager manager = new ScriptEngineManager();
                        ScriptEngine se = manager.getEngineByName("js");
                        BigDecimal money = new BigDecimal(0);
                        try {
                            money = new BigDecimal(Double.valueOf(se.eval(evalq).toString()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        cost.setAmount(money);
                        continue;
                    }
                    cost.setAmount(new BigDecimal(0));
                }
                this.projectDutyLetterCostlistService.saveOrUpdateBatch(BeanMapper.mapList((Iterable)list, ProjectDutyLetterCostlistEntity.class), list.size(), false);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectDutyLetterVO>> queryList(@RequestBody QueryParam param, HttpServletRequest request) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("dutyLetterName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("economicPersonName");
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("projectDepartmentId", new Parameter("in", orgIds));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.projectDutyLetterService.queryPage(param, false);
        Page voPage = null;
        if (page != null) {
            voPage = new Page();
            voPage.setCurrent(page.getCurrent());
            voPage.setPages(page.getPages());
            voPage.setTotal(page.getTotal());
            voPage.setSize((long)param.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectDutyLetterVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", voPage);
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectDutyLetterVO> vos) {
        this.projectDutyLetterService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"queryCostDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryCostDetail(Long id, HttpServletRequest request) {
        ProjectDutyLetterEntity entity;
        CommonResponse inAndOut;
        QueryParam param = new QueryParam();
        param.getParams().put("dutyLetterId", new Parameter("eq", (Object)id));
        List list = this.projectDutyLetterCostlistService.queryList(param, false);
        BigDecimal allDelete = new BigDecimal(0);
        BigDecimal allAdd = new BigDecimal(0);
        BigDecimal amount = new BigDecimal(0);
        if (list != null && list.size() > 0 && (inAndOut = this.iProjectBoardApi.queryIncoemAndExpendByProjectId((entity = (ProjectDutyLetterEntity)((Object)this.projectDutyLetterService.selectById(id))).getProjectId())).isSuccess()) {
            JSONObject dataresultIncoemAndExpend = (JSONObject)inAndOut.getData();
            if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
            }
            for (ProjectDutyLetterCostlistEntity cost : list) {
                if (null == cost.getTaxCostId()) {
                    if (cost.getFormula() != null) {
                        String evalq = cost.getFormula();
                        for (String key : dataresultIncoemAndExpend.keySet()) {
                            String value = "0";
                            value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                            evalq = evalq.replaceAll(key, value);
                        }
                        ScriptEngineManager manager = new ScriptEngineManager();
                        ScriptEngine se = manager.getEngineByName("js");
                        BigDecimal money = new BigDecimal(0);
                        try {
                            money = new BigDecimal(Double.valueOf(se.eval(evalq).toString()));
                        }
                        catch (ScriptException e) {
                            e.printStackTrace();
                        }
                        cost.setAmount(money);
                    } else {
                        cost.setAmount(new BigDecimal(0));
                    }
                }
                if ("del".equals(cost.getBackOrDel())) {
                    allDelete = ComputeUtil.safeAdd((BigDecimal)allDelete, (BigDecimal)cost.getAmount());
                    continue;
                }
                allAdd = ComputeUtil.safeAdd((BigDecimal)allAdd, (BigDecimal)cost.getAmount());
            }
        }
        amount = allDelete.subtract(allAdd);
        JSONObject result = new JSONObject();
        result.put("id", (Object)id);
        result.put("projectDutyLetterCostList", (Object)list);
        result.put("allDelete", (Object)allDelete);
        result.put("allAdd", (Object)allAdd);
        result.put("amount", (Object)amount);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"queryManageDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryManageDetail(@RequestParam Long id) {
        BigDecimal management;
        BigDecimal projectContractCollection;
        List receiveList;
        JSONObject result = new JSONObject();
        ProjectDutyLetterEntity entity = (ProjectDutyLetterEntity)((Object)this.projectDutyLetterService.selectById(id));
        Long projectId = entity.getProjectId();
        CommonResponse receiveReturn = this.receiveManageApi.queryList(projectId);
        if (receiveReturn.isSuccess()) {
            receiveList = (List)receiveReturn.getData();
            projectContractCollection = new BigDecimal(0);
            management = new BigDecimal(0);
            if (receiveList != null && receiveList.size() > 0) {
                for (ReceiveVO vo : receiveList) {
                    vo.setContractMny(new BigDecimal(0));
                    if (vo.getReceiveMny() == null) continue;
                    projectContractCollection = projectContractCollection.add(vo.getReceiveMny());
                    if (entity.getManagementExpense() != null) {
                        vo.setContractMny(vo.getReceiveMny().multiply(entity.getManagementExpense().divide(new BigDecimal(100))));
                    }
                    management = management.add(vo.getContractMny());
                }
            }
        } else {
            return CommonResponse.error((String)receiveReturn.getMsg());
        }
        result.put("id", (Object)id);
        result.put("receiveList", (Object)receiveList);
        result.put("projectContractCollection", (Object)projectContractCollection);
        result.put("managementExpense", (Object)entity.getManagementExpense());
        result.put("management", (Object)management);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(100000);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("economicPersonName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        queryParam.getParams().put("projectDepartmentId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.projectDutyLetterService.queryList(queryParam, false);
        ArrayList exportVOS = new ArrayList();
        list.forEach(vo -> {
            ProjectDutyLetterExportVO exportVO = (ProjectDutyLetterExportVO)BeanMapper.map((Object)vo, ProjectDutyLetterExportVO.class);
            exportVO.setCreateTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getCreateTime()));
            if (vo.getSigningDate() != null) {
                exportVO.setSigningDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getSigningDate()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getChangeState())) {
                if ("0".equals(vo.getChangeState())) {
                    exportVO.setChangeState("\u672a\u53d8\u66f4");
                } else if ("1".equals(vo.getChangeState())) {
                    exportVO.setChangeState("\u53d8\u66f4\u4e2d");
                } else if ("2".equals(vo.getChangeState())) {
                    exportVO.setChangeState("\u5df2\u53d8\u66f4");
                } else {
                    exportVO.setChangeState("\u672a\u53d8\u66f4");
                }
            } else {
                exportVO.setChangeState("\u672a\u53d8\u66f4");
            }
            if (vo.getOperator() != null) {
                try {
                    JSONArray jArray = ReferObjectUtil.getReferEntityValue((String)vo.getOperator().toString(), (String)"idm-user");
                    if (jArray != null && jArray.size() > 0) {
                        JSONObject json = (JSONObject)jArray.get(0);
                        exportVO.setOperatorName(json.get((Object)"name").toString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getDutyLetterState())) {
                if ("1".equals(vo.getDutyLetterState())) {
                    exportVO.setDutyLetterState("\u672a\u7b7e\u8ba2");
                } else if ("2".equals(vo.getDutyLetterState())) {
                    exportVO.setDutyLetterState("\u5c65\u7ea6\u4e2d");
                } else if ("3".equals(vo.getDutyLetterState())) {
                    exportVO.setDutyLetterState("\u5df2\u5c01\u8d26");
                } else {
                    exportVO.setDutyLetterState("\u672a\u7b7e\u8ba2");
                }
            } else {
                exportVO.setDutyLetterState("\u672a\u7b7e\u8ba2");
            }
            if (exportVO.getManagementExpense() != null) {
                exportVO.setManagementExpenseName(exportVO.getManagementExpense() + "%");
            }
            exportVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            exportVOS.add(exportVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", exportVOS);
        String fileName = "projectDutyLetter-export.xlsx";
        ExcelExport.getInstance().export(fileName, beans, response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"updateCostList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateCostList(@RequestBody Map<String, Object> params) {
        CommonResponse incoemdataResult;
        ArrayList<Long> projectIds = null;
        if (params.get("projectIds") != null) {
            projectIds = (ArrayList<Long>)params.get("projectIds");
        }
        List<ProjectDutyLetterCostlistEntity> costList = null;
        Long tenantid = InvocationInfoProxy.getTenantid();
        if (CollectionUtils.isEmpty((Collection)projectIds)) {
            costList = this.projectDutyLetterCostlistService.getCostListByProjectIds(null, tenantid);
            if (costList == null || costList.size() <= 0) return CommonResponse.success((String)"\u65e0\u9879\u76ee\u66f4\u65b0");
            projectIds = new ArrayList<Long>();
            for (ProjectDutyLetterCostlistEntity enetity : costList) {
                if (projectIds.contains(enetity.getProjectId())) continue;
                projectIds.add(enetity.getProjectId());
            }
        } else {
            costList = this.projectDutyLetterCostlistService.getCostListByProjectIds((List<Long>)projectIds, tenantid);
        }
        if (!(incoemdataResult = this.iProjectBoardApi.queryIncoemAndExpendByProjectIds((List)projectIds)).isSuccess()) throw new BusinessException("\u8bf7\u6c42\u9879\u76ee\u8d44\u91d1\u6570\u636e\u5931\u8d25\uff0c" + incoemdataResult.getMsg());
        for (ProjectDutyLetterCostlistEntity cost : costList) {
            if (null != cost.getTaxCostId()) continue;
            JSONObject dataresultIncoemAndExpend = (JSONObject)((Map)incoemdataResult.getData()).get(cost.getProjectId());
            if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
            }
            if (cost.getFormula() != null) {
                String evalq = cost.getFormula();
                for (String key : dataresultIncoemAndExpend.keySet()) {
                    String value = "0";
                    value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                    evalq = evalq.replaceAll(key, value);
                }
                ScriptEngineManager manager = new ScriptEngineManager();
                ScriptEngine se = manager.getEngineByName("js");
                BigDecimal money = new BigDecimal(0);
                try {
                    money = new BigDecimal(Double.valueOf(se.eval(evalq).toString()));
                }
                catch (ScriptException e) {
                    e.printStackTrace();
                }
                cost.setAmount(money);
                continue;
            }
            cost.setAmount(new BigDecimal(0));
        }
        this.projectDutyLetterCostlistService.saveOrUpdateBatch(BeanMapper.mapList(costList, ProjectDutyLetterCostlistEntity.class), costList.size(), false);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }
}

