/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.api.IProjectBoardApi;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterCostlistEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterCostlistService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.vo.OperationCostVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/projectDutyLetter/"})
public class ProjectDutyLetterApi {
    @Autowired
    private IProjectDutyLetterService projectDutyLetterService;
    @Autowired
    private IProjectDutyLetterCostlistService projectDutyLetterCostlistService;
    @Autowired
    private IProjectBoardApi iProjectBoardApi;

    @PostMapping(value={"getOperationList"})
    public CommonResponse<List<OperationCostVO>> getOperationList(@RequestBody OperationCostVO operationCostVO) {
        List<OperationCostVO> operationCostVOList = this.projectDutyLetterService.getOperationList(operationCostVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u8054\u8425\u9879\u76ee\u8d39\u7528\u5217\u8868\uff01", operationCostVOList);
    }

    @GetMapping(value={"getProjectDutyLetterDetail"})
    public CommonResponse<ProjectDutyLetterVO> getProjectDutyLetterDetail(@RequestParam Long projectId) {
        ProjectDutyLetterEntity projectDutyLetterEntity = this.projectDutyLetterService.selectByPrjojectId(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8054\u8425\u9879\u76ee\u8d39\u7528\u5217\u8868\uff01", (Object)BeanMapper.map((Object)((Object)projectDutyLetterEntity), ProjectDutyLetterVO.class));
    }

    @GetMapping(value={"getCostMoneyByProjectId"})
    public CommonResponse<BigDecimal> getCostMoneyByProjectId(@RequestParam Long projectId) {
        ArrayList<Long> projectIds = new ArrayList<Long>();
        projectIds.add(projectId);
        Long tenantid = InvocationInfoProxy.getTenantid();
        List<ProjectDutyLetterCostlistEntity> costList = this.projectDutyLetterCostlistService.getCostListByProjectIds(projectIds, tenantid);
        BigDecimal allDelete = new BigDecimal(0);
        BigDecimal allAdd = new BigDecimal(0);
        BigDecimal amount = new BigDecimal(0);
        CommonResponse inAndOut = this.iProjectBoardApi.queryIncoemAndExpendByProjectId(projectId);
        if (inAndOut.isSuccess()) {
            JSONObject dataresultIncoemAndExpend = (JSONObject)inAndOut.getData();
            if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
            }
            if (costList != null && costList.size() > 0) {
                for (ProjectDutyLetterCostlistEntity cost : costList) {
                    if (null == cost.getTaxCostId()) {
                        if (cost.getFormula() != null) {
                            String evalq = cost.getFormula();
                            for (String key : dataresultIncoemAndExpend.keySet()) {
                                String value = "0";
                                value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                                evalq = evalq.replaceAll(key, value);
                            }
                            ScriptEngineManager manager = new ScriptEngineManager();
                            ScriptEngine se = manager.getEngineByName("js");
                            BigDecimal money = new BigDecimal(0);
                            try {
                                money = new BigDecimal(Double.valueOf(se.eval(evalq).toString()));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            cost.setAmount(money);
                        } else {
                            cost.setAmount(new BigDecimal(0));
                        }
                    }
                    if ("del".equals(cost.getBackOrDel())) {
                        allDelete = ComputeUtil.safeAdd((BigDecimal)allDelete, (BigDecimal)cost.getAmount());
                        continue;
                    }
                    allAdd = ComputeUtil.safeAdd((BigDecimal)allAdd, (BigDecimal)cost.getAmount());
                }
                this.projectDutyLetterCostlistService.saveOrUpdateBatch(costList, costList.size(), false);
            }
        }
        amount = allDelete.subtract(allAdd);
        return CommonResponse.success((Object)amount);
    }
}

