/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.service.impl;

import com.ejianc.business.bank.api.IBankAccFinApi;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.prjfinance.bean.PrjAdvancePaymentEntity;
import com.ejianc.business.prjfinance.service.IPrjAdvancePaymentService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="prjAdvancePayment")
public class PrjAdvancePayBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPrjAdvancePaymentService prjAdvancePaymentService;
    @Autowired
    private IBankAccFinApi bankAccFinApi;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PrjAdvancePaymentEntity entity = (PrjAdvancePaymentEntity)((Object)this.prjAdvancePaymentService.selectById(billId));
        BankFlowVO flowVO = null;
        if ("1".equals(entity.getBillType())) {
            flowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u9879\u76ee\u4ee3\u8f6c\u6b3e\u6536\u6b3e\u767b\u8bb0);
            flowVO.setReceiveMoney(entity.getAmount());
        } else {
            flowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u9879\u76ee\u4ee3\u8f6c\u6b3e\u9000\u6b3e);
            flowVO.setPayMoney(entity.getAmount());
            flowVO.setTradeAccountName(entity.getRecBankAccName());
            flowVO.setTradeAccountBank(entity.getRecOpenAccBankName());
            flowVO.setTradeAccountNum(entity.getRecBankAcc());
        }
        flowVO.setBillDate(entity.getHandlingDate());
        flowVO.setSourceId(entity.getId());
        flowVO.setBillId(entity.getId());
        flowVO.setBillCode(entity.getBillCode());
        flowVO.setOrgId(entity.getOrgId());
        flowVO.setOrgName(entity.getOrgName());
        flowVO.setAccountId(entity.getAccountId());
        flowVO.setAccountName(entity.getAccountName());
        flowVO.setAccountBank(entity.getAccountBank());
        flowVO.setAccountNum(entity.getAccountNum());
        flowVO.setMemo(entity.getRemark());
        flowVO.setEmployeeId(entity.getOperatorId());
        flowVO.setEmployeeName(entity.getOperatorName());
        this.bankAccFinApi.saveBankFlow(flowVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.beforeBpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> beforeBpmBackCheck(Long billId, Integer state, String billTypeCode) {
        PrjAdvancePaymentEntity entity = (PrjAdvancePaymentEntity)((Object)this.prjAdvancePaymentService.selectById(billId));
        if ("1".equals(entity.getBillType()) && null != entity.getProjectId()) {
            Map<String, BigDecimal> info = this.prjAdvancePaymentService.getTotalPrjAdvancePayInfo(entity.getProjectId());
            if (entity.getAmount().compareTo(info.get("remremainingRefundableAmt")) > 0) {
                this.logger.info("\u98ce\u9669\u4fdd\u8bc1\u91d1\u5355\u636e\u7edf\u8ba1\uff1a\u7d2f\u8ba1\u4ee3\u8f6c\u6b3e-{},\u5269\u4f59\u53ef\u9000\u91d1\u989d-{}, \u7533\u8bf7\u91d1\u989d-{}", new Object[]{info.get("totalAdvancePayAmt").toPlainString(), info.get("remremainingRefundableAmt").toPlainString(), entity.getAmount().toPlainString()});
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u5269\u4f59\u53ef\u9000\u8fd8\u91d1\u989d\u3002");
            }
        }
        this.bankAccFinApi.delBankFlow(billId, billId);
        return CommonResponse.success((String)"\u9879\u76ee\u4ee3\u8f6c\u6b3e\u5f03\u5ba1\u524d\u6821\u9a8c\u6210\u529f\uff01");
    }
}

