package com.ejianc.business.prjfinance.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterChangeClauseEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterChangeCostlistEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterChangeEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterClauseEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterCostlistEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterRecordClauseEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterRecordCostlistEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterRecordEntity;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterChangeService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterClauseService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterCostlistService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterRecordService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterChangeClauseVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterChangeCostlistVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterChangeVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterRecordClauseVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterRecordCostlistVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("projectDutyLetterChange")
public class ProjectDutyLetterChangeBpmService implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IProjectDutyLetterChangeService projectDutyLetterChangeService;

    @Autowired
    IProjectDutyLetterRecordService projectDutyLetterRecordService;

    @Autowired
    IProjectDutyLetterService projectDutyLetterService;

    @Autowired
    IProjectDutyLetterClauseService projectDutyLetterClauseService;

    @Autowired
    IProjectDutyLetterCostlistService projectDutyLetterCostlistService;

    @Autowired
    IAttachmentApi attachmentApi;
    
    @Autowired
    private IBillTypeApi billTypeApi;
    
	/**
	 * 审批节点审批中时节点审批后回调
	 * 
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
    @Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};
	
    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
    @Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
    	logger.info("审批通过后的回调开始-------------------");
    	//获取变更单信息
    	ProjectDutyLetterChangeEntity changeEntity = projectDutyLetterChangeService.selectById(billId);
    	//获取责任书信息
    	ProjectDutyLetterEntity dutyEntity = projectDutyLetterService.selectById(changeEntity.getBillId());
    	
    	//2、生成之前版本的记录
    	ProjectDutyLetterRecordEntity recordEntity = new ProjectDutyLetterRecordEntity();
    	recordEntity = BeanMapper.map(dutyEntity, ProjectDutyLetterRecordEntity.class);
    	String verson = dutyEntity.getChangeVersion()>9?dutyEntity.getChangeVersion().toString():("0"+dutyEntity.getChangeVersion());
    	recordEntity.setBillCode(dutyEntity.getBillCode()+"-"+verson);
    	recordEntity.setChangeReason(changeEntity.getChangeReason());
    	recordEntity.setChangeUserName(changeEntity.getCreateUserName());
    	recordEntity.setChangeTime(changeEntity.getCreateTime());
    	recordEntity.setCode(dutyEntity.getBillCode());
    	recordEntity.setBillId(dutyEntity.getId());
    	recordEntity.setId(null);
    	recordEntity.setCreateTime(null);
    	recordEntity.setCreateUserCode(null);
    	recordEntity.setUpdateTime(null);
    	recordEntity.setUpdateUserCode(null);
    	recordEntity.setTenantId(null);
        if(dutyEntity.getProjectDutyLetterClauseList()!=null&&dutyEntity.getProjectDutyLetterClauseList().size()>0){
        	List<ProjectDutyLetterRecordClauseEntity> items = new ArrayList<>();
        	for(ProjectDutyLetterClauseEntity item : dutyEntity.getProjectDutyLetterClauseList()){
        		ProjectDutyLetterRecordClauseEntity v = BeanMapper.map(item, ProjectDutyLetterRecordClauseEntity.class);
        		v.setRowState("add");
        		v.setId(null);
            	v.setCreateTime(null);
            	v.setCreateUserCode(null);
            	v.setUpdateTime(null);
            	v.setUpdateUserCode(null);
            	v.setTenantId(null);
        		items.add(v);
        	}
        	recordEntity.setProjectDutyLetterRecordClauseList(items);
        }
        if(dutyEntity.getProjectDutyLetterCostList()!=null&&dutyEntity.getProjectDutyLetterCostList().size()>0){
        	List<ProjectDutyLetterRecordCostlistEntity> items = new ArrayList<>();
        	for(ProjectDutyLetterCostlistEntity item : dutyEntity.getProjectDutyLetterCostList()){
        		ProjectDutyLetterRecordCostlistEntity v = BeanMapper.map(item, ProjectDutyLetterRecordCostlistEntity.class);
        		v.setRowState("add");
        		v.setId(null);
            	v.setCreateTime(null);
            	v.setCreateUserCode(null);
            	v.setUpdateTime(null);
            	v.setUpdateUserCode(null);
            	v.setTenantId(null);
        		items.add(v);
        	}
        	recordEntity.setProjectDutyLetterRecordCostList(items);
        }
        
        //保存历史记录
        projectDutyLetterRecordService.saveOrUpdate(recordEntity, false);
    	//查询项目责任书附件信息,并新增到记录中
        CommonResponse<List<AttachmentVO>> attchmentDutyReturn = attachmentApi.queryListBySourceId(changeEntity.getId(), "BT210720000000001", "projectDutyLetter", null);
        if(attchmentDutyReturn.isSuccess()&&attchmentDutyReturn.getData()!=null&&attchmentDutyReturn.getData().size()>0){
        	List<AttachmentVO> list = attchmentDutyReturn.getData();
        	List<AttachmentVO> addList = new ArrayList<>();
        	for(AttachmentVO vo : list){
        		AttachmentVO add = vo;
        		add.setSourceId(recordEntity.getId());
        		add.setBillType("BT210728000000001");
        		add.setId(null);
        		add.setCreateTime(null);
        		add.setCreateUserCode(null);
                add.setUpdateTime(null);
                add.setUpdateUserCode(null);
                add.setTenantId(null);
                addList.add(vo);
        	}
        	attachmentApi.insertBatch(addList);
        }
        
    	//将变更信息更新到责任书中
        dutyEntity.setDutyLetterName(changeEntity.getDutyLetterName());
        dutyEntity.setBillCode(changeEntity.getBillCode());
        dutyEntity.setDutyLetterState(changeEntity.getDutyLetterState());
        dutyEntity.setEconomicPersonId(changeEntity.getEconomicPersonId());
        dutyEntity.setEconomicPersonName(changeEntity.getEconomicPersonName());
        dutyEntity.setSigningDate(changeEntity.getSigningDate());
        dutyEntity.setDisputeBreachContractDealway(changeEntity.getDisputeBreachContractDealway());
        dutyEntity.setConstructionContractAmount(changeEntity.getConstructionContractAmount());
        dutyEntity.setPlannedCommencementDate(changeEntity.getPlannedCommencementDate());
        dutyEntity.setPlannedFinishDate(changeEntity.getPlannedFinishDate());
        dutyEntity.setContractDuration(changeEntity.getContractDuration());
        dutyEntity.setOperator(changeEntity.getOperator());
        dutyEntity.setConstructionContractQualityTarget(changeEntity.getConstructionContractQualityTarget());
        dutyEntity.setSafeCivilizedConstructionStandardTarget(changeEntity.getSafeCivilizedConstructionStandardTarget());
        dutyEntity.setQualitySafetyManagementRequirement(changeEntity.getQualitySafetyManagementRequirement());
        dutyEntity.setTechnologicalInnovationTarget(changeEntity.getTechnologicalInnovationTarget());
        dutyEntity.setRewardAndPunishment(changeEntity.getRewardAndPunishment());
        dutyEntity.setFinancialManagementDescription(changeEntity.getFinancialManagementDescription());
        dutyEntity.setRemarks(changeEntity.getRemarks());
        dutyEntity.setManagementExpense(changeEntity.getManagementExpense());
        dutyEntity.setManagementReceiveType(changeEntity.getManagementReceiveType());
        dutyEntity.setChangeCode(null);
        dutyEntity.setChangeId(null);
        dutyEntity.setChangeReason(null);
        dutyEntity.setChangeState(ProjectDutyLetterChangeVO.DUTYLETTER_CHANGE_STATE_CHANGED);
        if(changeEntity.getProjectDutyLetterChangeClauseList()!=null&&changeEntity.getProjectDutyLetterChangeClauseList().size()>0){
        	List<ProjectDutyLetterClauseEntity> items = new ArrayList<>();
        	for(ProjectDutyLetterChangeClauseEntity item : changeEntity.getProjectDutyLetterChangeClauseList()){
        		ProjectDutyLetterClauseEntity v = BeanMapper.map(item, ProjectDutyLetterClauseEntity.class);
        		v.setRowState("add");
        		v.setId(null);
            	v.setCreateTime(null);
            	v.setCreateUserCode(null);
            	v.setUpdateTime(null);
            	v.setUpdateUserCode(null);
            	v.setTenantId(null);
        		items.add(v);
        	}
        	dutyEntity.setProjectDutyLetterClauseList(items);
        }
        if(changeEntity.getProjectDutyLetterChangeCostList()!=null&&changeEntity.getProjectDutyLetterChangeCostList().size()>0){
        	List<ProjectDutyLetterCostlistEntity> items = new ArrayList<>();
        	for(ProjectDutyLetterChangeCostlistEntity item : changeEntity.getProjectDutyLetterChangeCostList()){
        		ProjectDutyLetterCostlistEntity v = BeanMapper.map(item, ProjectDutyLetterCostlistEntity.class);
        		v.setRowState("add");
        		v.setId(null);
            	v.setCreateTime(null);
            	v.setCreateUserCode(null);
            	v.setUpdateTime(null);
            	v.setUpdateUserCode(null);
            	v.setTenantId(null);
        		items.add(v);
        	}
        	dutyEntity.setProjectDutyLetterCostList(items);
        }
		//删除原先子表信息
        QueryWrapper<ProjectDutyLetterClauseEntity> removeClauseWrapper = new QueryWrapper<>();
        removeClauseWrapper.eq("duty_letter_id", dutyEntity.getId());
        projectDutyLetterClauseService.remove(removeClauseWrapper);
        QueryWrapper<ProjectDutyLetterCostlistEntity> removeCostWrapper = new QueryWrapper<>();
        removeCostWrapper.eq("duty_letter_id", dutyEntity.getId());
        projectDutyLetterCostlistService.remove(removeCostWrapper);
        //保存责任书信息
        projectDutyLetterService.saveOrUpdate(dutyEntity, false);

        //将变更单中的附件添加到责任书中
        CommonResponse<List<AttachmentVO>> attchmentChangeReturn = attachmentApi.queryListBySourceId(changeEntity.getId(), "BT210721000000001", "projectDutyLetter", null);
        if(attchmentChangeReturn.isSuccess()&&attchmentChangeReturn.getData()!=null&&attchmentChangeReturn.getData().size()>0){
        	List<AttachmentVO> list = attchmentChangeReturn.getData();
        	List<AttachmentVO> addList = new ArrayList<>();
        	for(AttachmentVO vo : list){
        		AttachmentVO add = vo;
        		add.setSourceId(dutyEntity.getId());
        		add.setBillType("BT210720000000001");
        		add.setId(null);
        		add.setCreateTime(null);
        		add.setCreateUserCode(null);
                add.setUpdateTime(null);
                add.setUpdateUserCode(null);
                add.setTenantId(null);
                addList.add(vo);
        	}
        	attachmentApi.insertBatch(addList);
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
    	String msg = "";
    	ProjectDutyLetterChangeEntity changeEntity = projectDutyLetterChangeService.selectById(billId);
    	if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(changeEntity.getBillState())){
    		//已提交
    		msg = "变更单据不能撤回";
    	}else{
    		msg = "变更单据不能弃审";
    	}
        return CommonResponse.error(msg);
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

}
