package com.ejianc.business.prjfinance.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 借款利息结算
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prjfinance_loan_interest")
public class PrjLoanInterestEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="current_interest")
    private java.math.BigDecimal currentInterest; // 本期利息
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="handle_date")
    private java.util.Date handleDate; // 办理日期
    @TableField(value="handle_user_id")
    private Long handleUserId; // 经办人id
    @TableField(value="handle_user_name")
    private String handleUserName; // 经办人姓名
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(exist = false)
    @SubEntity(serviceName = "prjLoanInterestSubService")
    private List<PrjLoanInterestSubEntity> loanInterestSubEntities = new ArrayList<>();
    @TableField(value="total_loan_balance")
    private BigDecimal totalLoanBalance;

    @TableField(value="org_id")
    private Long orgId;


    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 单据名称
     */
    public String getName() {
        return name;
    }

    /**
     * 单据名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 本期利息
     */
    public java.math.BigDecimal getCurrentInterest() {
        return currentInterest;
    }

    /**
     * 本期利息
     */
    public void setCurrentInterest(java.math.BigDecimal currentInterest) {
        this.currentInterest = currentInterest;
    }
    /**
     * 办理日期
     */
    public java.util.Date getHandleDate() {
        return handleDate;
    }

    /**
     * 办理日期
     */
    public void setHandleDate(java.util.Date handleDate) {
        this.handleDate = handleDate;
    }
    /**
     * 经办人id
     */
    public Long getHandleUserId() {
        return handleUserId;
    }

    /**
     * 经办人id
     */
    public void setHandleUserId(Long handleUserId) {
        this.handleUserId = handleUserId;
    }
    /**
     * 经办人姓名
     */
    public String getHandleUserName() {
        return handleUserName;
    }

    /**
     * 经办人姓名
     */
    public void setHandleUserName(String handleUserName) {
        this.handleUserName = handleUserName;
    }

    public List<PrjLoanInterestSubEntity> getLoanInterestSubEntities() {
        return loanInterestSubEntities;
    }

    public void setLoanInterestSubEntities(List<PrjLoanInterestSubEntity> loanInterestSubEntities) {
        this.loanInterestSubEntities = loanInterestSubEntities;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getTotalLoanBalance() {
        return totalLoanBalance;
    }

    public void setTotalLoanBalance(BigDecimal totalLoanBalance) {
        this.totalLoanBalance = totalLoanBalance;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}
