/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.service.impl;

import com.ejianc.business.bank.api.IBankAccFinApi;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.prjfinance.bean.ProjectLoanEntity;
import com.ejianc.business.prjfinance.bean.ReturnMoneyEntity;
import com.ejianc.business.prjfinance.bean.ReturnMoneySubEntity;
import com.ejianc.business.prjfinance.service.IProjectLoanService;
import com.ejianc.business.prjfinance.service.IReturnMoneyService;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="returnMoney")
public class ReturnMoneyBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IReturnMoneyService iReturnMoneyService;
    @Autowired
    private IBankAccFinApi bankAccFinApi;
    @Autowired
    private IProjectLoanService iProjectLoanService;
    @Autowired
    private IProjectLoanService projectLoanService;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnMoneyEntity main = (ReturnMoneyEntity)((Object)this.iReturnMoneyService.selectById(billId));
        if (main == null) {
            return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        List<ReturnMoneySubEntity> subEntities = main.getReturnMoneySubEntities();
        if (ListUtil.isNotEmpty(subEntities)) {
            ArrayList<BankFlowVO> bankFlowVOS = new ArrayList<BankFlowVO>();
            for (ReturnMoneySubEntity entity : subEntities) {
                this.iProjectLoanService.updateBillAllReturnMoney(entity.getLoanId(), entity.getReturnMny(), 1);
                if (entity.getLoanMoney().equals(entity.getReturnMny())) {
                    ProjectLoanEntity projectLoanEntity = (ProjectLoanEntity)((Object)this.projectLoanService.selectById(entity.getLoanId()));
                    projectLoanEntity.setLoanMoneyYornState(1);
                    this.projectLoanService.saveOrUpdate((Object)projectLoanEntity);
                }
                if (entity.getAccountInId() == null && entity.getAccountOutId() == null || !ComputeUtil.isGreaterThan((BigDecimal)entity.getReturnMny(), (BigDecimal)BigDecimal.ZERO)) continue;
                BankFlowVO flowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u501f\u6b3e\u9000\u8fd8\u6536\u5165);
                flowVO.setBillDate(main.getDealDate());
                flowVO.setSourceId(main.getId());
                flowVO.setBillId(main.getId());
                flowVO.setReceiveMoney(entity.getReturnMny());
                flowVO.setBillCode(main.getCode());
                flowVO.setOrgId(main.getOrgId());
                flowVO.setOrgName(main.getProjectName());
                flowVO.setAccountId(entity.getAccountInId());
                flowVO.setAccountName(entity.getAccountInName());
                flowVO.setAccountBank(entity.getAccountInBank());
                flowVO.setAccountNum(entity.getAccountInNum());
                flowVO.setTradeAccountId(entity.getAccountOutId());
                flowVO.setTradeAccountName(entity.getAccountOutName());
                flowVO.setTradeAccountBank(entity.getAccountOutBank());
                flowVO.setTradeAccountNum(entity.getAccountOutNum());
                flowVO.setMemo(entity.getMemo());
                flowVO.setEmployeeId(main.getDealPersonId());
                flowVO.setEmployeeName(main.getDealPerson());
                bankFlowVOS.add(flowVO);
                BankFlowVO flowOutVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u501f\u6b3e\u9000\u8fd8\u652f\u51fa);
                flowOutVO.setBillDate(main.getDealDate());
                flowOutVO.setSourceId(main.getId());
                flowOutVO.setBillId(main.getId());
                flowOutVO.setPayMoney(entity.getReturnMny());
                flowOutVO.setBillCode(main.getCode());
                flowOutVO.setOrgId(main.getOrgId());
                flowOutVO.setOrgName(main.getProjectName());
                flowOutVO.setAccountId(entity.getAccountOutId());
                flowOutVO.setAccountName(entity.getAccountOutName());
                flowOutVO.setAccountBank(entity.getAccountOutBank());
                flowOutVO.setAccountNum(entity.getAccountOutNum());
                flowOutVO.setTradeAccountId(entity.getAccountInId());
                flowOutVO.setTradeAccountName(entity.getAccountInName());
                flowOutVO.setTradeAccountBank(entity.getAccountInBank());
                flowOutVO.setTradeAccountNum(entity.getAccountInNum());
                flowOutVO.setMemo(entity.getMemo());
                flowOutVO.setEmployeeId(main.getDealPersonId());
                flowOutVO.setEmployeeName(main.getDealPerson());
                bankFlowVOS.add(flowOutVO);
            }
            if (CollectionUtils.isNotEmpty(bankFlowVOS)) {
                this.bankAccFinApi.batchSaveBankFlow(bankFlowVOS);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnMoneyEntity main = (ReturnMoneyEntity)((Object)this.iReturnMoneyService.selectById(billId));
        if (main == null) {
            return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("projectId", new Parameter("eq", (Object)main.getProjectId()));
        param.getOrderMap().put("dealDate", "desc");
        param.getOrderMap().put("createTime", "desc");
        List list = this.iReturnMoneyService.queryList(param);
        if (ListUtil.isNotEmpty((List)list) && !billId.equals(((ReturnMoneyEntity)((Object)list.get(0))).getId())) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u662f\u6700\u65b0\u5df2\u5ba1\u6838\u5355\u636e\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
        }
        param.getParams().put("billState", new Parameter("in", (Object)"0,2,4,5"));
        list = this.iReturnMoneyService.queryList(param);
        if (ListUtil.isNotEmpty((List)list)) {
            return CommonResponse.error((String)"\u5b58\u5728\u672a\u5ba1\u6838\u901a\u8fc7\u7684\u5355\u636e\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnMoneyEntity main = (ReturnMoneyEntity)((Object)this.iReturnMoneyService.selectById(billId));
        if (main == null) {
            return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        List<ReturnMoneySubEntity> subEntities = main.getReturnMoneySubEntities();
        if (ListUtil.isNotEmpty(subEntities)) {
            for (ReturnMoneySubEntity subEntity : subEntities) {
                this.iProjectLoanService.updateBillAllReturnMoney(subEntity.getLoanId(), subEntity.getReturnMny(), 2);
                ProjectLoanEntity projectLoanEntity = (ProjectLoanEntity)((Object)this.projectLoanService.selectById(subEntity.getLoanId()));
                projectLoanEntity.setLoanMoneyYornState(0);
                this.projectLoanService.saveOrUpdate((Object)projectLoanEntity);
            }
        }
        this.bankAccFinApi.delBankFlow(billId, billId);
        return CommonResponse.success();
    }
}

