/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prjfinance.bean.PrjLoanInterestEntity;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestService;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestSubService;
import com.ejianc.business.prjfinance.vo.PrjLoanInterestSubVO;
import com.ejianc.business.prjfinance.vo.PrjLoanInterestVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"prjLoanInterest"})
public class PrjLoanInterestController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPrjLoanInterestService service;
    @Autowired
    private IPrjLoanInterestSubService prjLoanInterestSubService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    private static final String BILL_CODE = "loan-Interest-001";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PrjLoanInterestVO> saveOrUpdate(@RequestBody PrjLoanInterestVO saveorUpdateVO) {
        PrjLoanInterestEntity entity = (PrjLoanInterestEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, PrjLoanInterestEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse code = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (code.isSuccess()) {
                entity.setCode((String)code.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)entity.getProjectId()));
        param.getParams().put("billState", new Parameter("in", (Object)"0,2,4,5"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)list)) {
            if (entity.getId() == null || entity.getId() == 0L) {
                throw new BusinessException("\u5b58\u5728\u672a\u5ba1\u6279\u5b8c\u6210\u7684\u501f\u6b3e\u5229\u606f\u3010" + ((PrjLoanInterestEntity)((Object)list.get(0))).getCode() + "\u3011\uff0c\u65e0\u6cd5\u65b0\u589e\u8fd8\u5229\u606f\uff01");
            }
            if (!entity.getId().equals(((PrjLoanInterestEntity)((Object)list.get(0))).getId())) {
                throw new BusinessException("\u5b58\u5728\u672a\u5ba1\u6279\u5b8c\u6210\u7684\u501f\u6b3e\u5229\u606f\u3010" + ((PrjLoanInterestEntity)((Object)list.get(0))).getCode() + "\u3011\uff0c\u65e0\u6cd5\u66f4\u65b0\u8fd8\u5229\u606f\uff01");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PrjLoanInterestVO vo = (PrjLoanInterestVO)BeanMapper.map((Object)((Object)entity), PrjLoanInterestVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PrjLoanInterestVO> queryDetail(Long id) {
        PrjLoanInterestEntity entity = (PrjLoanInterestEntity)((Object)this.service.selectById(id));
        PrjLoanInterestVO vo = (PrjLoanInterestVO)BeanMapper.map((Object)((Object)entity), PrjLoanInterestVO.class);
        this.listSubOrderCreateTimeBy(vo.getLoanInterestSubEntities());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PrjLoanInterestVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PrjLoanInterestVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("code");
        fuzzyFields.add("handleUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        param.getParams().put("orgId", new Parameter("in", childIds));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PrjLoanInterestVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryLatelyDate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, String>> queryLatelyDate(Long projectId) {
        Map<String, String> map = this.service.queryLatelyDate(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6700\u540e\u7ed3\u7b97\u65e5\u671f\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/queryLatelyDate4Settle"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<Long, String>> queryLatelyDate4Settle(Long projectId) {
        Map<Long, String> map = this.service.queryLatelyDate4Settle(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6700\u540e\u7ed3\u7b97\u65e5\u671f\u6210\u529f\uff01", map);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("projectName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        queryParam.getParams().put("orgId", new Parameter("in", childIds));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.service.queryPage(queryParam, false);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(loanInterest -> {
                PrjLoanInterestVO r = (PrjLoanInterestVO)BeanMapper.map((Object)loanInterest, PrjLoanInterestVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("loanInterest-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryCurrentInterest"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> queryCurrentInterest(Long projectId) {
        Map<String, BigDecimal> map = this.prjLoanInterestSubService.queryCurrentInterest(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6700\u540e\u7ed3\u7b97\u65e5\u671f\u6210\u529f\uff01", map);
    }

    public void listSubOrderCreateTimeBy(List<PrjLoanInterestSubVO> prjLoanInterestSubVOList) {
        if (CollectionUtils.isEmpty(prjLoanInterestSubVOList)) {
            return;
        }
        Collections.sort(prjLoanInterestSubVOList, new Comparator<PrjLoanInterestSubVO>(){

            @Override
            public int compare(PrjLoanInterestSubVO o1, PrjLoanInterestSubVO o2) {
                try {
                    long time1 = o1.getCreateTime().getTime();
                    long time2 = o2.getCreateTime().getTime();
                    if (time1 > time2) {
                        return -1;
                    }
                    if (time1 < time2) {
                        return 1;
                    }
                    return 0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
    }
}

