package com.ejianc.business.prjfinance.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prjfinance.bean.ReturnMoneyEntity;
import com.ejianc.business.prjfinance.service.IReturnMoneyService;
import com.ejianc.business.prjfinance.vo.ReturnMoneyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 项目还款
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("returnMoney")
public class ReturnMoneyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private static final String BILL_CODE = "prjfrance-return-001";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IReturnMoneyService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReturnMoneyVO> saveOrUpdate(@RequestBody ReturnMoneyVO saveorUpdateVO) {
    	ReturnMoneyEntity entity = BeanMapper.map(saveorUpdateVO, ReturnMoneyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        QueryParam param = new QueryParam();
        param.getParams().put("projectId",new Parameter(QueryParam.EQ,entity.getProjectId()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "0,2,4,5"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<ReturnMoneyEntity> list = service.queryList(param);
        if(ListUtil.isNotEmpty(list)){
            if(entity.getId() == null || entity.getId() == 0){
                throw new BusinessException("存在未审批完成的还款单【"+list.get(0).getCode()+"】，无法新增还款单！");
            }
            if(!entity.getId().equals(list.get(0).getId())){
                throw new BusinessException("存在未审批完成的还款单【"+list.get(0).getCode()+"】，无法更新还款单！");
            }
        }
    	service.saveOrUpdate(entity, false);



    	ReturnMoneyVO vo = BeanMapper.map(entity, ReturnMoneyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReturnMoneyVO> queryDetail(Long id) {
    	ReturnMoneyEntity entity = service.selectById(id);
    	ReturnMoneyVO vo = BeanMapper.map(entity, ReturnMoneyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReturnMoneyVO> vos) {
        service.removeByIds(vos.stream().map(ReturnMoneyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReturnMoneyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        fuzzyFields.add("dealPerson");

        CommonResponse<List<OrgVO>> childOrgResp = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("分页列表查询失败, 查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<ReturnMoneyEntity> page = service.queryPage(param,false);
        IPage<ReturnMoneyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReturnMoneyVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Author mrsir_wxp
     * @Date 2021/7/24 导出借款退还列表
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @PostMapping(value = "excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("dealPerson");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("code");
        queryParam.setPageSize(100000);

        CommonResponse<List<OrgVO>> childOrgResp = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("分页列表查询失败, 查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<ReturnMoneyEntity> page = service.queryPage(queryParam);
        List<ReturnMoneyVO> voList = new ArrayList<>();
        if (page.getTotal() > 0) {
            voList = BeanMapper.mapList(page.getRecords(), ReturnMoneyVO.class);
            voList.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription()));
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("project-loan-return-export.xlsx", beans, response);
    }
}
