/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prjfinance.bean.RiskMarginEntity;
import com.ejianc.business.prjfinance.mapper.RiskMarginMapper;
import com.ejianc.business.prjfinance.service.IRiskMarginService;
import com.ejianc.business.prjfinance.vo.RiskMarginVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="riskMarginService")
public class RiskMarginServiceImpl
extends BaseServiceImpl<RiskMarginMapper, RiskMarginEntity>
implements IRiskMarginService {
    @Autowired
    private RiskMarginMapper riskMarginMapper;

    @Override
    public Map<String, BigDecimal> getProjectCashDepositInfo(Long projectId) {
        HashMap<String, BigDecimal> resp = new HashMap<String, BigDecimal>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{" sum(if(bill_type = 1, apply_amt, 0)) as totalDeductCashDeposit, sum(if(bill_type = 2, apply_amt, 0)) as totalBackCashDeposit"});
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.and(q -> (QueryWrapper)((QueryWrapper)q.or(qe -> (QueryWrapper)qe.eq((Object)"bill_state", (Object)BillStateEnum.COMMITED_STATE.getBillStateCode()))).or(qe -> (QueryWrapper)qe.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode())));
        Map data = super.getMap((Wrapper)query);
        if (null != data) {
            resp.put("totalDeductCashDeposit", null != data.get("totalDeductCashDeposit") ? new BigDecimal(data.get("totalDeductCashDeposit").toString()) : BigDecimal.ZERO);
            resp.put("totalBackCashDeposit", null != data.get("totalBackCashDeposit") ? new BigDecimal(data.get("totalBackCashDeposit").toString()) : BigDecimal.ZERO);
            resp.put("spareDepositAmt", ((BigDecimal)resp.get("totalDeductCashDeposit")).subtract((BigDecimal)resp.get("totalBackCashDeposit")));
        } else {
            resp.put("totalDeductCashDeposit", BigDecimal.ZERO);
            resp.put("totalBackCashDeposit", BigDecimal.ZERO);
            resp.put("spareDepositAmt", BigDecimal.ZERO);
        }
        query = new QueryWrapper();
        query.select(new String[]{"sum(apply_amt) as totalBackAmt"});
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"bill_type", (Object)"2");
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        data = super.getMap((Wrapper)query);
        if (null != data) {
            resp.put("remremainingRefundableAmt", null != data.get("totalBackAmt") ? new BigDecimal(data.get("totalBackAmt").toString()) : BigDecimal.ZERO);
        } else {
            resp.put("remremainingRefundableAmt", BigDecimal.ZERO);
        }
        resp.put("remremainingRefundableAmt", ((BigDecimal)resp.get("totalDeductCashDeposit")).subtract((BigDecimal)resp.get("remremainingRefundableAmt")));
        return resp;
    }

    @Override
    public Map<String, BigDecimal> sumCashDeposit(QueryParam queryParam) {
        HashMap<String, BigDecimal> resp = new HashMap<String, BigDecimal>();
        Map queryResult = null;
        QueryWrapper query = RiskMarginServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        query.select(new String[]{" sum(if(bill_type = 1, apply_amt, 0)) as totalDeductCashDeposit, sum(if(bill_type = 2, apply_amt, 0)) as totalBackCashDeposit"});
        queryResult = super.getMap((Wrapper)query);
        if (null != queryResult) {
            resp.put("totalDeductCashDeposit", null != queryResult.get("totalDeductCashDeposit") ? new BigDecimal(queryResult.get("totalDeductCashDeposit").toString()) : BigDecimal.ZERO);
            resp.put("totalBackCashDeposit", null != queryResult.get("totalBackCashDeposit") ? new BigDecimal(queryResult.get("totalBackCashDeposit").toString()) : BigDecimal.ZERO);
        } else {
            resp.put("totalDeductCashDeposit", BigDecimal.ZERO);
            resp.put("totalBackCashDeposit", BigDecimal.ZERO);
        }
        return resp;
    }

    @Override
    public List<RiskMarginVO> freeBillListByPrjId(Long projectId, String billType, Long billId) {
        List entityList;
        List<Object> resp = new ArrayList<RiskMarginVO>();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        if (StringUtils.isNotBlank((CharSequence)billType)) {
            query.eq((Object)"bill_type", (Object)billType);
        }
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        if (null != billId) {
            query.ne((Object)"bill_id", (Object)billId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(entityList = super.list((Wrapper)query)))) {
            resp = BeanMapper.mapList((Iterable)entityList, RiskMarginVO.class);
        }
        return resp;
    }

    @Override
    public void delBySourceIds(List<Long> sourceIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_id", sourceIds);
        query.in((Object)"bill_type", new Object[]{"1"});
        query.in((Object)"dr", new Object[]{BaseVO.DR_UNDELETE});
        List delList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)delList)) {
            super.removeByIds((Collection)delList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
        }
    }

    @Override
    public Map<String, BigDecimal> getPrjFinanceData(Long projectId) {
        return this.riskMarginMapper.getPrjFinanceData(projectId);
    }
}

