package com.ejianc.business.prjfinance.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 借款利息结算子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prjfinance_loan_interest_sub")
public class PrjLoanInterestSubEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="loan_id")
    private Long loanId; // 单据id
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="loan_money")
    private java.math.BigDecimal loanMoney; // 借款金额
    @TableField(value="loan_balance")
    private java.math.BigDecimal loanBalance; // 借款结余
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="start_interest")
    private java.util.Date startInterest; // 计息开始日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="up_balance_date")
    private java.util.Date upBalanceDate; // 上次结算日期
    @TableField(value="year_interest")
    private java.math.BigDecimal yearInterest; // 年利率
    @TableField(value="day_interest")
    private java.math.BigDecimal dayInterest; // 日息
    @TableField(value="day_num")
    private Integer dayNum; // 利息天数
    @TableField(value="principal_interest")
    private java.math.BigDecimal principalInterest; // 本期利息
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="pid")
    private Long pid; // 借款利息id
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中

    public BigDecimal getDayInterest() {
        return dayInterest;
    }

    public void setDayInterest(BigDecimal dayInterest) {
        this.dayInterest = dayInterest;
    }

    public Integer getDayNum() {
        return dayNum;
    }

    public void setDayNum(Integer dayNum) {
        this.dayNum = dayNum;
    }

    public Long getLoanId() {
        return loanId;
    }

    public void setLoanId(Long loanId) {
        this.loanId = loanId;
    }

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 单据名称
     */
    public String getName() {
        return name;
    }

    /**
     * 单据名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 借款金额
     */
    public java.math.BigDecimal getLoanMoney() {
        return loanMoney;
    }

    /**
     * 借款金额
     */
    public void setLoanMoney(java.math.BigDecimal loanMoney) {
        this.loanMoney = loanMoney;
    }
    /**
     * 借款结余
     */
    public java.math.BigDecimal getLoanBalance() {
        return loanBalance;
    }

    /**
     * 借款结余
     */
    public void setLoanBalance(java.math.BigDecimal loanBalance) {
        this.loanBalance = loanBalance;
    }

    public Date getStartInterest() {
        return startInterest;
    }

    public void setStartInterest(Date startInterest) {
        this.startInterest = startInterest;
    }

    /**
     * 上次结算日期
     */
    public java.util.Date getUpBalanceDate() {
        return upBalanceDate;
    }

    /**
     * 上次结算日期
     */
    public void setUpBalanceDate(java.util.Date upBalanceDate) {
        this.upBalanceDate = upBalanceDate;
    }
    /**
     * 年利率
     */
    public java.math.BigDecimal getYearInterest() {
        return yearInterest;
    }

    /**
     * 年利率
     */
    public void setYearInterest(java.math.BigDecimal yearInterest) {
        this.yearInterest = yearInterest;
    }
    /**
     * 本期利息
     */
    public java.math.BigDecimal getPrincipalInterest() {
        return principalInterest;
    }

    /**
     * 本期利息
     */
    public void setPrincipalInterest(java.math.BigDecimal principalInterest) {
        this.principalInterest = principalInterest;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
