package com.ejianc.business.prjfinance.controller;

import java.io.Serializable;

import com.ejianc.business.prjfinance.bean.TaxCostEntity;
import com.ejianc.business.prjfinance.bean.TaxCostInvoiceEntity;
import com.ejianc.business.prjfinance.service.ITaxCostService;
import com.ejianc.business.prjfinance.vo.PrjOtherCostVO;
import com.ejianc.business.prjfinance.vo.TaxCostInvoiceVO;
import com.ejianc.business.prjfinance.vo.TaxCostVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;


/**
 * 税务费用
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("taxCost")
public class TaxCostController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IInvoiceApi invoiceApi;

    private static final String BILL_CODE = "tax_cost";//此处需要根据实际修改

    @Autowired
    private ITaxCostService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TaxCostVO> saveOrUpdate(@RequestBody TaxCostVO saveOrUpdateVO) {
    	TaxCostEntity entity = BeanMapper.map(saveOrUpdateVO, TaxCostEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<TaxCostInvoiceVO> taxCostInvoiceList = saveOrUpdateVO.getTaxCostInvoiceList();
    	if (CollectionUtils.isNotEmpty(taxCostInvoiceList)){
            List<InvoiceReceiveFlagVO> invoiceReceiveFlagVOList = new ArrayList();
            for (TaxCostInvoiceVO taxCostInvoiceVO : taxCostInvoiceList) {
                InvoiceReceiveFlagVO invoiceReceiveFlagVO = new InvoiceReceiveFlagVO();
                invoiceReceiveFlagVO.setId(taxCostInvoiceVO.getInvoiceId());
                if (!"del".equals(taxCostInvoiceVO.getRowState())){
                    invoiceReceiveFlagVO.setTaxCostFlag(1);
                }else {
                    invoiceReceiveFlagVO.setTaxCostFlag(0);
                }
                invoiceReceiveFlagVOList.add(invoiceReceiveFlagVO);
            }
            invoiceApi.updateFlag(invoiceReceiveFlagVOList);
        }
        service.saveOrUpdate(entity, false);
    	TaxCostVO vo = BeanMapper.map(entity, TaxCostVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TaxCostVO> queryDetail(Long id) {
    	TaxCostEntity entity = service.selectById(id);
    	TaxCostVO vo = BeanMapper.map(entity, TaxCostVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TaxCostVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            List<InvoiceReceiveFlagVO> invoiceReceiveFlagVOList = new ArrayList();
            for (TaxCostVO vo : vos) {
                TaxCostEntity taxCostEntity = service.selectById(vo.getId());
                List<TaxCostInvoiceEntity> taxCostInvoiceList = taxCostEntity.getTaxCostInvoiceList();
                if (CollectionUtils.isNotEmpty(taxCostInvoiceList)){
                    for (TaxCostInvoiceEntity detailEntity : taxCostInvoiceList) {
                        InvoiceReceiveFlagVO invoiceReceiveFlagVO = new InvoiceReceiveFlagVO();
                        invoiceReceiveFlagVO.setId(detailEntity.getInvoiceId());
                        invoiceReceiveFlagVO.setTaxCostFlag(0);
                        invoiceReceiveFlagVOList.add(invoiceReceiveFlagVO);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(invoiceReceiveFlagVOList)){
                invoiceApi.updateFlag(invoiceReceiveFlagVOList);
            }
        }
        service.removeByIds(vos.stream().map(TaxCostVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TaxCostVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", authOrgIds);
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            logger.info(">>>>>>>>>>>>>>>>>>>>>>2authOrgIds:{}, authResponse.getData():{}", authOrgIds, authResponse.getData() == null ? null : authResponse.getData().size());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<TaxCostEntity> page = service.queryPage(param,false);
        IPage<TaxCostVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TaxCostVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TaxCostEntity> list = service.queryList(param);
        List<TaxCostVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(o -> {
                TaxCostVO r = BeanMapper.map(o, TaxCostVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                voList.add(r);
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("TaxCost-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refTaxCostData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TaxCostVO>> refTaxCostData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TaxCostEntity> page = service.queryPage(param,false);
        IPage<TaxCostVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TaxCostVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
