package com.ejianc.business.prjfinance.service;

import com.ejianc.business.prjfinance.bean.PrjAdvancePaymentEntity;
import com.ejianc.business.prjfinance.vo.PrjAdvancePaymentVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/7/21 19:27
 */
public interface IPrjAdvancePaymentService extends IBaseService<PrjAdvancePaymentEntity> {
    /**
     * 查询指定条件下累计带转款/累计退款情况
     *
     * @param queryParam
     * @return
     */
    Map<String, BigDecimal> sumPrjAdvancePayInfo(QueryParam queryParam);

    /**
     * 统计指定项目的累计代转款、累计退款、剩余待转款、剩余可退金额
     *
     * @param projectId
     * @return
     */
    Map<String, BigDecimal> getTotalPrjAdvancePayInfo(Long projectId);

    /**
     * 查询指定项目的满足匹配条件的最近一条生效单据
     *
     * @param projectId
     * @param billType
     * @return
     */
    PrjAdvancePaymentVO getLastBillAccInfo(Long projectId, String billType);
}
