package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.vo.ExpenditureVO;
import com.ejianc.business.finance.vo.IncomeVO;
import com.ejianc.business.finance.vo.OperateProjectVO;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.mapper.ProjectDutyLetterMapper;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.vo.OperationCostVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service("projectDutyLetterService")
public class ProjectDutyLetterService extends BaseServiceImpl<ProjectDutyLetterMapper, ProjectDutyLetterEntity> implements IProjectDutyLetterService {
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public ProjectDutyLetterEntity selectByPrjojectId(Long projectId) {
        QueryWrapper<ProjectDutyLetterEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.getOne(query);
    }

    /**
     * 根据项目Id查询对应的联营项目费用列表
     */
    @Override
    public List<OperationCostVO> getOperationList(OperationCostVO operationCostVO) {
        return baseMapper.getOperationList(operationCostVO.getProjectId(),null);
    }

    @Override
    public List<OperationCostVO> getOperationList4Org() {
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        return baseMapper.getOperationList(null, orgIds);
    }
}
