/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prjfinance.bean.ReturnMoneyEntity;
import com.ejianc.business.prjfinance.service.IReturnMoneyService;
import com.ejianc.business.prjfinance.vo.ReturnMoneyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"returnMoney"})
public class ReturnMoneyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "prjfrance-return-001";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReturnMoneyService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ReturnMoneyVO> saveOrUpdate(@RequestBody ReturnMoneyVO saveorUpdateVO) {
        ReturnMoneyEntity entity = (ReturnMoneyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ReturnMoneyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)entity.getProjectId()));
        param.getParams().put("billState", new Parameter("in", (Object)"0,2,4,5"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)list)) {
            if (entity.getId() == null || entity.getId() == 0L) {
                throw new BusinessException("\u5b58\u5728\u672a\u5ba1\u6279\u5b8c\u6210\u7684\u8fd8\u6b3e\u5355\u3010" + ((ReturnMoneyEntity)((Object)list.get(0))).getCode() + "\u3011\uff0c\u65e0\u6cd5\u65b0\u589e\u8fd8\u6b3e\u5355\uff01");
            }
            if (!entity.getId().equals(((ReturnMoneyEntity)((Object)list.get(0))).getId())) {
                throw new BusinessException("\u5b58\u5728\u672a\u5ba1\u6279\u5b8c\u6210\u7684\u8fd8\u6b3e\u5355\u3010" + ((ReturnMoneyEntity)((Object)list.get(0))).getCode() + "\u3011\uff0c\u65e0\u6cd5\u66f4\u65b0\u8fd8\u6b3e\u5355\uff01");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ReturnMoneyVO vo = (ReturnMoneyVO)BeanMapper.map((Object)((Object)entity), ReturnMoneyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReturnMoneyVO> queryDetail(Long id) {
        ReturnMoneyEntity entity = (ReturnMoneyEntity)((Object)this.service.selectById(id));
        ReturnMoneyVO vo = (ReturnMoneyVO)BeanMapper.map((Object)((Object)entity), ReturnMoneyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReturnMoneyVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReturnMoneyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        fuzzyFields.add("dealPerson");
        CommonResponse childOrgResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        param.getParams().put("orgId", new Parameter("in", childIds));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReturnMoneyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("dealPerson");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("code");
        queryParam.setPageSize(100000);
        CommonResponse childOrgResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        queryParam.getParams().put("orgId", new Parameter("in", childIds));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(queryParam);
        List voList = new ArrayList();
        if (page.getTotal() > 0L) {
            voList = BeanMapper.mapList((Iterable)page.getRecords(), ReturnMoneyVO.class);
            voList.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("project-loan-return-export.xlsx", beans, response);
    }
}

