package com.ejianc.business.bid.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author baipengyan
 * @date 2022/7/21
 * @description 审批是否生效
 */
public enum EffectFlagEnum {
	INVALID(0, "未生效"),
	EFFECT(1, "已生效");

	private final Integer code;
	private final String name;

	EffectFlagEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	private static Map<Integer, EffectFlagEnum> enumMap = new HashMap<>();

	static {
		enumMap = EnumSet.allOf(EffectFlagEnum.class).stream().collect(Collectors.toMap(EffectFlagEnum::getCode, Function.identity(), (k1, k2) -> k2));
	}

	public static EffectFlagEnum getByCode(Integer code) {
		return enumMap.get(code);
	}

}
