package com.ejianc.business.open.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 开标记录实体
 *
 * @author generator
 */
@TableName("ejc_probid_bid_open_record")
public class OpenEntity extends BaseEntity {
	private static final long serialVersionUID = -2455978228705540569L;

	@TableField(value = "employee_id")
	private Long employeeId; // 经办人id
	@TableField(value = "employee_name")
	private String employeeName; // 经办人名称
	@TableField(value = "commit_date")
	private Date commitDate; // 提交日期
	@TableField(value = "commit_user_name")
	private String commitUserName; // 提交人名称
	@TableField(value = "commit_user_code")
	private String commitUserCode; // 提交人账号
	@TableField(value = "effective_date")
	private Date effectiveDate; // 生效日期
	@TableField(value = "bill_code")
	private String billCode; // 单据编码
	@TableField(value = "bill_name")
	private String billName; // 单据名称
	@TableField(value = "bill_type")
	private String billType; // 单据类型
	@TableField(value = "bill_state")
	private Integer billState; // 单据状态
	@TableField(value = "bill_state_name")
	private String billStateName; // 单据状态名称
	@TableField(value = "project_id")
	private Long projectId; // 项目id
	@TableField(value = "project_code")
	private String projectCode; // 项目编码
	@TableField(value = "project_name")
	private String projectName; // 项目名称
	@TableField(value = "construction_unit")
	private String constructionUnit; // 建设单位
	@TableField(value = "registration_deadline")
	private Date registrationDeadline; // 报名截止日期
	@TableField(value = "bid_open_date")
	private Date bidOpenDate; // 开标日期
	@TableField(value = "bid_unit_id")
	private Long bidUnitId; // 投标单位id
	@TableField(value = "bid_unit_code")
	private String bidUnitCode; // 投标单位编码
	@TableField(value = "bid_unit_name")
	private String bidUnitName; // 投标单位名称
	@TableField(value = "bid_open_place")
	private String bidOpenPlace; // 开标地点
	@TableField(value = "bid_open_author_name")
	private String bidOpenAuthorName; // 开标授权人
	@TableField(value = "bid_company_name")
	private String bidCompanyName; // 招标公司
	@TableField(value = "source_bond_pay_id")
	private Long sourceBondPayId; // 保证金缴纳id
	@TableField(value = "bond_mode")
	private String bondMode; // 保证金形式 0-现金、1-保函
	@TableField(value = "bid_bond_mny")
	private BigDecimal bidBondMny; // 投标保证金
	@TableField(value = "source_bid_tender_id")
	private Long sourceBidTenderId; // 标书购买id
	@TableField(value = "intercept_tender_mny")
	private BigDecimal interceptTenderMny; // 拦标价
	@TableField(value = "a_value")
	private BigDecimal aValue; // A值
	@TableField(value = "g_value")
	private BigDecimal gValue; // G值
	@TableField(value = "memo")
	private String memo; // 说明


	@TableField(exist = false)
	@SubEntity(serviceName = "openDetailService")//此处有pid="xxx"，默认值pid="pid"
	private List<OpenDetailEntity> openDetailList = new ArrayList<>(); // 开标记录-开标记录明细实体


	public Long getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getConstructionUnit() {
		return constructionUnit;
	}

	public void setConstructionUnit(String constructionUnit) {
		this.constructionUnit = constructionUnit;
	}

	public Date getRegistrationDeadline() {
		return registrationDeadline;
	}

	public void setRegistrationDeadline(Date registrationDeadline) {
		this.registrationDeadline = registrationDeadline;
	}

	public Date getBidOpenDate() {
		return bidOpenDate;
	}

	public void setBidOpenDate(Date bidOpenDate) {
		this.bidOpenDate = bidOpenDate;
	}

	public Long getBidUnitId() {
		return bidUnitId;
	}

	public void setBidUnitId(Long bidUnitId) {
		this.bidUnitId = bidUnitId;
	}

	public String getBidUnitCode() {
		return bidUnitCode;
	}

	public void setBidUnitCode(String bidUnitCode) {
		this.bidUnitCode = bidUnitCode;
	}

	public String getBidUnitName() {
		return bidUnitName;
	}

	public void setBidUnitName(String bidUnitName) {
		this.bidUnitName = bidUnitName;
	}

	public String getBidOpenPlace() {
		return bidOpenPlace;
	}

	public void setBidOpenPlace(String bidOpenPlace) {
		this.bidOpenPlace = bidOpenPlace;
	}

	public String getBidOpenAuthorName() {
		return bidOpenAuthorName;
	}

	public void setBidOpenAuthorName(String bidOpenAuthorName) {
		this.bidOpenAuthorName = bidOpenAuthorName;
	}

	public String getBidCompanyName() {
		return bidCompanyName;
	}

	public void setBidCompanyName(String bidCompanyName) {
		this.bidCompanyName = bidCompanyName;
	}

	public Long getSourceBondPayId() {
		return sourceBondPayId;
	}

	public void setSourceBondPayId(Long sourceBondPayId) {
		this.sourceBondPayId = sourceBondPayId;
	}

	public String getBondMode() {
		return bondMode;
	}

	public void setBondMode(String bondMode) {
		this.bondMode = bondMode;
	}

	public BigDecimal getBidBondMny() {
		return bidBondMny;
	}

	public void setBidBondMny(BigDecimal bidBondMny) {
		this.bidBondMny = bidBondMny;
	}

	public Long getSourceBidTenderId() {
		return sourceBidTenderId;
	}

	public void setSourceBidTenderId(Long sourceBidTenderId) {
		this.sourceBidTenderId = sourceBidTenderId;
	}

	public BigDecimal getInterceptTenderMny() {
		return interceptTenderMny;
	}

	public void setInterceptTenderMny(BigDecimal interceptTenderMny) {
		this.interceptTenderMny = interceptTenderMny;
	}

	public BigDecimal getAValue() {
		return aValue;
	}

	public void setAValue(BigDecimal aValue) {
		this.aValue = aValue;
	}

	public BigDecimal getGValue() {
		return gValue;
	}

	public void setGValue(BigDecimal gValue) {
		this.gValue = gValue;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public List<OpenDetailEntity> getOpenDetailList() {
		return openDetailList;
	}

	public void setOpenDetailList(List<OpenDetailEntity> openDetailList) {
		this.openDetailList = openDetailList;
	}
}
