package com.ejianc.business.pay.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 保证金缴纳实体
 *
 * @author generator
 */
@TableName("ejc_probid_bond_pay")
public class PayEntity extends BaseEntity {
	private static final long serialVersionUID = -5475098256990805990L;

	@TableField(value = "employee_id")
	private Long employeeId; // 经办人id
	@TableField(value = "employee_name")
	private String employeeName; // 经办人名称
	@TableField(value = "commit_date")
	private Date commitDate; // 提交日期
	@TableField(value = "commit_user_name")
	private String commitUserName; // 提交人名称
	@TableField(value = "commit_user_code")
	private String commitUserCode; // 提交人账号
	@TableField(value = "effective_date")
	private Date effectiveDate; // 生效日期
	@TableField(value = "bill_code")
	private String billCode; // 单据编码
	@TableField(value = "bill_name")
	private String billName; // 单据名称
	@TableField(value = "bill_type")
	private String billType; // 单据类型
	@TableField(value = "bill_state")
	private Integer billState; // 单据状态
	@TableField(value = "bill_state_name")
	private String billStateName; // 单据状态名称
	@TableField(value = "project_id")
	private Long projectId; // 项目id
	@TableField(value = "project_code")
	private String projectCode; // 项目编码
	@TableField(value = "project_name")
	private String projectName; // 项目名称
	@TableField(value = "construction_unit")
	private String constructionUnit; // 建设单位
	@TableField(value = "registration_deadline")
	private Date registrationDeadline; // 报名截止日期
	@TableField(value = "bid_open_date")
	private Date bidOpenDate; // 开标日期
	@TableField(value = "bid_unit_id")
	private Long bidUnitId; // 投标单位id
	@TableField(value = "bid_unit_code")
	private String bidUnitCode; // 投标单位编码
	@TableField(value = "bid_unit_name")
	private String bidUnitName; // 投标单位名称
	@TableField(value = "bond_mode")
	private String bondMode; // 保证金形式 0-现金、1-保函
	@TableField(value = "memo")
	private String memo; // 说明
	@TableField(value = "assure_start_date")
	private Date assureStartDate; // 担保开始日期
	@TableField(value = "assure_end_date")
	private Date assureEndDate; // 担保结束日期
	@TableField(value = "backletter_mny")
	private BigDecimal backletterMny; // 保函金额
	@TableField(value = "assure_mny")
	private BigDecimal assureMny; // 其中要求担保金额
	@TableField(value = "managing_bank_name")
	private String managingBankName; // 经办银行
	@TableField(value = "backletter_service_fee")
	private BigDecimal backletterServiceFee; // 保函手续费
	@TableField(value = "pay_mny")
	private BigDecimal payMny; // 缴纳金额
	@TableField(value = "back_mny")
	private BigDecimal backMny; // 退还金额
	@TableField(value = "remain_mny")
	private BigDecimal remainMny; // 剩余金额


	@TableField(exist = false)
	@SubEntity(serviceName = "payBackRecordService")//此处有pid="xxx"，默认值pid="pid"
	private List<PayBackRecordEntity> payBackRecordList = new ArrayList<>(); // 保证金缴纳-退还记录实体


	public Long getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getConstructionUnit() {
		return constructionUnit;
	}

	public void setConstructionUnit(String constructionUnit) {
		this.constructionUnit = constructionUnit;
	}

	public Date getRegistrationDeadline() {
		return registrationDeadline;
	}

	public void setRegistrationDeadline(Date registrationDeadline) {
		this.registrationDeadline = registrationDeadline;
	}

	public Date getBidOpenDate() {
		return bidOpenDate;
	}

	public void setBidOpenDate(Date bidOpenDate) {
		this.bidOpenDate = bidOpenDate;
	}

	public Long getBidUnitId() {
		return bidUnitId;
	}

	public void setBidUnitId(Long bidUnitId) {
		this.bidUnitId = bidUnitId;
	}

	public String getBidUnitCode() {
		return bidUnitCode;
	}

	public void setBidUnitCode(String bidUnitCode) {
		this.bidUnitCode = bidUnitCode;
	}

	public String getBidUnitName() {
		return bidUnitName;
	}

	public void setBidUnitName(String bidUnitName) {
		this.bidUnitName = bidUnitName;
	}

	public String getBondMode() {
		return bondMode;
	}

	public void setBondMode(String bondMode) {
		this.bondMode = bondMode;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public Date getAssureStartDate() {
		return assureStartDate;
	}

	public void setAssureStartDate(Date assureStartDate) {
		this.assureStartDate = assureStartDate;
	}

	public Date getAssureEndDate() {
		return assureEndDate;
	}

	public void setAssureEndDate(Date assureEndDate) {
		this.assureEndDate = assureEndDate;
	}

	public BigDecimal getBackletterMny() {
		return backletterMny;
	}

	public void setBackletterMny(BigDecimal backletterMny) {
		this.backletterMny = backletterMny;
	}

	public BigDecimal getAssureMny() {
		return assureMny;
	}

	public void setAssureMny(BigDecimal assureMny) {
		this.assureMny = assureMny;
	}

	public String getManagingBankName() {
		return managingBankName;
	}

	public void setManagingBankName(String managingBankName) {
		this.managingBankName = managingBankName;
	}

	public BigDecimal getBackletterServiceFee() {
		return backletterServiceFee;
	}

	public void setBackletterServiceFee(BigDecimal backletterServiceFee) {
		this.backletterServiceFee = backletterServiceFee;
	}

	public BigDecimal getPayMny() {
		return payMny;
	}

	public void setPayMny(BigDecimal payMny) {
		this.payMny = payMny;
	}

	public BigDecimal getBackMny() {
		return backMny;
	}

	public void setBackMny(BigDecimal backMny) {
		this.backMny = backMny;
	}

	public BigDecimal getRemainMny() {
		return remainMny;
	}

	public void setRemainMny(BigDecimal remainMny) {
		this.remainMny = remainMny;
	}

	public List<PayBackRecordEntity> getPayBackRecordList() {
		return payBackRecordList;
	}

	public void setPayBackRecordList(List<PayBackRecordEntity> payBackRecordList) {
		this.payBackRecordList = payBackRecordList;
	}
}
