package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.ProjectEntity;
import com.ejianc.business.bid.mapper.ProjectMapper;
import com.ejianc.business.bid.service.IProjectService;
import com.ejianc.business.bid.service.IRegisDataService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;

/**
 * 投标立项
 *
 * @author generator
 *
 */
@Service("projectService")
public class ProjectServiceImpl extends BaseServiceImpl<ProjectMapper, ProjectEntity> implements IProjectService{

    @Autowired
    private IRegisDataService dataService;
    @Override
    public void updateBidStatus(ProjectEntity entity) {
        LambdaUpdateWrapper<ProjectEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ProjectEntity::getId, entity.getId());
        if (entity.getBidStatus()!=null){
            updateWrapper.set(ProjectEntity::getBidStatus, entity.getBidStatus());

        }
        if (entity.getPrequalificationFlag()!=null){
            updateWrapper.set(ProjectEntity::getPrequalificationFlag, entity.getPrequalificationFlag());

        }
        if (entity.getRegistDataFlag()!=null){
            QueryWrapper registrationQuery = new QueryWrapper();
            ArrayList<Integer> billState = new ArrayList<>();
            billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            registrationQuery.eq("project_id",entity.getId());
            registrationQuery.eq("dr",0);
            registrationQuery.in("bill_state", billState);
            int countReg = dataService.count(registrationQuery);
            if (countReg>0){
                updateWrapper.set(ProjectEntity::getRegistDataFlag,1);
            }else {
                updateWrapper.set(ProjectEntity::getRegistDataFlag,0);
            }
        }
        super.update(updateWrapper);
    }


	/**
	 * 根据项目id更新项目状态
	 *
	 * @param projectId 项目id
	 * @param bidStatus 状态
	 */
	@Override
	public void updateProjectStatus(Long projectId, String bidStatus) {
		LambdaUpdateWrapper<ProjectEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(ProjectEntity::getId, projectId);
		updateWrapper.set(ProjectEntity::getBidStatus, bidStatus);
		super.update(updateWrapper);
	}
}
