package com.ejianc.business.open.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.open.bean.OpenEntity;
import com.ejianc.business.open.service.IOpenService;
import com.ejianc.business.open.vo.OpenVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 开标记录实体
 *
 * @author generator
 */
@RestController
@RequestMapping("open")
public class OpenController implements Serializable {
	private static final long serialVersionUID = 1190417899720942216L;

	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String RULE_CODE = "PROBID_OPEN";
	private static final String BILL_CODE = "EJCBT202207000024";
	private final IBillTypeApi billTypeApi;
	private final IBillCodeApi billCodeApi;
	private final IOrgApi iOrgApi;
	private final IOpenService service;
	private final SessionManager sessionManager;

	public OpenController(IBillTypeApi billTypeApi, IBillCodeApi billCodeApi, IOrgApi iOrgApi, IOpenService service, SessionManager sessionManager) {
		this.billTypeApi = billTypeApi;
		this.billCodeApi = billCodeApi;
		this.iOrgApi = iOrgApi;
		this.service = service;
		this.sessionManager = sessionManager;
	}

	/**
	 * @Description saveOrUpdate 新增或者修改
	 */
	@PostMapping(value = "/saveOrUpdate")
	public CommonResponse<OpenVO> saveOrUpdate(@RequestBody OpenVO saveOrUpdateVO) {
		OpenEntity entity = BeanMapper.map(saveOrUpdateVO, OpenEntity.class);
		if (entity.getId() == null || entity.getId() == 0) {
			BillCodeParam billCodeParam = BillCodeParam.build(RULE_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
			CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
			if (billCode.isSuccess()) {
				entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
			} else {
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
		}

		// 单据名称、单据类型
		entity.setBillName("开标记录");
		entity.setBillType(BILL_CODE);
		entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());

		service.saveOrUpdate(entity, false);
		OpenVO vo = BeanMapper.map(entity, OpenVO.class);
		return CommonResponse.success("保存或修改单据成功！", vo);
	}

	/**
	 * @param id
	 *
	 * @Description queryDetail 查询详情
	 */
	@GetMapping(value = "/queryDetail")
	public CommonResponse<OpenVO> queryDetail(Long id) {
		OpenEntity entity = service.selectById(id);
		OpenVO vo = BeanMapper.map(entity, OpenVO.class);
		return CommonResponse.success("查询详情数据成功！", vo);
	}

	/**
	 * @Description delete 批量删除单据
	 * @Param [ids]
	 */
	@PostMapping(value = "/delete")
	public CommonResponse<String> delete(@RequestBody List<OpenVO> vos) {
		if (ListUtil.isNotEmpty(vos)) {
			for (OpenVO vo : vos) {
				// 参数是单据类型编码字符串 根据需求是否打开下面代码
				CommonResponse<String> resp = billTypeApi.checkQuote(BILL_CODE, vo.getId());
				if (!resp.isSuccess()) {
					return CommonResponse.error("删除失败！" + resp.getMsg());
				}
			}
		}
		service.removeByIds(vos.stream().map(OpenVO::getId).collect(Collectors.toList()), true);
		return CommonResponse.success("删除成功！");
	}

	/**
	 * @param param
	 *
	 * @Description queryList 查询列表
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@PostMapping(value = "/queryList")
	public CommonResponse<IPage<OpenVO>> queryList(@RequestBody QueryParam param) {
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("projectName");
		fuzzyFields.add("bidUnitName");
		fuzzyFields.add("employeeName");

		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		param.getParams().put("bid_unit_id", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

		IPage<OpenEntity> page = service.queryPage(param, false);
		IPage<OpenVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OpenVO.class));

		return CommonResponse.success("查询列表数据成功！", pageData);
	}


	/**
	 * @param param
	 *
	 * @Description 导出
	 * @Return void
	 */
	@PostMapping(value = "/excelExport")
	public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("projectName");
		fuzzyFields.add("bidUnitName");
		fuzzyFields.add("employeeName");

		param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		param.setPageIndex(1);
		param.setPageSize(-1);

		param.getParams().put("bid_unit_id", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

		IPage<OpenEntity> page = service.queryPage(param, false);
		List<OpenVO> opens = new ArrayList<>();

		page.getRecords().forEach(e -> {
			OpenVO open = BeanMapper.map(e, OpenVO.class);
			open.setBillStateName(BillStateEnum.getEnumByStateCode(open.getBillState()).getDescription());
			opens.add(open);
		});

		Map<String, Object> beans = new HashMap<>();
		beans.put("records", opens);
		ExcelExport.getInstance().export("open-export.xlsx", beans, response);
	}

}
