package com.ejianc.business.pay.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pay.bean.PayEntity;
import com.ejianc.business.pay.mapper.PayMapper;
import com.ejianc.business.pay.service.IPayService;
import com.ejianc.business.pay.vo.PayVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 保证金缴纳实体
 *
 * @author generator
 */
@Service("payService")
public class PayServiceImpl extends BaseServiceImpl<PayMapper, PayEntity> implements IPayService {

	/**
	 * 根据投标立项项目id查询保证金缴纳记录
	 *
	 * @param projectId 投标立项项目id
	 */
	@Override
	public PayVO queryDetailByProjectId(Long projectId) {
		QueryWrapper<PayEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("project_id", projectId);
		return BeanMapper.map(super.getOne(wrapper), PayVO.class);
	}

}
