package com.ejianc.business.record.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 工程投标备案实体
 *
 * @author generator
 */
@TableName("ejc_probid_bid_record")
public class RecordEntity extends BaseEntity {
	private static final long serialVersionUID = -2130094103844775538L;

	@TableField(value = "employee_id")
	private Long employeeId; // 经办人id
	@TableField(value = "employee_name")
	private String employeeName; // 经办人名称
	@TableField(value = "commit_date")
	private Date commitDate; // 提交日期
	@TableField(value = "commit_user_name")
	private String commitUserName; // 提交人名称
	@TableField(value = "commit_user_code")
	private String commitUserCode; // 提交人账号
	@TableField(value = "effective_date")
	private Date effectiveDate; // 生效日期
	@TableField(value = "bill_code")
	private String billCode; // 单据编码
	@TableField(value = "bill_name")
	private String billName; // 单据名称
	@TableField(value = "bill_type")
	private String billType; // 单据类型
	@TableField(value = "bill_state")
	private Integer billState; // 单据状态
	@TableField(value = "bill_state_name")
	private String billStateName; // 单据状态名称
	@TableField(value = "project_id")
	private Long projectId; // 项目id
	@TableField(value = "project_code")
	private String projectCode; // 项目编码
	@TableField(value = "project_name")
	private String projectName; // 项目名称
	@TableField(value = "construction_unit")
	private String constructionUnit; // 建设单位
	@TableField(value = "construction_unit_contact")
	private String constructionUnitContact; // 建设单位联系人
	@TableField(value = "construction_unit_phone")
	private String constructionUnitPhone; // 建设单位联系电话
	@TableField(value = "bid_agency")
	private String bidAgency; // 招标代理机构
	@TableField(value = "bid_agency_contact")
	private String bidAgencyContact; // 招标代理机构联系人
	@TableField(value = "bid_agency_phone")
	private String bidAgencyPhone; // 招标代理机构联系电话
	@TableField(value = "bid_unit_id")
	private Long bidUnitId; // 投标单位id
	@TableField(value = "bid_unit_code")
	private String bidUnitCode; // 投标单位编码
	@TableField(value = "bid_unit_name")
	private String bidUnitName; // 投标单位名称
	@TableField(value = "project_total_area")
	private BigDecimal projectTotalArea; // 项目总面积
	@TableField(value = "structure_id")
	private Long structureId; // 结构id
	@TableField(value = "structure_code")
	private String structureCode; // 结构编码
	@TableField(value = "structure_name")
	private String structureName; // 结构名称
	@TableField(value = "layers")
	private Integer layers; // 层数
	@TableField(value = "bid_open_date")
	private Date bidOpenDate; // 开标日期
	@TableField(value = "bid_open_place")
	private String bidOpenPlace; // 开标地点
	@TableField(value = "project_total_mny")
	private BigDecimal projectTotalMny; // 项目总投资
	@TableField(value = "tender_mode_id")
	private Long tenderModeId; // 招标方式id
	@TableField(value = "tender_mode_code")
	private String tenderModeCode; // 招标方式编码
	@TableField(value = "tender_mode_name")
	private String tenderModeName; // 招标方式名称
	@TableField(value = "evaluation_method")
	private String evaluationMethod; // 评标办法 0-综合评估法、1-经评审的最低投标价法、2-其他
	@TableField(value = "project_type_id")
	private Long projectTypeId; // 项目类型id
	@TableField(value = "project_type_code")
	private String projectTypeCode; // 项目类型编码
	@TableField(value = "project_type_name")
	private String projectTypeName; // 项目类型名称
	@TableField(value = "quote_mode_id")
	private Long quoteModeId; // 报价方式id
	@TableField(value = "quote_mode_code")
	private String quoteModeCode; // 报价方式编码
	@TableField(value = "quote_mode_name")
	private String quoteModeName; // 报价方式名称
	@TableField(value = "source_bid_tender_id")
	private Long sourceBidTenderId; // 标书购买id
	@TableField(value = "intercept_tender_mny")
	private BigDecimal interceptTenderMny; // 拦标价
	@TableField(value = "bid_bond")
	private BigDecimal bidBond; // 投标保证金
	@TableField(value = "performance_bond")
	private BigDecimal performanceBond; // 履约保证金
	@TableField(value = "project_content_id")
	private String projectContentId; // 工程内容id
	@TableField(value = "project_content_code")
	private String projectContentCode; // 工程内容code
	@TableField(value = "project_content_name")
	private String projectContentName; // 工程内容name
	@TableField(value = "prepayment_and_payment_mode")
	private String prepaymentAndPaymentMode; // 预付款及付款方式
	@TableField(value = "memo")
	private String memo; // 备注


	@TableField(exist = false)
	@SubEntity(serviceName = "recordFundService", pidName = "bidRecordId")//此处有pid="xxx"，默认值pid="pid"
	private List<RecordFundEntity> recordFundList = new ArrayList<>(); // 工程投标备案-资金情况实体
	@TableField(exist = false)
	@SubEntity(serviceName = "recordRequirementService", pidName = "bidRecordId")//此处有pid="xxx"，默认值pid="pid"
	private List<RecordRequirementEntity> recordRequirementList = new ArrayList<>(); // 工程投标备案-投标要求实体
	@TableField(exist = false)
	@SubEntity(serviceName = "recordStaffService", pidName = "bidRecordId")//此处有pid="xxx"，默认值pid="pid"
	private List<RecordStaffEntity> recordStaffList = new ArrayList<>(); // 工程投标备案-人员要求实体


	public Long getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getConstructionUnit() {
		return constructionUnit;
	}

	public void setConstructionUnit(String constructionUnit) {
		this.constructionUnit = constructionUnit;
	}

	public String getConstructionUnitContact() {
		return constructionUnitContact;
	}

	public void setConstructionUnitContact(String constructionUnitContact) {
		this.constructionUnitContact = constructionUnitContact;
	}

	public String getConstructionUnitPhone() {
		return constructionUnitPhone;
	}

	public void setConstructionUnitPhone(String constructionUnitPhone) {
		this.constructionUnitPhone = constructionUnitPhone;
	}

	public String getBidAgency() {
		return bidAgency;
	}

	public void setBidAgency(String bidAgency) {
		this.bidAgency = bidAgency;
	}

	public String getBidAgencyContact() {
		return bidAgencyContact;
	}

	public void setBidAgencyContact(String bidAgencyContact) {
		this.bidAgencyContact = bidAgencyContact;
	}

	public String getBidAgencyPhone() {
		return bidAgencyPhone;
	}

	public void setBidAgencyPhone(String bidAgencyPhone) {
		this.bidAgencyPhone = bidAgencyPhone;
	}

	public Long getBidUnitId() {
		return bidUnitId;
	}

	public void setBidUnitId(Long bidUnitId) {
		this.bidUnitId = bidUnitId;
	}

	public String getBidUnitCode() {
		return bidUnitCode;
	}

	public void setBidUnitCode(String bidUnitCode) {
		this.bidUnitCode = bidUnitCode;
	}

	public String getBidUnitName() {
		return bidUnitName;
	}

	public void setBidUnitName(String bidUnitName) {
		this.bidUnitName = bidUnitName;
	}

	public BigDecimal getProjectTotalArea() {
		return projectTotalArea;
	}

	public void setProjectTotalArea(BigDecimal projectTotalArea) {
		this.projectTotalArea = projectTotalArea;
	}

	public Long getStructureId() {
		return structureId;
	}

	public void setStructureId(Long structureId) {
		this.structureId = structureId;
	}

	public String getStructureCode() {
		return structureCode;
	}

	public void setStructureCode(String structureCode) {
		this.structureCode = structureCode;
	}

	public String getStructureName() {
		return structureName;
	}

	public void setStructureName(String structureName) {
		this.structureName = structureName;
	}

	public Integer getLayers() {
		return layers;
	}

	public void setLayers(Integer layers) {
		this.layers = layers;
	}

	public Date getBidOpenDate() {
		return bidOpenDate;
	}

	public void setBidOpenDate(Date bidOpenDate) {
		this.bidOpenDate = bidOpenDate;
	}

	public String getBidOpenPlace() {
		return bidOpenPlace;
	}

	public void setBidOpenPlace(String bidOpenPlace) {
		this.bidOpenPlace = bidOpenPlace;
	}

	public BigDecimal getProjectTotalMny() {
		return projectTotalMny;
	}

	public void setProjectTotalMny(BigDecimal projectTotalMny) {
		this.projectTotalMny = projectTotalMny;
	}

	public Long getTenderModeId() {
		return tenderModeId;
	}

	public void setTenderModeId(Long tenderModeId) {
		this.tenderModeId = tenderModeId;
	}

	public String getTenderModeCode() {
		return tenderModeCode;
	}

	public void setTenderModeCode(String tenderModeCode) {
		this.tenderModeCode = tenderModeCode;
	}

	public String getTenderModeName() {
		return tenderModeName;
	}

	public void setTenderModeName(String tenderModeName) {
		this.tenderModeName = tenderModeName;
	}

	public String getEvaluationMethod() {
		return evaluationMethod;
	}

	public void setEvaluationMethod(String evaluationMethod) {
		this.evaluationMethod = evaluationMethod;
	}

	public Long getProjectTypeId() {
		return projectTypeId;
	}

	public void setProjectTypeId(Long projectTypeId) {
		this.projectTypeId = projectTypeId;
	}

	public String getProjectTypeCode() {
		return projectTypeCode;
	}

	public void setProjectTypeCode(String projectTypeCode) {
		this.projectTypeCode = projectTypeCode;
	}

	public String getProjectTypeName() {
		return projectTypeName;
	}

	public void setProjectTypeName(String projectTypeName) {
		this.projectTypeName = projectTypeName;
	}

	public Long getQuoteModeId() {
		return quoteModeId;
	}

	public void setQuoteModeId(Long quoteModeId) {
		this.quoteModeId = quoteModeId;
	}

	public String getQuoteModeCode() {
		return quoteModeCode;
	}

	public void setQuoteModeCode(String quoteModeCode) {
		this.quoteModeCode = quoteModeCode;
	}

	public String getQuoteModeName() {
		return quoteModeName;
	}

	public void setQuoteModeName(String quoteModeName) {
		this.quoteModeName = quoteModeName;
	}

	public Long getSourceBidTenderId() {
		return sourceBidTenderId;
	}

	public void setSourceBidTenderId(Long sourceBidTenderId) {
		this.sourceBidTenderId = sourceBidTenderId;
	}

	public BigDecimal getInterceptTenderMny() {
		return interceptTenderMny;
	}

	public void setInterceptTenderMny(BigDecimal interceptTenderMny) {
		this.interceptTenderMny = interceptTenderMny;
	}

	public BigDecimal getBidBond() {
		return bidBond;
	}

	public void setBidBond(BigDecimal bidBond) {
		this.bidBond = bidBond;
	}

	public BigDecimal getPerformanceBond() {
		return performanceBond;
	}

	public void setPerformanceBond(BigDecimal performanceBond) {
		this.performanceBond = performanceBond;
	}

	public String getProjectContentId() {
		return projectContentId;
	}

	public void setProjectContentId(String projectContentId) {
		this.projectContentId = projectContentId;
	}

	public String getProjectContentCode() {
		return projectContentCode;
	}

	public void setProjectContentCode(String projectContentCode) {
		this.projectContentCode = projectContentCode;
	}

	public String getProjectContentName() {
		return projectContentName;
	}

	public void setProjectContentName(String projectContentName) {
		this.projectContentName = projectContentName;
	}

	public String getPrepaymentAndPaymentMode() {
		return prepaymentAndPaymentMode;
	}

	public void setPrepaymentAndPaymentMode(String prepaymentAndPaymentMode) {
		this.prepaymentAndPaymentMode = prepaymentAndPaymentMode;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public List<RecordFundEntity> getRecordFundList() {
		return recordFundList;
	}

	public void setRecordFundList(List<RecordFundEntity> recordFundList) {
		this.recordFundList = recordFundList;
	}

	public List<RecordRequirementEntity> getRecordRequirementList() {
		return recordRequirementList;
	}

	public void setRecordRequirementList(List<RecordRequirementEntity> recordRequirementList) {
		this.recordRequirementList = recordRequirementList;
	}

	public List<RecordStaffEntity> getRecordStaffList() {
		return recordStaffList;
	}

	public void setRecordStaffList(List<RecordStaffEntity> recordStaffList) {
		this.recordStaffList = recordStaffList;
	}
}
