/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pay.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pay.bean.PayEntity;
import com.ejianc.business.pay.enums.PayEnum;
import com.ejianc.business.pay.service.IPayService;
import com.ejianc.business.pay.vo.PayVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"pay"})
public class PayController
implements Serializable {
    private static final long serialVersionUID = 1868296764004829202L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RULE_CODE = "PROBID_PAY";
    private static final String BILL_CODE = "EJCBT202207000018";
    private final IBillTypeApi billTypeApi;
    private final IBillCodeApi billCodeApi;
    private final IOrgApi iOrgApi;
    private final IPayService service;
    private final SessionManager sessionManager;

    public PayController(IBillTypeApi billTypeApi, IBillCodeApi billCodeApi, IOrgApi iOrgApi, IPayService service, SessionManager sessionManager) {
        this.billTypeApi = billTypeApi;
        this.billCodeApi = billCodeApi;
        this.iOrgApi = iOrgApi;
        this.service = service;
        this.sessionManager = sessionManager;
    }

    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<PayVO> saveOrUpdate(@RequestBody PayVO saveOrUpdateVO) {
        PayEntity entity = (PayEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PayEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setBillName("\u4fdd\u8bc1\u91d1\u7f34\u7eb3");
        entity.setBillType(BILL_CODE);
        entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());
        entity.setBondModeName(PayEnum.getEnumByCode((String)entity.getBondMode()).getDesc());
        this.service.saveOrUpdate((Object)entity, false);
        PayVO vo = (PayVO)BeanMapper.map((Object)((Object)entity), PayVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<PayVO> queryDetail(Long id) {
        PayEntity entity = (PayEntity)((Object)this.service.selectById(id));
        PayVO vo = (PayVO)BeanMapper.map((Object)((Object)entity), PayVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<PayVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PayVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryList"})
    public CommonResponse<IPage<PayVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("bidUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("bid_unit_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("bidUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("bid_unit_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        ArrayList pays = new ArrayList();
        page.getRecords().forEach(e -> {
            PayVO pay = (PayVO)BeanMapper.map((Object)e, PayVO.class);
            pay.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)pay.getBillState()).getDescription());
            pays.add(pay);
        });
        HashMap beans = new HashMap();
        beans.put("records", pays);
        ExcelExport.getInstance().export("pay-export.xlsx", beans, response);
    }

    @GetMapping(value={"/refPayData"})
    public CommonResponse<IPage<PayVO>> refPayData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("bid_unit_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getParams().put("bond_mode", new Parameter("eq", (Object)PayEnum.CASH.getCode()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/queryDetailByProjectId"})
    public CommonResponse<PayVO> queryDetailByProjectId(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetailByProjectId(projectId));
    }
}

