package com.ejianc.business.calc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.calc.bean.CalcEntity;
import com.ejianc.business.calc.mapper.CalcMapper;
import com.ejianc.business.calc.service.ICalcService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

/**
 * 标前测算实体
 *
 * @author generator
 */
@Service("calcService")
public class CalcServiceImpl extends BaseServiceImpl<CalcMapper, CalcEntity> implements ICalcService {

	/**
	 * 只能有一个未生效的单据
	 *
	 * @param projectId 项目id
	 */
	@Override
	public void checkOnlyOne(Long projectId) {
		QueryWrapper<CalcEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("project_id", projectId);
		queryWrapper.notIn("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
		List<CalcEntity> entities = super.list(queryWrapper);
		if (CollectionUtils.isNotEmpty(entities)) {
			throw new BusinessException("当前项目已存在未生效的单据！");
		}
	}

}
