/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.api.StatisticVO;
import com.ejianc.business.bid.service.IBusinessService;
import com.ejianc.business.bid.service.IProjectService;
import com.ejianc.business.record.service.IRecordService;
import com.ejianc.business.review.service.IReviewService;
import com.ejianc.business.utils.DateUtil;
import com.ejianc.business.win.enums.WinEnum;
import com.ejianc.business.win.service.IWinService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"statistic"})
public class StatisticController
implements Serializable {
    private static final long serialVersionUID = 7896623284090719460L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IOrgApi iOrgApi;
    private final SessionManager sessionManager;
    private final IBusinessService businessService;
    private final IProjectService projectService;
    private final IRecordService recordService;
    private final IReviewService reviewService;
    private final IWinService winService;

    public StatisticController(IOrgApi iOrgApi, SessionManager sessionManager, IBusinessService businessService, IProjectService projectService, IRecordService recordService, IReviewService reviewService, IWinService winService) {
        this.iOrgApi = iOrgApi;
        this.sessionManager = sessionManager;
        this.businessService = businessService;
        this.projectService = projectService;
        this.recordService = recordService;
        this.reviewService = reviewService;
        this.winService = winService;
    }

    @GetMapping(value={"/getProBidState"})
    public CommonResponse<List<StatisticVO>> getProBidState(@RequestParam(value="timeFlag") String timeFlag) {
        ArrayList<StatisticVO> arr = new ArrayList<StatisticVO>();
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper business = new QueryWrapper();
        business.in((Object)"bid_unit_id", orgIds);
        business.eq("thisYear".equals(timeFlag), (Object)"YEAR(create_time)", (Object)DateUtil.getToYear());
        QueryWrapper project = new QueryWrapper();
        project.in((Object)"bid_unit_id", orgIds);
        project.eq("thisYear".equals(timeFlag), (Object)"YEAR(create_time)", (Object)DateUtil.getToYear());
        QueryWrapper record = new QueryWrapper();
        record.in((Object)"bid_unit_id", orgIds);
        record.eq("thisYear".equals(timeFlag), (Object)"YEAR(create_time)", (Object)DateUtil.getToYear());
        QueryWrapper review = new QueryWrapper();
        review.in((Object)"bid_unit_id", orgIds);
        review.eq("thisYear".equals(timeFlag), (Object)"YEAR(create_time)", (Object)DateUtil.getToYear());
        QueryWrapper win = new QueryWrapper();
        win.in((Object)"bid_unit_id", orgIds);
        win.eq("thisYear".equals(timeFlag), (Object)"YEAR(create_time)", (Object)DateUtil.getToYear());
        win.eq((Object)"bid_win_flag", (Object)WinEnum.YES.getCode());
        arr.add(new StatisticVO("\u5546\u673a\u767b\u8bb0", Integer.valueOf(this.businessService.count((Wrapper)business))));
        arr.add(new StatisticVO("\u6295\u6807\u2f74\u9879", Integer.valueOf(this.projectService.count((Wrapper)project))));
        arr.add(new StatisticVO("\u6295\u6807\u5907\u6848", Integer.valueOf(this.recordService.count((Wrapper)record))));
        arr.add(new StatisticVO("\u6295\u6807\u8bc4\u5ba1", Integer.valueOf(this.reviewService.count((Wrapper)review))));
        arr.add(new StatisticVO("\u4e2d\u6807", Integer.valueOf(this.winService.count((Wrapper)win))));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", arr);
    }

    @GetMapping(value={"/getProBidSurvey"})
    public CommonResponse<List<StatisticVO>> getProBidSurvey(@RequestParam(value="timeFlag") String timeFlag) {
        ArrayList<StatisticVO> arr = new ArrayList<StatisticVO>();
        LocalDate localDate = LocalDate.now();
        LocalDate weekDate = localDate.plus(7L, ChronoUnit.DAYS);
        LocalDate monthDate = localDate.plus(30L, ChronoUnit.DAYS);
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse childrenByParentId = this.iOrgApi.findChildrenByParentId(orgId);
        if (!childrenByParentId.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)childrenByParentId.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        QueryWrapper queryMonth = new QueryWrapper();
        queryMonth.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryMonth.in((Object)"bid_unit_id", (Collection)((List)childrenByParentId.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        queryMonth.ge((Object)"bid_open_date", (Object)localDate);
        queryMonth.le((Object)"bid_open_date", (Object)monthDate);
        int month = this.projectService.count((Wrapper)queryMonth);
        QueryWrapper queryWeek = new QueryWrapper();
        queryWeek.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWeek.in((Object)"bid_unit_id", (Collection)((List)childrenByParentId.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        queryWeek.ge((Object)"bid_open_date", (Object)localDate);
        queryWeek.le((Object)"bid_open_date", (Object)weekDate);
        int week = this.projectService.count((Wrapper)queryWeek);
        arr.add(new StatisticVO("\u8fd130\u5929\u9884\u8ba1\u5f00\u6807\u6570", Integer.valueOf(month)));
        arr.add(new StatisticVO("\u8fd17\u5929\u9884\u8ba1\u5f00\u6807\u6570", Integer.valueOf(week)));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", arr);
    }
}

