/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pay.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bid.bean.ProjectEntity;
import com.ejianc.business.bid.enums.EffectFlagEnum;
import com.ejianc.business.bid.service.IProjectService;
import com.ejianc.business.bid.utils.MybatisPlusColumnResolver;
import com.ejianc.business.pay.bean.PayEntity;
import com.ejianc.business.pay.service.IPayService;
import com.ejianc.business.process.bean.ProcessEntity;
import com.ejianc.business.process.service.IProcessService;
import com.ejianc.business.review.bean.ReviewEntity;
import com.ejianc.business.review.service.IReviewService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pay")
public class PayBpmServiceImpl
implements ICommonBusinessService {
    private final IPayService service;
    private final IProjectService projectService;
    private final IProcessService processService;
    private final IReviewService reviewService;
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final MybatisPlusColumnResolver mybatisPlusColumnResolver;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public PayBpmServiceImpl(IPayService service, IProjectService projectService, IProcessService processService, IReviewService reviewService, SessionManager sessionManager, IBillTypeApi billTypeApi, MybatisPlusColumnResolver mybatisPlusColumnResolver) {
        this.service = service;
        this.projectService = projectService;
        this.processService = processService;
        this.reviewService = reviewService;
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
        this.mybatisPlusColumnResolver = mybatisPlusColumnResolver;
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        PayEntity entity = (PayEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        ProjectEntity projectEntity = (ProjectEntity)((Object)this.projectService.selectById(entity.getProjectId()));
        if (projectEntity != null && projectEntity.getPayFlag().equals(EffectFlagEnum.INVALID.getCode())) {
            MybatisPlusColumnResolver.ColumnResolver columnResolver = this.mybatisPlusColumnResolver.create();
            this.projectService.updateEffectFlag(entity.getProjectId(), columnResolver.columnToString(ProjectEntity::getPayFlag), EffectFlagEnum.EFFECT.getCode());
        }
        this.saveProcess(entity, "\u4fdd\u8bc1\u91d1\u7f34\u7eb3", "pay/card");
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--end");
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        PayEntity entity = (PayEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ReviewEntity::getProjectId, (Object)entity.getProjectId());
        List entityList = this.reviewService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u6295\u6807\u6587\u4ef6\u8bc4\u5ba1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de/\u5f03\u5ba1\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5\uff1a{}\uff0c----{}", (Object)res.isSuccess(), (Object)res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de/\u5f03\u5ba1\uff01");
        }
        if (CollectionUtils.isNotEmpty(entity.getPayBackRecordList())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u6709\u98ce\u9669\u91d1\u9000\u8fd8\u8bb0\u5f55\uff0c\u4e0d\u80fd\u64a4\u56de/\u5f03\u5ba1\uff01");
        }
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.in(PayEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        qw.eq(PayEntity::getProjectId, (Object)entity.getProjectId());
        qw.ne(BaseEntity::getId, (Object)entity.getId());
        List pays = this.service.list((Wrapper)qw);
        if (CollectionUtils.isEmpty((Collection)pays)) {
            MybatisPlusColumnResolver.ColumnResolver columnResolver = this.mybatisPlusColumnResolver.create();
            this.projectService.updateEffectFlag(entity.getProjectId(), columnResolver.columnToString(ProjectEntity::getPayFlag), EffectFlagEnum.INVALID.getCode());
        }
        this.delProcess(entity.getId());
        return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de\u6210\u529f");
    }

    private void saveProcess(PayEntity entity, String billName, String frontendUrl) {
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(billName);
        processEntity.setProjectId(entity.getProjectId());
        processEntity.setProjectCode(entity.getProjectCode());
        processEntity.setProjectName(entity.getProjectName());
        processEntity.setFrontendUrl(frontendUrl);
        this.processService.saveOrUpdate((Object)processEntity);
    }

    private void delProcess(Long billId) {
        LambdaQueryWrapper l = new LambdaQueryWrapper();
        l.eq(ProcessEntity::getBillId, (Object)billId);
        this.processService.remove((Wrapper)l);
    }
}

