package com.ejianc.business.bid.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 投标立项
 *
 * @author generator
 *
 */
 @TableName("ejc_probid_bid_project")
public class ProjectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="business_id")
    private Long businessId; // 商机id
    @TableField(value="project_name")
    private String projectName; // 招标项目名称（带入）
    @TableField(value="construction_unit")
    private String constructionUnit; // 建设单位
    @TableField(value="unitNature_id")
    private Long unitnatureId; // 建设单位 性质
    @TableField(value="unitNature_name")
    private String unitnatureName; // 建设单位 性质(name)
    @TableField(value="unitNature_code")
    private String unitnatureCode; // 建设单位 性质(name)
    @TableField(value="bid_agency")
    private String bidAgency; // 招标代理机构
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="registration_deadline")
    private Date registrationDeadline; // 报名截止日期
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="bid_open_date")
    private Date bidOpenDate; // 开标日期
    @TableField(value="tender_mode_code")
    private String tenderModeCode; // 招标方式编码
    @TableField(value="tender_mode_id")
    private Long tenderModeId; // 招标方式
    @TableField(value="tender_mode_name")
    private String tenderModeName; // 招标方式名称
    @TableField(value="review_mode")
    private String reviewMode; // 评审方式
    @TableField(value="review_mode_name")
    private String reviewModeName; // 评审方式名称
    @TableField(value="project_init_type")
    private String projectInitType; // 立项类别 值域：0:自主经营、1:直接签订合同、2:其他


    @TableField(value="project_init_type_name")
    private String projectInitTypeName; // 立项类别 名称
    @TableField(value="detailed_address")
    private String detailedAddress; // 详细地址
    @TableField(value="area")
    private String area; // 区域
    @TableField(value="project_total_mny")
    private BigDecimal projectTotalMny; // 项目总投资
    @TableField(value="project_total_area")
    private BigDecimal projectTotalArea; // 项目总面积
    @TableField(value="project_manager_id")
    private Long projectManagerId; // 项目经理
    @TableField(value="project_manager_name")
    private String projectManagerName; // 项目经理 名称
    @TableField(value="project_duration")
    private Integer projectDuration; // 工程工期
    @TableField(value="project_type_id")
    private Long projectTypeId; // 项目类型
    @TableField(value="project_type_code")
    private String projectTypeCode; // 项目类型编码
    @TableField(value="project_type_name")
    private String projectTypeName; // 项目类型名称
    @TableField(value="bid_unit_id")
    private Long bidUnitId; // 投标单位
    @TableField(value="bid_unit_name")
    private String bidUnitName; // 投标单位 名称
    @TableField(value="bid_unit_code")
    private String bidUnitCode; // 投标单位 编码
    @TableField(value="apply_user_id")
    private Long applyUserId; // 投标申请人
    @TableField(value="apply_user_name")
    private String applyUserName; // 投标申请人 名称
    @TableField(value="apply_user_code")
    private String applyUserCode; // 投标申请人 编码
    @TableField(value="apply_user_phone")
    private String applyUserPhone; // 申请人联系方式
    @TableField(value="entrust_information_id")
    private String entrustInformationId; // 申请人委托资料
    @TableField(value="entrust_information_name")
    private String entrustInformationName; // 申请人委托资料
    @TableField(value="bid_stage")
    private String bidStage; // 投标阶段
    @TableField(value="bid_status")
    private String bidStatus; // 投标状态  0投标中、1中标、2未中标、3已中止、4预审不通过。
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="commit_data")
    private Date commitData; // 提交日期
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名字
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="regist_data_flag")
    private Integer registDataFlag;//是否存在报名资料 "1" 存在 “0” 不存在
    @TableField(value="prequalification_flag")
    private Integer prequalificationFlag;//是否存在资格预审  "1" 存在 “0” 不存在
    @TableField(value = "tender_flag")
    private Integer tenderFlag;// 标书购买是否生效 0-未生效，1-已生效
	@TableField(value = "record_flag")
	private Integer recordFlag;// 工程投标备案是否生效 0-未生效，1-已生效
	@TableField(value = "calc_flag")
	private Integer calcFlag;// 标签测算是否生效 0-未生效，1-已生效
	@TableField(value = "pay_flag")
	private Integer payFlag;// 风险保证金是否生效 0-未生效，1-已生效
	@TableField(value = "review_flag")
	private Integer reviewFlag;// 投标文件评审是否生效 0-未生效，1-已生效
	@TableField(value = "open_flag")
	private Integer openFlag;// 开标记录是否生效 0-未生效，1-已生效
	@TableField(value = "win_flag")
	private Integer winFlag;// 中标登记是否生效 0-未生效，1-已生效
    @TableField(value = "address_value")
    private String addressValue;//详细地址 记录value

    @TableField(value = "structure_id")
    private Long structureId; // 结构id
    @TableField(value = "structure_code")
    private String structureCode; // 结构编码
    @TableField(value = "structure_name")
    private String structureName; // 结构名称
    @TableField(value = "project_type")
    private String projectType; // 项目级别
    @TableField(value = "layers")
    private Integer layers; // 层数
    @TableField(value = "buildings")
    private Integer buildings; // 幢数
    @TableField(value="project_process")
    private String projectProcess; // 工程联系情况及进展

    public String getAddressValue() {
        return addressValue;
    }

    public void setAddressValue(String addressValue) {
        this.addressValue = addressValue;
    }

    public String getProjectTypeCode() {
        return projectTypeCode;
    }

    public void setProjectTypeCode(String projectTypeCode) {
        this.projectTypeCode = projectTypeCode;
    }

    public Integer getPrequalificationFlag() {
        return prequalificationFlag;
    }

    public void setPrequalificationFlag(Integer prequalificationFlag) {
        this.prequalificationFlag = prequalificationFlag;
    }

    public Integer getRegistDataFlag() {
        return registDataFlag;
    }

    public void setRegistDataFlag(Integer registDataFlag) {
        this.registDataFlag = registDataFlag;
    }

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getConstructionUnit() {
        return constructionUnit;
    }

    public void setConstructionUnit(String constructionUnit) {
        this.constructionUnit = constructionUnit;
    }
    public Long getUnitnatureId() {
        return unitnatureId;
    }

    public void setUnitnatureId(Long unitnatureId) {
        this.unitnatureId = unitnatureId;
    }
    public String getUnitnatureName() {
        return unitnatureName;
    }

    public void setUnitnatureName(String unitnatureName) {
        this.unitnatureName = unitnatureName;
    }
    public String getUnitnatureCode() {
        return unitnatureCode;
    }

    public void setUnitnatureCode(String unitnatureCode) {
        this.unitnatureCode = unitnatureCode;
    }
    public String getBidAgency() {
        return bidAgency;
    }

    public void setBidAgency(String bidAgency) {
        this.bidAgency = bidAgency;
    }
    public Date getRegistrationDeadline() {
        return registrationDeadline;
    }

    public void setRegistrationDeadline(Date registrationDeadline) {
        this.registrationDeadline = registrationDeadline;
    }
    public Date getBidOpenDate() {
        return bidOpenDate;
    }

    public void setBidOpenDate(Date bidOpenDate) {
        this.bidOpenDate = bidOpenDate;
    }

    public String getTenderModeCode() {
        return tenderModeCode;
    }

    public void setTenderModeCode(String tenderModeCode) {
        this.tenderModeCode = tenderModeCode;
    }

    public Long getTenderModeId() {
        return tenderModeId;
    }

    public void setTenderModeId(Long tenderModeId) {
        this.tenderModeId = tenderModeId;
    }

    public String getTenderModeName() {
        return tenderModeName;
    }

    public void setTenderModeName(String tenderModeName) {
        this.tenderModeName = tenderModeName;
    }

    public String getReviewMode() {
        return reviewMode;
    }

    public void setReviewMode(String reviewMode) {
        this.reviewMode = reviewMode;
    }
    public String getReviewModeName() {
        return reviewModeName;
    }

    public void setReviewModeName(String reviewModeName) {
        this.reviewModeName = reviewModeName;
    }
    public String getProjectInitType() {
        return projectInitType;
    }

    public void setProjectInitType(String projectInitType) {
        this.projectInitType = projectInitType;
    }
    public String getProjectInitTypeName() {
        return projectInitTypeName;
    }

    public void setProjectInitTypeName(String projectInitTypeName) {
        this.projectInitTypeName = projectInitTypeName;
    }
    public String getDetailedAddress() {
        return detailedAddress;
    }

    public void setDetailedAddress(String detailedAddress) {
        this.detailedAddress = detailedAddress;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public BigDecimal getProjectTotalMny() {
        return projectTotalMny;
    }

    public void setProjectTotalMny(BigDecimal projectTotalMny) {
        this.projectTotalMny = projectTotalMny;
    }
    public BigDecimal getProjectTotalArea() {
        return projectTotalArea;
    }

    public void setProjectTotalArea(BigDecimal projectTotalArea) {
        this.projectTotalArea = projectTotalArea;
    }
    public Long getProjectManagerId() {
        return projectManagerId;
    }

    public void setProjectManagerId(Long projectManagerId) {
        this.projectManagerId = projectManagerId;
    }
    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    public Integer getProjectDuration() {
        return projectDuration;
    }

    public void setProjectDuration(Integer projectDuration) {
        this.projectDuration = projectDuration;
    }
    public Long getProjectTypeId() {
        return projectTypeId;
    }

    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public Long getBidUnitId() {
        return bidUnitId;
    }

    public void setBidUnitId(Long bidUnitId) {
        this.bidUnitId = bidUnitId;
    }
    public String getBidUnitName() {
        return bidUnitName;
    }

    public void setBidUnitName(String bidUnitName) {
        this.bidUnitName = bidUnitName;
    }
    public String getBidUnitCode() {
        return bidUnitCode;
    }

    public void setBidUnitCode(String bidUnitCode) {
        this.bidUnitCode = bidUnitCode;
    }
    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }
    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    public String getApplyUserCode() {
        return applyUserCode;
    }

    public void setApplyUserCode(String applyUserCode) {
        this.applyUserCode = applyUserCode;
    }
    public String getApplyUserPhone() {
        return applyUserPhone;
    }

    public void setApplyUserPhone(String applyUserPhone) {
        this.applyUserPhone = applyUserPhone;
    }
    public String getEntrustInformationId() {
        return entrustInformationId;
    }

    public void setEntrustInformationId(String entrustInformationId) {
        this.entrustInformationId = entrustInformationId;
    }
    public String getEntrustInformationName() {
        return entrustInformationName;
    }

    public void setEntrustInformationName(String entrustInformationName) {
        this.entrustInformationName = entrustInformationName;
    }
    public String getBidStage() {
        return bidStage;
    }

    public void setBidStage(String bidStage) {
        this.bidStage = bidStage;
    }
    public String getBidStatus() {
        return bidStatus;
    }

    public void setBidStatus(String bidStatus) {
        this.bidStatus = bidStatus;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitData() {
        return commitData;
    }

    public void setCommitData(Date commitData) {
        this.commitData = commitData;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getTenderFlag() {
        return tenderFlag;
    }

    public void setTenderFlag(Integer tenderFlag) {
        this.tenderFlag = tenderFlag;
    }

    public Integer getRecordFlag() {
		return recordFlag;
	}

	public void setRecordFlag(Integer recordFlag) {
		this.recordFlag = recordFlag;
	}

	public Integer getCalcFlag() {
		return calcFlag;
	}

	public void setCalcFlag(Integer calcFlag) {
		this.calcFlag = calcFlag;
	}

	public Integer getPayFlag() {
		return payFlag;
	}

	public void setPayFlag(Integer payFlag) {
		this.payFlag = payFlag;
	}

	public Integer getReviewFlag() {
		return reviewFlag;
	}

	public void setReviewFlag(Integer reviewFlag) {
		this.reviewFlag = reviewFlag;
	}

	public Integer getOpenFlag() {
		return openFlag;
	}

	public void setOpenFlag(Integer openFlag) {
		this.openFlag = openFlag;
	}

	public Integer getWinFlag() {
		return winFlag;
	}

	public void setWinFlag(Integer winFlag) {
		this.winFlag = winFlag;
	}

    public Long getStructureId() {
        return structureId;
    }

    public void setStructureId(Long structureId) {
        this.structureId = structureId;
    }

    public String getStructureCode() {
        return structureCode;
    }

    public void setStructureCode(String structureCode) {
        this.structureCode = structureCode;
    }

    public String getStructureName() {
        return structureName;
    }

    public void setStructureName(String structureName) {
        this.structureName = structureName;
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public Integer getLayers() {
        return layers;
    }

    public void setLayers(Integer layers) {
        this.layers = layers;
    }

    public Integer getBuildings() {
        return buildings;
    }

    public void setBuildings(Integer buildings) {
        this.buildings = buildings;
    }

    public String getProjectProcess() {
        return projectProcess;
    }

    public void setProjectProcess(String projectProcess) {
        this.projectProcess = projectProcess;
    }
}
