package com.ejianc.business.calc.service;

import com.ejianc.business.calc.bean.CalcEntity;
import com.ejianc.business.calc.vo.CalcVO;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 标前测算实体
 *
 * @author generator
 */
public interface ICalcService extends IBaseService<CalcEntity> {

	/**
	 * 只能有一个未生效的单据
	 *
	 * @param projectId 项目id
	 */
	void checkOnlyOne(Long projectId);

	/**
	 * 根据投标立项项目id查询标签测算记录
	 *
	 * @param projectId 投标立项项目id
	 */
	CalcVO queryDetailByProjectId(Long projectId);
}
