package com.ejianc.business.budget.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.budget.vo.BudgetChangeRecordVO;
import com.ejianc.business.budget.vo.BudgetChangeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.budget.bean.BudgetChangeEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 预算变更
 *
 * @author generator
 *
 */
public interface IBudgetChangeService extends IBaseService<BudgetChangeEntity> {

    BudgetChangeVO insertOrUpdate(BudgetChangeVO changeVO);

    BudgetChangeVO addConvertByConId(Long budgetId);

    BudgetChangeVO queryDetail(Long id);

    CommonResponse<String> deleteByIds(List<BudgetChangeVO> vos);

    CommonResponse<IPage<BudgetChangeVO>> queryListVOs(QueryParam param);

    List<BudgetChangeRecordVO> queryDetailRecord(Long budgetId);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, String budgetChangeId, String budgetId);
}
