package com.ejianc.business.subPay.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.SubPayVo;
import com.ejianc.business.subPay.service.ISubPayService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * 劳务付款汇总表
 *
 * @author generator
 */
@Controller
@RequestMapping("subPay")
public class SubPayController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final static Integer QUERY_TIMEOUT = 60;

    private final static String INDEX_NAME_SUBPAY = "sub_pay";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISubPayService subPayService;

    @Autowired(required = false)
    private RestHighLevelClient client;



    @RequestMapping(value = "/querySubPayList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubPayVo>> querySubPayList(@RequestBody QueryParam param) {

        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        IPage<SubPayVo> page = new Page<>();
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        SearchRequest searchRequest = new SearchRequest(INDEX_NAME_SUBPAY);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));
        Map<String, Parameter> params = param.getParams();
        if (params != null && params.size() > 0) {
            //截止时间
            String endDate = getParamValue(params, "createTime");
            if(StringUtils.isNotBlank(endDate)){
                endDate = endDate + " 23:59:59";
                RangeQueryBuilder createTime = QueryBuilders.rangeQuery("createTime");
                params.remove("createTime");
                createTime.lte(endDate);
                boolQuery.must(createTime);
            }
            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isEmpty(value)) continue;
                boolQuery.must(QueryBuilders.matchQuery(key, value));
            }
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);
        sourceBuilder.sort(new FieldSortBuilder(new FieldSortBuilder("supplierId").order(SortOrder.ASC)));
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);

        List<SubPayVo> list = new ArrayList<>();
        SearchResponse response = null;
        try {
            response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject(sourceAsString, SubPayVo.class));
            }
            subPayService.setNewKeyRowSpan(list);

            page.setRecords(list);
            page.setTotal(hits.getTotalHits().value);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.success("查询劳务付款汇总列表数据成功！", page);
    }


    @RequestMapping(value = "excelExportSubPayList", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubPayList(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(10000);
        param.setPageIndex(1);
        CommonResponse<IPage<SubPayVo>> voPage = querySubPayList(param);
        List<SubPayVo> list = voPage.getData().getRecords();
        if (ListUtil.isNotEmpty(list)) {
            ServletOutputStream outputStream = response.getOutputStream();
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet();
            sheet.createFreezePane(0, 2, 0, 2);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 10));

            //首行标题
            XSSFRow row = sheet.createRow(0);
            CellStyle style = workbook.createCellStyle();
            style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
            style.setFillPattern(CellStyle.SOLID_FOREGROUND);
            style.setAlignment(CellStyle.ALIGN_CENTER);
            XSSFCell cell = row.createCell(0);
            cell.setCellValue("劳务付款汇总表");
            cell.setCellStyle(style);

            //第二行数据
            row = sheet.createRow(1);
            cell = row.createCell(0);
            cell.setCellValue("班组名称");
            cell.setCellStyle(style);
            cell = row.createCell(1);
            cell.setCellValue("项目");
            cell.setCellStyle(style);
            cell = row.createCell(2);
            cell.setCellValue("本次申请");
            cell.setCellStyle(style);
            cell = row.createCell(3);
            cell.setCellValue("本次申请合计");
            cell.setCellStyle(style);
            cell = row.createCell(4);
            cell.setCellValue("已付款比例（含本次）%");
            cell.setCellStyle(style);
            cell = row.createCell(5);
            cell.setCellValue("本次审批金额");
            cell.setCellStyle(style);
            for (int i = 0; i < 6; i++) {
                sheet.autoSizeColumn(i);
                sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 35 / 10);
            }
            for (int i = 0; i < list.size(); i++) {
                SubPayVo vo = list.get(i);
                row = sheet.createRow(i + 2);
                if(vo.getNewKeyRowSpan()>0){
                    cell = row.createCell(0);
                    cell.setCellValue(vo.getSupplierName()==null?"":vo.getSupplierName().toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.getNewKeyRowSpan()) - 1, 0, 0));
                    cell = row.createCell(3);
                    cell.setCellValue(vo.getApplyTotal()==null?"":vo.getApplyTotal().toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.getNewKeyRowSpan()) - 1, 3, 3));
                    cell = row.createCell(4);
                    cell.setCellValue(vo.getYifukuanbili()==null?"":vo.getYifukuanbili().toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + ((int) vo.getNewKeyRowSpan()) - 1, 4, 4));

                }
                cell = row.createCell(1);
                cell.setCellValue(vo.getProjectName()==null?"":vo.getProjectName().toString());
                cell = row.createCell(2);
                cell.setCellValue(vo.getApply()==null?"":vo.getApply().toString());
                cell = row.createCell(5);
                cell.setCellValue(vo.getApprovedAmount()==null?"":vo.getApprovedAmount().toString());
            }
            workbook.write(outputStream);
        }
    }



    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }

}
