package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.plan.bean.BudgetPlanChangeEntity;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemChangeEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.consts.ChangeStatusConst;
import com.ejianc.business.plan.consts.NumberConsts;
import com.ejianc.business.plan.service.IBudgetPlanChangeService;
import com.ejianc.business.plan.service.IBudgetPlanItemChangeService;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.business.plan.vo.BudgetDetailTemVO;
import com.ejianc.business.plan.vo.BudgetPlanChangeVO;
import com.ejianc.business.plan.vo.BudgetPlanItemTemVO;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 施工计划变更
 *
 * @author generator
 */
@Controller
@RequestMapping("budgetPlanChange")
public class BudgetPlanChangeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PROBUDGET_PLAN_CHANGE";

    @Autowired
    private IBudgetPlanChangeService service;

    @Autowired
    private IBudgetPlanService budgetPlanService;

    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;

    @Autowired
    private IBudgetPlanItemChangeService budgetPlanItemChangeService;

    /***
     * @description: 新增 引入预算数据
     * @param planVO
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.plan.vo.BudgetPlanVO>
     * @author songlx
     * @date: 2021/9/7
     */
    @RequestMapping(value = "/loadBudget", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetTemVO> loadBudget(@RequestBody BudgetPlanChangeVO planVO) {
        CommonResponse<BudgetTemVO> budgetByProjectId = budgetPlanService.getBudgetById(planVO.getBudgetId());
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error(budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = budgetByProjectId.getData();
        List<String> months = DateUtil.getMonthBetween(planVO.getStartMonth(), planVO.getEndMonth());
        vo.setMonthColumn(months);
        vo.setDetailList(TreeNodeBUtil.buildTree(vo.getDetailList()));
        return CommonResponse.success("查询项目预算成功！", vo);
    }

    /***
     * @description: 获取原计划
     *
     * @param id  原计划id
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.plan.vo.BudgetPlanChangeVO>
     * @author songlx
     * @date: 2021/9/9
     */
    @RequestMapping(value = "/getBudgetPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetPlanChangeVO> getBudgetPlan(Long id) {
        BudgetPlanEntity entity = budgetPlanService.selectById(id);
        BudgetPlanChangeVO planChangeVO = BeanMapper.map(entity, BudgetPlanChangeVO.class);
        Long projectId = entity.getProjectId();
        CommonResponse<BudgetTemVO> budgetByProjectId = budgetPlanService.getBudgetVOByProjectId(projectId);
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error(budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = budgetByProjectId.getData();
        List<String> months = DateUtil.getMonthBetween(entity.getStartMonth(), entity.getEndMonth());
        planChangeVO.setMonthColumn(months);
        List<BudgetDetailTemVO> detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            List<Long> detailIds = detailList.stream().map(BudgetDetailTemVO::getId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("plan_id", new Parameter(QueryParam.EQ, id));
            param.getParams().put("detail_id", new Parameter(QueryParam.IN, detailIds));
            List<BudgetPlanItemEntity> planItemEntities = budgetPlanItemService.queryList(param);

            List<BudgetPlanItemTemVO> itemTemVOS = BeanMapper.mapList(planItemEntities, BudgetPlanItemTemVO.class);
            Map<Long, List<BudgetPlanItemTemVO>> listMap = itemTemVOS.stream().collect(Collectors.groupingBy(BudgetPlanItemTemVO::getDetailId));
            detailList.forEach(t -> t.setItemList(listMap.get(t.getId())));
            planChangeVO.setDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        planChangeVO.setId(null);
        planChangeVO.setChangeId(id);
        planChangeVO.setBillState(null);
        planChangeVO.setVersion(null);
        return CommonResponse.success("查询详情数据成功！", planChangeVO);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetPlanChangeVO> saveOrUpdate(@RequestBody BudgetPlanChangeVO saveorUpdateVO) {
        BudgetPlanChangeEntity entity = BeanMapper.map(saveorUpdateVO, BudgetPlanChangeEntity.class);
        List<BudgetDetailTemVO> detailList = saveorUpdateVO.getDetailList();
        List<BudgetPlanItemChangeEntity> itemList = new ArrayList<>();

        for (BudgetDetailTemVO v : detailList) {
            List<BudgetPlanItemTemVO> vItemList = v.getItemList();
            if (CollectionUtils.isNotEmpty(vItemList)) {
                List<BudgetPlanItemChangeEntity> budgetPlanItemEntities = BeanMapper.mapList(vItemList, BudgetPlanItemChangeEntity.class);
                itemList.addAll(budgetPlanItemEntities);
            }
        }

        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        service.saveOrUpdate(entity, false);
        if (CollectionUtils.isNotEmpty(itemList)) {
            QueryParam param = new QueryParam();
            param.getParams().put("plan_id", new Parameter(QueryParam.EQ, entity.getId()));
            List<BudgetPlanItemChangeEntity> oldItems = budgetPlanItemChangeService.queryList(param);
            if (CollectionUtils.isNotEmpty(oldItems)) {
                Map<String, BudgetPlanItemChangeEntity> oldMap = oldItems.stream().collect(Collectors.toMap(k -> k.getDetailId() + k.getYyearMonth(), (k) -> k));
                itemList.forEach(t -> {
                            Long detailId = t.getDetailId();
                            t.setPlanId(entity.getId());
                            BudgetPlanItemChangeEntity oldVO = oldMap.get(detailId + t.getYyearMonth());
                            if (null != oldVO) {
                                t.setId(oldVO.getId());
                                t.setVersion(oldVO.getVersion());
                                t.setCreateTime(oldVO.getCreateTime());
                                t.setCreateUserCode(oldVO.getCreateUserCode());
                                oldMap.remove(detailId + t.getYyearMonth());
                            }

                        }
                );
                if (MapUtils.isNotEmpty(oldMap)) {
                    List<Long> ids = oldMap.values().stream().map(BudgetPlanItemChangeEntity::getId).collect(Collectors.toList());
                    budgetPlanItemChangeService.removeByIds(ids);
                }
            } else {
                itemList.forEach(t -> t.setPlanId(entity.getId()));
            }

            QueryParam planParam = new QueryParam();
            planParam.getParams().put("budget_id", new Parameter(QueryParam.EQ, entity.getBudgetId()));
            planParam.getParams().put("project_id", new Parameter(QueryParam.EQ, entity.getProjectId()));
            List<BudgetPlanEntity> budgetPlanEntities = budgetPlanService.queryList(planParam);
            BudgetPlanEntity budgetPlanEntity = budgetPlanEntities.get(0);
            String endMonth = budgetPlanEntity.getEndMonth();
            String thisMonth = DateUtil.getCurrentDay(DateUtil.MONTH);

            QueryParam planItemParam = new QueryParam();
            planItemParam.getParams().put("plan_id", new Parameter(QueryParam.EQ, budgetPlanEntity.getId()));
            planItemParam.getParams().put("yyear_month", new Parameter(QueryParam.EQ, endMonth));
            List<BudgetPlanItemEntity> entityList = budgetPlanItemService.queryList(planItemParam);

            Map<Long,BudgetPlanItemEntity> planItemMap = new HashMap<>();
            entityList.forEach(item->{
                planItemMap.put(item.getDetailId(),item);
            });
            itemList.forEach(item->{
                if(item.getYyearMonth().compareTo(endMonth) > 0  && item.getYyearMonth().compareTo(thisMonth) <= 0){
                    BigDecimal finishNum = (planItemMap.get(item.getDetailId()) != null && planItemMap.get(item.getDetailId()).getFinishNum() != null ? planItemMap.get(item.getDetailId()).getFinishNum() : BigDecimal.ZERO);
                    BigDecimal finishRatio = (planItemMap.get(item.getDetailId()) != null && planItemMap.get(item.getDetailId()).getFinishRatio() != null ? planItemMap.get(item.getDetailId()).getFinishRatio() : BigDecimal.ZERO);
                    item.setFinishNum(finishNum);
                    item.setFinishRatio(finishRatio);
                }
            });
            budgetPlanItemChangeService.saveOrUpdateBatch(itemList);
        }
        LambdaUpdateWrapper<BudgetPlanEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BudgetPlanEntity::getId, entity.getChangeId());
        updateWrapper.set(BudgetPlanEntity::getChangeStatus, ChangeStatusConst.CHANGING);
        updateWrapper.set(BudgetPlanEntity::getChangeId, entity.getId());
        updateWrapper.set(BudgetPlanEntity::getChangeCode, entity.getBillCode());
        budgetPlanService.update(updateWrapper);

        return this.queryDetail(entity.getId());
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetPlanChangeVO> queryDetail(Long id) {
        BudgetPlanChangeEntity entity = service.selectById(id);
        BudgetPlanChangeVO planVO = BeanMapper.map(entity, BudgetPlanChangeVO.class);
        CommonResponse<BudgetTemVO> budgetByProjectId = budgetPlanService.getBudgetById(entity.getBudgetId());
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error(budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = budgetByProjectId.getData();
        List<String> months = DateUtil.getMonthBetween(entity.getStartMonth(), entity.getEndMonth());
        planVO.setMonthColumn(months);
        List<BudgetDetailTemVO> detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            List<Long> detailIds = detailList.stream().map(BudgetDetailTemVO::getId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("plan_id", new Parameter(QueryParam.EQ, id));
            param.getParams().put("detail_id", new Parameter(QueryParam.IN, detailIds));
            List<BudgetPlanItemChangeEntity> planItemEntities = budgetPlanItemChangeService.queryList(param);

            List<BudgetPlanItemTemVO> itemTemVOS = BeanMapper.mapList(planItemEntities, BudgetPlanItemTemVO.class);
            Map<Long, List<BudgetPlanItemTemVO>> listMap = itemTemVOS.stream().collect(Collectors.groupingBy(BudgetPlanItemTemVO::getDetailId));
            detailList.forEach(t -> t.setItemList(listMap.get(t.getId())));
            planVO.setDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        return CommonResponse.success("查询详情数据成功！", planVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetPlanChangeVO> vos) {
        List<Long> changeIds = vos.stream().map(BudgetPlanChangeVO::getId).collect(Collectors.toList());
        QueryWrapper<BudgetPlanChangeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("id", changeIds);
        List<BudgetPlanChangeEntity> list = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> ids = list.stream().map(BudgetPlanChangeEntity::getChangeId).collect(Collectors.toList());
            LambdaUpdateWrapper<BudgetPlanEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(BudgetPlanEntity::getId, ids);
            updateWrapper.set(BudgetPlanEntity::getChangeStatus, ChangeStatusConst.UN_CHANGE);
            updateWrapper.set(BudgetPlanEntity::getChangeId, null);
            updateWrapper.set(BudgetPlanEntity::getChangeCode, null);
            budgetPlanService.update(updateWrapper);
        }
        service.removeByIds(vos.stream().map(BudgetPlanChangeVO::getId).collect(Collectors.toList()), true);

        QueryWrapper<BudgetPlanItemChangeEntity> rapper = new QueryWrapper<>();
        rapper.in("plan_id", changeIds);
        budgetPlanItemChangeService.remove(rapper);


        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetPlanChangeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<BudgetPlanChangeEntity> page = service.queryPage(param, false);
        IPage<BudgetPlanChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetPlanChangeVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BudgetPlanChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetPlanChange-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBudgetPlanChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetPlanChangeVO>> refBudgetPlanChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BudgetPlanChangeEntity> page = service.queryPage(param, false);
        IPage<BudgetPlanChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetPlanChangeVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
