package com.ejianc.business.plan.controller;

import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.Calendar;
import java.util.Date;


@RestController
@RequestMapping(value = "/warn")
public class WarnController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBudgetPlanService service;


    /**
     * @param projectId 项目id
     * @description: 重算某个项目计划数据
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.plan.vo.RecalculateVO>
     * @author songlx
     * @date: 2021/12/8
     */
    @RequestMapping(value = "/rec3", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RecalculateVO> rec3(Long projectId) {
        RecalculateVO vo = new RecalculateVO(projectId, null);
        return service.recalculate(vo, 3);
    }

    /**
     * @param
     * @Description calData 按照日期更新施工计划数据
     */
    @RequestMapping(value = "/calData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> calData(HttpServletRequest request) {
        logger.info("接收到施工计划Task参数：{}", request);

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        // 今天多少号
        int getDay = calendar.get(Calendar.DAY_OF_MONTH);
        // 昨天多少号
        calendar.set(Calendar.DATE, getDay - 1);
        int oldDat = calendar.get(Calendar.DAY_OF_MONTH);
        // 昨天的月底
        int maxDay = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
        if (oldDat == maxDay) {
            CommonResponse commonResponse = service.updateDataByDay("31");
            CommonResponse commonResponse1 = service.updateDataByDay(String.valueOf(oldDat));
            if (!commonResponse.isSuccess() || !commonResponse1.isSuccess()) {
                return CommonResponse.error("接口执行失败，请检查日志！");
            }
            return commonResponse;
        } else {
            CommonResponse commonResponse = service.updateDataByDay(String.valueOf(getDay - 1));
            if (!commonResponse.isSuccess()) {
                return CommonResponse.error("接口执行失败，请检查日志！");
            }
            return commonResponse;
        }
    }
}
