package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.budget.bean.BudgetChangeEntity;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.bean.BudgetRecordEntity;
import com.ejianc.business.budget.service.IBudgetChangeService;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetRecordService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.enums.ChangeStatusEnum;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("budgetChange")
public class BudgetChangeBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBudgetChangeService budgetChangeService;

	@Autowired
	private IBudgetService budgetService;

	@Autowired
	private IBudgetDetailService budgetDetailService;

	@Autowired
	private IBudgetRecordService recordService;

	@Autowired
	private IBudgetPlanService service;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
/**更新变更的审批时间  begin */

		BudgetChangeThread myThread = new BudgetChangeThread();
		myThread.setBillId(billId);
		myThread.setLogger(logger);
		myThread.setBudgetChangeService(budgetChangeService);
		myThread.setBudgetService(budgetService);
		myThread.setService(service);
		myThread.setBudgetDetailService(budgetDetailService);
		myThread.setRecordService(recordService);
		Thread thread = new Thread(myThread);
		thread.start();
		return CommonResponse.success();
	}
	/**
	 * 生成内码
	 *
	 * @param list
	 * @param innerCode
	 * @return
	 */
	private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
		for (int i = 0; i < list.size(); i++) {
			Map<String, Object> ypd = list.get(i);
			// 生成内码
			if (StringUtils.isNotEmpty(innerCode)) {
				ypd.put("innerCode", innerCode + "&&" + ypd.get("id"));
			} else {
				ypd.put("innerCode", ypd.get("id"));
			}

			if (ypd.get("children") != null) {
				List<Map<String, Object>> child = creatInnerCode((List) ypd.get("children"),  ypd.get("innerCode").toString());
				ypd.put("children", child);
				ypd.put("leafFlag", false);
			}else {
				ypd.put("leafFlag", true);
			}
		}
		return list;
	}

	private void treeToList(List<Map<String, Object>> list, List<BudgetDetailEntity> entities){
		for (Map<String, Object> ypd : list) {
			if (ypd.get("children") != null) {
				treeToList((List) ypd.get("children"), entities);
			}
			entities.add(BeanMapper.map(ypd, BudgetDetailEntity.class));
		}
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("预算变更单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
