package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.vo.BudgetDetailVO;
import com.ejianc.business.enums.ChangeTypeEnum;
import com.ejianc.business.material.api.IMaterialInstoreApi;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.UseApplyFinishVO;
import com.ejianc.business.plan.bean.BudgetInfoEntity;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.consts.NumberConsts;
import com.ejianc.business.plan.mapper.BudgetPlanMapper;
import com.ejianc.business.plan.service.IBudgetInfoService;
import com.ejianc.business.plan.service.IBudgetPlanItemChangeService;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.business.plan.vo.BudgetDetailTemVO;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工计划
 *
 * @author generator
 */
@Service("budgetPlanService")
public class BudgetPlanServiceImpl extends BaseServiceImpl<BudgetPlanMapper, BudgetPlanEntity> implements IBudgetPlanService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBudgetService budgetService;

    @Autowired
    private IBudgetDetailService budgetDetailService;

    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;

    @Autowired
    private IBudgetInfoService budgetInfoService;

    @Autowired
    private IBudgetPlanItemChangeService budgetPlanItemChangeService;

    @Autowired
    private BudgetPlanMapper budgetPlanMapper;

    @Autowired
    IMaterialInstoreApi materialInstoreApi;

    @Override
    public CommonResponse<BudgetTemVO> getBudgetVOByProjectId(Long projectId) {
        QueryWrapper<BudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<BudgetEntity> list = budgetService.list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return CommonResponse.error("未查询到生效的项目预算！");
        }
        BudgetEntity budgetEntity = list.get(0);
        /*QueryWrapper<BudgetDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("budget_id", budgetEntity.getId());
        //只需要展示123级
        wrapper.in("level_no", Arrays.asList(1, 2, 3));
        wrapper.ne("change_type", ChangeTypeEnum.中止.getCode());
        wrapper.orderByAsc("tree_index");
        List<BudgetDetailEntity> detailList = budgetDetailService.list(wrapper);
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (BudgetDetailEntity cdEntity : detailList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
            }
        }*/
        BudgetTemVO vo = BeanMapper.map(budgetEntity, BudgetTemVO.class);
        //List<BudgetDetailTemVO> resultMapList = BeanMapper.mapList(detailList, BudgetDetailTemVO.class);
        //vo.setDetailList(resultMapList);
        return CommonResponse.success(vo);
    }

    @Override
    public CommonResponse<BudgetTemVO> getBudgetVOByProjectIdAndKeys(Long projectId, List<Long> selectedKeys) {
        QueryWrapper<BudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<BudgetEntity> list = budgetService.list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return CommonResponse.error("未查询到生效的项目预算！");
        }
        BudgetEntity budgetEntity = list.get(0);
        QueryWrapper<BudgetDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("budget_id", budgetEntity.getId());
        //只需要展示123级
        wrapper.in("level_no", Arrays.asList(1, 2, 3));
        // 根据选中的楼号，筛选收据
        if(null != selectedKeys){
            String tempSql = "(";
            for (Long buildingNo:selectedKeys
            ) {
                tempSql = tempSql + " inner_code like '"+buildingNo+"%' or";
            }
            tempSql = tempSql.substring(0,tempSql.length()-2);
            tempSql = tempSql + ")";
            wrapper.apply(tempSql);
        }
        wrapper.ne("change_type", ChangeTypeEnum.中止.getCode());
        wrapper.orderByAsc("tree_index");
        List<BudgetDetailEntity> detailList = budgetDetailService.list(wrapper);
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (BudgetDetailEntity cdEntity : detailList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
            }
        }
        BudgetTemVO vo = BeanMapper.map(budgetEntity, BudgetTemVO.class);
        List<BudgetDetailTemVO> resultMapList = BeanMapper.mapList(detailList, BudgetDetailTemVO.class);
        vo.setDetailList(resultMapList);
        return CommonResponse.success(vo);
    }

    @Override
    public CommonResponse<BudgetEntity> getBudgetByProjectId(Long projectId) {
        QueryWrapper<BudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<BudgetEntity> list = budgetService.list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return CommonResponse.error("未查询到生效的项目预算！");
        }
        BudgetEntity budgetEntity = list.get(0);
        QueryWrapper<BudgetDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("budget_id", budgetEntity.getId());
        wrapper.ne("change_type", ChangeTypeEnum.中止.getCode());
        wrapper.orderByAsc("tree_index");
        //wrapper.in("level_no", Arrays.asList(1, 2, 3));
        List<BudgetDetailEntity> detailList = budgetDetailService.list(wrapper);
        budgetEntity.setDetailList(detailList);
        return CommonResponse.success(budgetEntity);
    }

    @Override
    public CommonResponse<BudgetTemVO> getBudgetById(Long budgetId) {
        BudgetEntity budgetEntity = budgetService.getById(budgetId);
        /*QueryWrapper<BudgetDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("budget_id", budgetEntity.getId());
        //只需要展示123级
        wrapper.in("level_no", Arrays.asList(1, 2, 3));
        wrapper.ne("change_type", ChangeTypeEnum.中止.getCode());
        wrapper.orderByAsc("tree_index");
        List<BudgetDetailEntity> detailList = budgetDetailService.list(wrapper);
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (BudgetDetailEntity cdEntity : detailList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
            }
        }*/
        BudgetTemVO vo = BeanMapper.map(budgetEntity, BudgetTemVO.class);
        /*List<BudgetDetailTemVO> resultMapList = BeanMapper.mapList(detailList, BudgetDetailTemVO.class);
        vo.setDetailList(resultMapList);*/
        return CommonResponse.success(vo);
    }

    @Override
    public CommonResponse<BudgetTemVO> getBudgetByIdAndBuildingNos(Long budgetId,List<Long> buildingNos) {
        BudgetEntity budgetEntity = budgetService.getById(budgetId);
        QueryWrapper<BudgetDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("budget_id", budgetEntity.getId());
        //只需要展示123级
        wrapper.in("level_no", Arrays.asList(1, 2, 3));
        wrapper.ne("change_type", ChangeTypeEnum.中止.getCode());
        // 根据选中的楼号，筛选收据
        if(null != buildingNos && buildingNos.size()>0){
            String tempSql = "(";
            for (Long buildingNo:buildingNos
            ) {
                tempSql = tempSql + " inner_code like '"+buildingNo+"%' or";
            }
            tempSql = tempSql.substring(0,tempSql.length()-2);
            tempSql = tempSql + ")";
            wrapper.apply(tempSql);
        }
        wrapper.orderByAsc("tree_index");

        List<BudgetDetailEntity> detailList = budgetDetailService.list(wrapper);
        // 对树形重新排序 start
        List<BudgetDetailVO> budgetDetailVOS = BeanMapper.mapList(detailList, BudgetDetailVO.class);
        budgetDetailVOS.forEach(item->{
            Integer treeNumber = 0;
            // 进制，本次需求只考虑到两位数，进制为10的n次方。
            Integer baseSystem = 100;
            // 基数, 基数为10的n*(m-1)次方 n进制位数，m树形层数。
            Integer useNumber = 1000000;
            String treeIndex = item.getTreeIndex();
            String[] split = treeIndex.split("\\.");
            for (String s : split) {
                treeNumber += Integer.parseInt(s) * useNumber;
                useNumber = useNumber / baseSystem;
            }
            item.setTreeNumber(treeNumber);
        });
        Collections.sort(budgetDetailVOS,new Comparator<BudgetDetailVO>() {
            @Override
            public int compare(BudgetDetailVO o1, BudgetDetailVO o2) {
                return o1.getTreeNumber().compareTo(o2.getTreeNumber());
            }
        });
        detailList = BeanMapper.mapList(budgetDetailVOS, BudgetDetailEntity.class);
        // 排序 end
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (BudgetDetailEntity cdEntity : detailList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
            }
        }
        BudgetTemVO vo = BeanMapper.map(budgetEntity, BudgetTemVO.class);
        List<BudgetDetailTemVO> resultMapList = BeanMapper.mapList(detailList, BudgetDetailTemVO.class);
        vo.setDetailList(resultMapList);
        return CommonResponse.success(vo);
    }

    private CommonResponse<RecalculateVO> setBudgetInfo(RecalculateVO cal, int updateFlag){
        //获取按最新的预算
        BudgetEntity budgetEntity = null;
        if (cal.getBudgetId() != null) {
            budgetEntity = budgetService.selectById(cal.getBudgetId());
        } else {
            CommonResponse<BudgetEntity> budgetByProjectId = this.getBudgetByProjectId(cal.getProjectId());
            budgetEntity = budgetByProjectId.getData();
        }
        if (budgetEntity == null) {
            return CommonResponse.error("未查询到项目预算!");
        }
        List<BudgetDetailEntity> detailList = budgetEntity.getDetailList();
        if (CollectionUtils.isEmpty(detailList)) {
            return CommonResponse.error("未查询到项目预算下的明细!");
        }
        Map<Long, BigDecimal> level3Map = detailList.stream().filter(s -> s.getLevelNo() == 3).collect(Collectors.toMap(k -> k.getId(), k -> k.getCostNum()));
        Map<Long, List<BudgetDetailEntity>> level4Map = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getMaterialId));
        // 获取当前月份
        String curMonth = DateUtil.getCurrentDay(DateUtil.MONTH);
        List<Long> level3Ids = new ArrayList<>(level3Map.keySet());
        QueryParam param = new QueryParam();

        List<BudgetInfoEntity> budgetInfoEntities = new ArrayList<>();
        if(level3Ids.size()>0){
            param.getParams().put("detail_id", new Parameter(QueryParam.IN, level3Ids));
            param.getParams().put("yyear_month", new Parameter(QueryParam.EQ, curMonth));
            budgetInfoEntities = budgetInfoService.queryList(param);
        }
        Map<Long, BudgetInfoEntity> infoMap = budgetInfoEntities.stream().collect(Collectors.toMap(k -> k.getDetailId(), k -> k));
        // 需要新增的条目
        List<BudgetInfoEntity> newInfos = new ArrayList<>();
        for (Long id:level3Ids
        ) {
            if(null == infoMap.get(id)){
                BudgetInfoEntity entity = new BudgetInfoEntity();
                entity.setDetailId(id);
                entity.setProjectId(budgetEntity.getProjectId());
                entity.setYyearMonth(curMonth);
                newInfos.add(entity);
            }
        }
        // 合并list
        budgetInfoEntities.addAll(newInfos);
        // 如果有计划，获取计划明细
        BudgetPlanEntity budgetPlan = this.getBudgetPlan(cal);
        if(null != budgetPlan){
            String endMonth = budgetPlan.getEndMonth();
            param = new QueryParam();
            param.getParams().put("plan_id", new Parameter(QueryParam.EQ, budgetPlan.getId()));
            param.getParams().put("detail_id", new Parameter(QueryParam.IN, level3Ids));
            if(curMonth.compareTo(endMonth) > 0){
                param.getParams().put("yyear_month", new Parameter(QueryParam.EQ, endMonth));
            }else{
                param.getParams().put("yyear_month", new Parameter(QueryParam.EQ, curMonth));
            }
            List<BudgetPlanItemEntity> nowPlanItemEntities = budgetPlanItemService.queryList(param);
            Map<Long, BudgetPlanItemEntity> planMap = nowPlanItemEntities.stream().collect(Collectors.toMap(k -> k.getDetailId(), k -> k));

            // 如原有计划数据，并且endMonth小于当前月，需按照endMonth重新查询一次数据，确保月份准确性
            if(curMonth.compareTo(endMonth) > 0){
                param = new QueryParam();
                budgetInfoEntities.clear();
                if(level3Ids.size() > 0){
                    param.getParams().put("detail_id", new Parameter(QueryParam.IN, level3Ids));
                    param.getParams().put("yyear_month", new Parameter(QueryParam.EQ, endMonth));
                    budgetInfoEntities = budgetInfoService.queryList(param);
                }
                infoMap = budgetInfoEntities.stream().collect(Collectors.toMap(k -> k.getDetailId(), k -> k));
                // 需要新增的条目
                newInfos = new ArrayList<>();
                for (Long id:level3Ids
                ) {
                    if(null == infoMap.get(id)){
                        BudgetInfoEntity entity = new BudgetInfoEntity();
                        entity.setDetailId(id);
                        entity.setProjectId(budgetEntity.getProjectId());
                        entity.setYyearMonth(endMonth);
                        newInfos.add(entity);
                    }
                }
                // 合并list
                budgetInfoEntities.addAll(newInfos);
            }

            for (BudgetInfoEntity entity:budgetInfoEntities
            ) {
                BudgetPlanItemEntity planEntity = planMap.get(entity.getDetailId());
                if(null != planEntity){
                    entity.setPlanId(planEntity.getPlanId());
                    entity.setPlanNum(planEntity.getPlanNum());
                    entity.setPlanRatio(planEntity.getPlanRatio());
                    entity.setFinishRatio(planEntity.getFinishRatio());
                    entity.setFinishNum(planEntity.getFinishNum());
                }
            }
            budgetInfoService.saveOrUpdateBatch(budgetInfoEntities);
            return CommonResponse.success();
        }else{
            if(updateFlag > 2){
                //每种材料的预算量
                Map<Long, BigDecimal> level4BudgetNumMap = new HashMap<>();
                level4Map.forEach((k, v) -> level4BudgetNumMap.put(k, v.stream().filter(s -> s.getMaterialPlanNum() != null).map(BudgetDetailEntity::getMaterialPlanNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
                List<InstoreMaterialVO> instoreMaterialVOS = null;
                if (updateFlag == 3) {
                    Map<String, Object> queryParam = new HashMap<>();
                    queryParam.put("projectId", cal.getProjectId());
                    queryParam.put("materialIds", new ArrayList<>(level4Map.keySet()));
                    //大约当前月 2021-09-11
                    String currentDay = DateUtil.getCurrentDay(null);
                    String endDay =  "31";
                    //大约当前月 25
                    String _endMonthDate = curMonth + "-" + endDay;
                    if (_endMonthDate.compareTo(currentDay) >= 0) {
                        queryParam.put("endMonth", _endMonthDate);
                    } else {
                        //如果截止日期今天之前,那说明当前月是在下月
                        queryParam.put("endMonth", DateUtil.format(DateUtil.minusMonths(-1), DateUtil.MONTH) + endDay);
                    }
                    CommonResponse<List<InstoreMaterialVO>> listCommonResponse = materialInstoreApi.instoreNumCount(queryParam);
                    if (!listCommonResponse.isSuccess()) {
                        logger.error(listCommonResponse.getMsg());
                        return CommonResponse.error(listCommonResponse.getMsg());
                    }
                    instoreMaterialVOS = listCommonResponse.getData();
                } else {
                    instoreMaterialVOS = cal.getInstoreMaterialVOS();
                }
                if (CollectionUtils.isEmpty(instoreMaterialVOS)) {
                    budgetInfoService.saveOrUpdateBatch(budgetInfoEntities);
                    return CommonResponse.success("未查询到物资入库数量信息!");
                }
                Map<Long, BigDecimal> level4InstoreMap = instoreMaterialVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getInstoreNumber()));
                //计算材料的到货量/预算量,如果到货量大于预算量,则按照1计算
                Map<Long, BigDecimal> instoreBudgetMap = new HashMap<>();
                level4BudgetNumMap.forEach((k, v) -> instoreBudgetMap.put(k, level4InstoreMap.get(k) != null && ComputeUtil.isGreaterOrEqual(level4InstoreMap.get(k), v) ? BigDecimal.ONE : ComputeUtil.safeDiv(level4InstoreMap.get(k), v)));
                //key 是detailId 可以获取每种工艺下的所有材料 材料使用率  材料权重
                Map<Long, List<BudgetDetailEntity>> level3ChildMap = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getParentId));

                //获取是否完成标志
                List<UseApplyFinishVO> useApplyFinishVOS = cal.getUseApplyFinishVOS();
                Map<Long, Integer> materialFinishMap = null;
                if (CollectionUtils.isNotEmpty(useApplyFinishVOS)) {
                    materialFinishMap = useApplyFinishVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getIsFinish()));
                }

                for (BudgetInfoEntity t:budgetInfoEntities
                ) {
                    Long detailId = t.getDetailId();
                    List<BudgetDetailEntity> budgetDetailEntities = level3ChildMap.get(detailId);
                    if (CollectionUtils.isNotEmpty(budgetDetailEntities)) {
                        BigDecimal _subFinishRatio = BigDecimal.ZERO;
                        for (BudgetDetailEntity k : budgetDetailEntities) {
                            Long materialId = k.getMaterialId();
                            //②材料使用率取数：如果材料需求申请标识【已完成】状态，材料使用率按照1计算
                            Integer finishCount = MapUtils.isNotEmpty(materialFinishMap) ? materialFinishMap.get(materialId) : 0;
                            BigDecimal useScale = finishCount != null && finishCount.intValue() > 0 ? NumberConsts.ONE_BAI : k.getMaterialUsedScale();
                            BigDecimal instoreNumBudgetNum = instoreBudgetMap.get(materialId);
                            if(null != finishCount && finishCount == 1){
                                instoreNumBudgetNum = BigDecimal.ONE;
                            }
                            BigDecimal b1 = ComputeUtil.safeMultiply(instoreNumBudgetNum, useScale, k.getMaterialWeightScale());
                            _subFinishRatio = ComputeUtil.safeAdd(_subFinishRatio, ComputeUtil.safeDiv(b1, NumberConsts.ONE_WAN));
                        }
                        //完成比例E1=（每种材料种类累计到货量/预算量*预算中的材料使用率字段）*材料产值权重占比
                        //①如果累计到货量/预算量>=100%，则按照1计算
                        //②材料使用率取数：如果材料需求申请标识【已完成】状态，材料使用率按照1计算
                        t.setFinishRatio(ComputeUtil.safeMultiply(_subFinishRatio, NumberConsts.ONE_BAI));
                        //完成工程量 = 完成比例 * 成本工程量
                        t.setFinishNum(ComputeUtil.safeMultiply(_subFinishRatio, level3Map.get(detailId)));
                    }
                }
                budgetInfoService.saveOrUpdateBatch(budgetInfoEntities);
                return CommonResponse.success();
            }
        }
        return CommonResponse.success();
    };

    @Override
    public CommonResponse<RecalculateVO> recalculate(RecalculateVO cal, int updateFlag) {
        CommonResponse<RecalculateVO> recalculateVOCommonResponse = beforeRecalculate(cal, updateFlag);
        // 不管有没有做计划，都反推完成量到info表
        logger.info("开始执行反推info表");
        CommonResponse<RecalculateVO> setInfoCommonResponse = setBudgetInfo(cal, updateFlag);
        logger.info("执行反推info表完成");
        if(!setInfoCommonResponse.isSuccess()){
            return setInfoCommonResponse;
        }
        return recalculateVOCommonResponse;
    }

    /**
     * @param cal        计算vo
     * @param updateFlag 更新标志 1 用于更新历史比例-例如预算变更审批后调用 2-用于入库回写当月计算(发起方物资模块) 3.用于施工计划保存回写当月计算(发起方本模块)
     * @description: 计算vo
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.plan.vo.BudgetTemVO>
     * @author songlx
     * @date: 2021/9/10
     */
    public CommonResponse<RecalculateVO> beforeRecalculate(RecalculateVO cal, int updateFlag) {
        //获取按最新的预算
        BudgetEntity budgetEntity = null;
        if (cal.getBudgetId() != null) {
            budgetEntity = budgetService.selectById(cal.getBudgetId());
        } else {
            CommonResponse<BudgetEntity> budgetByProjectId = this.getBudgetByProjectId(cal.getProjectId());
            budgetEntity = budgetByProjectId.getData();
        }


        if (budgetEntity == null) {
            return CommonResponse.error("未查询到项目预算!");
        }

        List<BudgetDetailEntity> detailList = budgetEntity.getDetailList();
        if (CollectionUtils.isEmpty(detailList)) {
            return CommonResponse.error("未查询到项目预算下的明细!");
        }

        Map<Long, BigDecimal> level3Map = detailList.stream().filter(s -> s.getLevelNo() == 3).collect(Collectors.toMap(k -> k.getId(), k -> k.getCostNum()));
        Map<Long, List<BudgetDetailEntity>> level4Map = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getMaterialId));

        if (level4Map == null || level4Map.isEmpty()) {
            return CommonResponse.error("未查询到项目预算下材料明细(四级)!");
        }
        // 获取计划
        BudgetPlanEntity budgetPlanEntity = this.getBudgetPlan(cal);
        if (budgetPlanEntity == null) {
            return CommonResponse.error("未查询到项目的施工计划!");
        }

        /**
         一.项目预算变更   到货量为准
         1.更新累计值;
         2.计算当月;
         二.物资入库回写
         1.计算当月;

         */
        // 需要更新历史比例,此处为预算变更类回写 根据完成量 和 变化后的成本量 更新完成比例
        if (updateFlag == 1) {
            List<Long> level3Ids = new ArrayList<>(level3Map.keySet());
            QueryParam param = new QueryParam();
            param.getParams().put("plan_id", new Parameter(QueryParam.EQ, budgetPlanEntity.getId()));
            param.getParams().put("detail_id", new Parameter(QueryParam.IN, level3Ids));
            String curMonth = DateUtil.getCurrentDay(DateUtil.MONTH);
            List<BudgetPlanItemEntity> planItemEntities = budgetPlanItemService.queryList(param);

            // 获取当前月的计划
            param.getParams().put("yyear_month", new Parameter(QueryParam.EQ, curMonth));
            List<BudgetPlanItemEntity> nowPlanItemEntities = budgetPlanItemService.queryList(param);
            if(CollectionUtils.isNotEmpty(nowPlanItemEntities)){
                nowPlanItemEntities.forEach(t ->{
                    // 成本工程量
                    BigDecimal budgetNum = level3Map.get(t.getDetailId());
                    BigDecimal ratio = BigDecimal.ZERO;
                    if(null != t.getPlanRatio()){
                        ratio = t.getPlanRatio();
                        t.setPlanNum(budgetNum.multiply(ratio).divide(ComputeUtil.toBigDecimal(100)));
                    }
                });
                budgetPlanItemService.saveOrUpdateBatch(nowPlanItemEntities);
            }

            if (CollectionUtils.isNotEmpty(planItemEntities)) {
                planItemEntities.forEach(t -> {
                    // 成本工程量
                    BigDecimal budgetNum = level3Map.get(t.getDetailId());
                    BigDecimal ratio = BigDecimal.ZERO;
                    if(null != t.getPlanRatio()){
                        ratio = t.getPlanRatio();
                        t.setPlanNum(budgetNum.multiply(ratio).divide(ComputeUtil.toBigDecimal(100)));
                    }
                    if(null != t.getFinishNum()){
                        t.setFinishRatio(ComputeUtil.bigDecimalPercent(t.getFinishNum(), level3Map.get(t.getDetailId()), 8));
                    }
                });
                budgetPlanItemService.saveOrUpdateBatch(planItemEntities);
            }
            //多余的三级明细删除
            if (CollectionUtils.isNotEmpty(level3Ids)) {
                QueryWrapper<BudgetPlanItemEntity> delQueryWrapper = new QueryWrapper<>();
                delQueryWrapper.eq("plan_id", budgetPlanEntity.getId());
                delQueryWrapper.notIn("detail_id", level3Ids);
                budgetPlanItemService.remove(delQueryWrapper);
            }
        }
        if (updateFlag >= 2) {

            //每种材料的预算量
            Map<Long, BigDecimal> level4BudgetNumMap = new HashMap<>();
            level4Map.forEach((k, v) -> level4BudgetNumMap.put(k, v.stream().filter(s -> s.getMaterialPlanNum() != null).map(BudgetDetailEntity::getMaterialPlanNum).reduce(BigDecimal.ZERO, BigDecimal::add)));

            List<InstoreMaterialVO> instoreMaterialVOS = null;
            if (updateFlag == 3) {
                Map<String, Object> queryParam = new HashMap<>();
                queryParam.put("projectId", cal.getProjectId());
                queryParam.put("materialIds", new ArrayList<>(level4Map.keySet()));
                //大约当前月 2021-09-11
                String currentDay = DateUtil.getCurrentDay(null);
                String curMonth = DateUtil.getCurrentDay(DateUtil.MONTH);
                String endDay = budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "31";
                //大约当前月 25
                String _endMonthDate = curMonth + "-" + endDay;
                if (_endMonthDate.compareTo(currentDay) >= 0) {
                    queryParam.put("endMonth", _endMonthDate);
                } else {
                    //如果截止日期今天之前,那说明当前月是在下月
                    queryParam.put("endMonth", DateUtil.format(DateUtil.minusMonths(-1), DateUtil.MONTH) + endDay);
                }
                CommonResponse<List<InstoreMaterialVO>> listCommonResponse = materialInstoreApi.instoreNumCount(queryParam);
                if (!listCommonResponse.isSuccess()) {
                    logger.error(listCommonResponse.getMsg());
                    return CommonResponse.error(listCommonResponse.getMsg());
                }
                instoreMaterialVOS = listCommonResponse.getData();
            } else {
                instoreMaterialVOS = cal.getInstoreMaterialVOS();
            }


            if (CollectionUtils.isEmpty(instoreMaterialVOS)) {
                return CommonResponse.success("未查询到物资入库数量信息!");
            }

            Map<Long, BigDecimal> level4InstoreMap = instoreMaterialVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getInstoreNumber()));
            //计算材料的到货量/预算量,如果到货量大于预算量,则按照1计算
            Map<Long, BigDecimal> instoreBudgetMap = new HashMap<>();
            level4BudgetNumMap.forEach((k, v) -> instoreBudgetMap.put(k, level4InstoreMap.get(k) != null && ComputeUtil.isGreaterOrEqual(level4InstoreMap.get(k), v) ? BigDecimal.ONE : ComputeUtil.safeDiv(level4InstoreMap.get(k), v)));

            //key 是detailId 可以获取每种工艺下的所有材料 材料使用率  材料权重
            Map<Long, List<BudgetDetailEntity>> level3ChildMap = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getParentId));

            QueryParam p = new QueryParam();
            p.getParams().put("plan_id", new Parameter(QueryParam.EQ, budgetPlanEntity.getId()));
            //大约当前月 2021-09-11
            String currentDay1 = DateUtil.getCurrentDay(null);
            String curMonth1 = DateUtil.getCurrentDay(DateUtil.MONTH);
            String endDay1 = budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "31";
            //大约当前月 25
            String _endMonthDate1 = curMonth1 + "-" + endDay1;
            QueryWrapper pw = changeToQueryWrapper(p);
            if (_endMonthDate1.compareTo(currentDay1) >= 0) {
                String start = DateUtil.format(DateUtil.minusMonths(1), DateUtil.MONTH) + "-" + endDay1;
                pw.apply("(yyear_month >= '" + start + "' and yyear_month < '" + _endMonthDate1 + "')");
            } else {
                //如果截止日期今天之前,那说明当前月是在下月
                String end = DateUtil.format(DateUtil.minusMonths(-1), DateUtil.MONTH) + "-" + endDay1;
                pw.apply("(yyear_month >= '" + _endMonthDate1 + "' and yyear_month < '" + end + "')");
            }
            List<BudgetPlanItemEntity> planItemEntities = budgetPlanItemService.list(pw);

            if(planItemEntities.size() == 0){
                String endMonth = budgetPlanEntity.getEndMonth();
                if(curMonth1.compareTo(endMonth) > 0){
                    QueryWrapper objectQueryWrapper = changeToQueryWrapper(p);
                    objectQueryWrapper.apply("(yyear_month = '" + endMonth + "')");
                    planItemEntities = budgetPlanItemService.list(objectQueryWrapper);
                    logger.info("====================");
                    logger.info(String.valueOf(planItemEntities.size()));
                }
            }

            //获取是否完成标志
            List<UseApplyFinishVO> useApplyFinishVOS = cal.getUseApplyFinishVOS();
            Map<Long, Integer> materialFinishMap = null;
            if (CollectionUtils.isNotEmpty(useApplyFinishVOS)) {
                materialFinishMap = useApplyFinishVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getIsFinish()));
            }
            for (BudgetPlanItemEntity t : planItemEntities) {
                Long detailId = t.getDetailId();
                List<BudgetDetailEntity> budgetDetailEntities = level3ChildMap.get(detailId);
                if (CollectionUtils.isNotEmpty(budgetDetailEntities)) {
                    BigDecimal _subFinishRatio = BigDecimal.ZERO;
                    for (BudgetDetailEntity k : budgetDetailEntities) {
                        Long materialId = k.getMaterialId();
                        //②材料使用率取数：如果材料需求申请标识【已完成】状态，材料使用率按照1计算
                        Integer finishCount = MapUtils.isNotEmpty(materialFinishMap) ? materialFinishMap.get(materialId) : 0;
                        BigDecimal useScale = finishCount != null && finishCount.intValue() > 0 ? NumberConsts.ONE_BAI : k.getMaterialUsedScale();
                        BigDecimal instoreNumBudgetNum = instoreBudgetMap.get(materialId);
                        if(null != finishCount && finishCount == 1){
                            instoreNumBudgetNum = BigDecimal.ONE;
                        }
                        BigDecimal b1 = ComputeUtil.safeMultiply(instoreNumBudgetNum, useScale, k.getMaterialWeightScale());
                        _subFinishRatio = ComputeUtil.safeAdd(_subFinishRatio, ComputeUtil.safeDiv(b1, NumberConsts.ONE_WAN));
                    }
                    //完成比例E1=（每种材料种类累计到货量/预算量*预算中的材料使用率字段）*材料产值权重占比
                    //①如果累计到货量/预算量>=100%，则按照1计算
                    //②材料使用率取数：如果材料需求申请标识【已完成】状态，材料使用率按照1计算
                    t.setFinishRatio(ComputeUtil.safeMultiply(_subFinishRatio, NumberConsts.ONE_BAI));
                    //完成工程量 = 完成比例 * 成本工程量
                    t.setFinishNum(ComputeUtil.safeMultiply(_subFinishRatio, level3Map.get(detailId)));
                }
            }
            if (planItemEntities.size() == 0) {
                logger.info("未查询到BudgetPlanItemEntity数据，plan_id：" + budgetPlanEntity.getId());
            } else {
                budgetPlanItemService.saveOrUpdateBatch(planItemEntities);
            }
        }
        return CommonResponse.success("重新计算项目施工计划信息成功!");
    }

    @Override
    public void createNewPlanItem(Long budgetId) {
        QueryWrapper<BudgetPlanEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("budget_id", budgetId);
        List<BudgetPlanEntity> list1 = this.list(queryWrapper);
        if (list1.size() == 0) {
            return;
        }
        BudgetPlanEntity budgetPlanEntity = list1.get(0);

        QueryWrapper<BudgetPlanItemEntity> itemWrapper = new QueryWrapper<>();
        itemWrapper.eq("plan_id",budgetPlanEntity.getId());
        itemWrapper.eq("leaf_level",3);
        List<BudgetPlanItemEntity> budgetPlanItemEntities = budgetPlanItemService.list(itemWrapper);
        // 存储所有的月份
        Set<String> dateSet = new HashSet<>();
        Map<Long,BudgetPlanItemEntity> map = new HashMap<>();
        budgetPlanItemEntities.forEach(item->{
            dateSet.add(item.getYyearMonth());
            map.put(item.getDetailId(),item);
        });

        QueryWrapper<BudgetDetailEntity> detailWrapper = new QueryWrapper<>();
        detailWrapper.eq("budget_id",budgetPlanEntity.getBudgetId());
        detailWrapper.eq("level_no",3);
        List<BudgetDetailEntity> list = budgetDetailService.list(detailWrapper);

        List<BudgetPlanItemEntity> entityList = new ArrayList<>();
        list.forEach(item->{
            if(map.get(item.getId()) == null){
                dateSet.forEach(info->{
                    BudgetPlanItemEntity entity = new BudgetPlanItemEntity();
                    entity.setPlanId(budgetPlanEntity.getId());
                    entity.setDetailId(item.getId());
                    entity.setLeafLevel(3);
                    entity.setLeafFlag(1);
                    entity.setYyearMonth(info);
                    String curMonth = DateUtil.getCurrentDay(DateUtil.MONTH);
                    int curMonthNum = Integer.parseInt (curMonth.substring(0,4)+curMonth.substring(5));
                    int infoNum = Integer.parseInt (info.substring(0,4)+info.substring(5));
                    if(infoNum >= curMonthNum){
                        entity.setPlanNum(item.getCostNum());
                        entity.setPlanRatio(BigDecimal.valueOf(100));
                    }
                    entityList.add(entity);
                });
            }
        });
        if(entityList.size() > 0){
            budgetPlanItemService.saveOrUpdateBatch(entityList);
        }
    }

    private BudgetPlanEntity getBudgetPlan(RecalculateVO cal) {
        QueryWrapper<BudgetPlanEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        if (cal.getBudgetId() != null) {
            queryWrapper.eq("budget_id", cal.getBudgetId());
        } else {
            queryWrapper.eq("project_id", cal.getProjectId());
        }
        //queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<BudgetPlanEntity> list = this.list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public CommonResponse<RecalculateVO> getInfo(RecalculateVO cal) {
        // 获取计划
        BudgetPlanEntity budgetPlanEntity = null;
        QueryWrapper<BudgetPlanEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        if (cal.getBudgetId() != null) {
            queryWrapper.eq("budget_id", cal.getBudgetId());
        } else {
            queryWrapper.eq("project_id", cal.getProjectId());
        }
        //queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<BudgetPlanEntity> list = this.list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return CommonResponse.error("未查询到项目的施工计划!");
        }
        budgetPlanEntity = list.get(0);

        if (budgetPlanEntity.getBudgetId() == null) {
            return CommonResponse.error("查询到项目的施工计划,计划中的预算id为空!");
        }

        BudgetEntity budgetEntity = budgetService.selectById(budgetPlanEntity.getBudgetId());
        if (budgetEntity == null) {
            return CommonResponse.error("未查询到项目的预算!");
        }

        List<BudgetDetailEntity> detailList = budgetEntity.getDetailList();
        if (CollectionUtils.isEmpty(detailList)) {
            return CommonResponse.error("未查询到项目预算下的明细!");
        }

        Map<Long, List<BudgetDetailEntity>> level4Map = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getMaterialId));

        Map<String, Object> queryParam = new HashMap<>();
        queryParam.put("projectId", cal.getProjectId());
        queryParam.put("materialIds", new ArrayList<>(level4Map.keySet()));
        //大约当前月 2021-09-11
        String currentDay = DateUtil.getCurrentDay(null);
        String curMonth = DateUtil.getCurrentDay(DateUtil.MONTH);
        String endDay = budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "31";
        //大约当前月 25
        String _endMonthDate = curMonth + "-" + endDay;
        if (_endMonthDate.compareTo(currentDay) >= 0) {
            queryParam.put("endMonth", _endMonthDate);
        } else {
            //如果截止日期今天之前,那说明当前月是在下月
            queryParam.put("endMonth", DateUtil.format(DateUtil.minusMonths(-1), DateUtil.MONTH) + endDay);
        }
        cal.setQueryParam(queryParam);
        return CommonResponse.success("查询项目预算和施工计划成功!", cal);
    }

    @Override
    public CommonResponse<RecalculateVO> getPlanNum(RecalculateVO cal) {

        //获取按最新的预算
        BudgetEntity budgetEntity = null;
        if (cal.getBudgetId() != null) {
            budgetEntity = budgetService.selectById(cal.getBudgetId());
        } else {
            CommonResponse<BudgetEntity> budgetByProjectId = this.getBudgetByProjectId(cal.getProjectId());
            budgetEntity = budgetByProjectId.getData();
        }


        if (budgetEntity == null) {
            return CommonResponse.error("未查询到项目预算!");
        }

        List<BudgetDetailEntity> detailList = budgetEntity.getDetailList();
        if (CollectionUtils.isEmpty(detailList)) {
            return CommonResponse.error("未查询到项目预算下的明细!");
        }

        Map<Long, BigDecimal> level3Map = detailList.stream().filter(s -> s.getLevelNo() == 3).collect(Collectors.toMap(k -> k.getId(), k -> k.getCostNum()));
        Map<Long, List<BudgetDetailEntity>> level4Map = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getMaterialId));

        if (level4Map == null || level4Map.isEmpty()) {
            return CommonResponse.error("未查询到项目预算下材料明细(四级)!");
        }

        Map<Long, BigDecimal> level3PlanNum = new HashMap<>();
        // 获取计划
        BudgetPlanEntity budgetPlanEntity = this.getBudgetPlan(cal);
        if (budgetPlanEntity == null) {
            logger.info("未查询到项目的施工计划!");
            //return CommonResponse.error("未查询到项目的施工计划!");
        }else if(budgetPlanEntity.getBillState() != 1 && budgetPlanEntity.getBillState() != 3){
            logger.info("项目的施工计划未生效!");
        }else{
            QueryParam p = new QueryParam();
            p.getParams().put("plan_id", new Parameter(QueryParam.EQ, budgetPlanEntity.getId()));
            //大约当前月 2021-09-18
            String currentDay1 = cal.getMonthEndDate();
            String curMonth1 = DateUtil.getCurrentDay(DateUtil.MONTH);
            String endDay1 = budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "31";
            //大约当前月 2021-09-25
            String _endMonthDate1 = curMonth1 + "-" + endDay1;
            if (_endMonthDate1.compareTo(currentDay1) >= 0) {
                String start = DateUtil.format(DateUtil.minusMonths(1), DateUtil.MONTH) + "-" + endDay1;
                cal.setStartMonth(start);
                cal.setEndMonth(_endMonthDate1);
                p.getParams().put("yyear_month", new Parameter(QueryParam.EQ, curMonth1));
            } else {
                //如果截止日期今天之前,那说明当前月是在下月
                String nextMonth = DateUtil.format(DateUtil.minusMonths(-1), DateUtil.MONTH);
                String end = nextMonth + "-" + endDay1;
                p.getParams().put("yyear_month", new Parameter(QueryParam.EQ, nextMonth));
                cal.setStartMonth(_endMonthDate1);
                cal.setEndMonth(end);
            }
            QueryWrapper pw = changeToQueryWrapper(p);
            List<BudgetPlanItemEntity> planItemEntities = budgetPlanItemService.list(pw);
            for (BudgetPlanItemEntity budgetPlanItemEntity:planItemEntities
            ) {
                level3PlanNum.put(budgetPlanItemEntity.getDetailId(),ComputeUtil.nullToZero(budgetPlanItemEntity.getPlanNum()));
            }
        }
        Map<Long, BigDecimal> level4NumMap = new HashMap<>();
        Map<Long, BigDecimal> level4BudgetNumMap = new HashMap<>();
        level4Map.forEach((k, v) -> {
            if (CollectionUtils.isNotEmpty(v)) {
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal budgetNum = BigDecimal.ZERO;
                for (BudgetDetailEntity b : v) {
                    Long level3id = b.getParentId();
                    BigDecimal planNum = level3PlanNum.get(level3id);
                    BigDecimal materialUsedNum = b.getMaterialUsedNum();
                    num = ComputeUtil.safeAdd(num, ComputeUtil.safeMultiply(planNum, materialUsedNum));
                    budgetNum = ComputeUtil.safeAdd(budgetNum, b.getMaterialPlanNum());
                }
                level4NumMap.put(k, num);
                level4BudgetNumMap.put(k, budgetNum);
            }
            cal.setPlanNumMap(level4NumMap);
            cal.setBudgetNumMap(level4BudgetNumMap);
        });
        return CommonResponse.success("查询项目预算和施工计划成功!", cal);
    }

    @Override
    public CommonResponse<String> updateDataByDay() {
        QueryWrapper<BudgetEntity> wrapper = new QueryWrapper();
        List<BudgetEntity> list = budgetService.list(wrapper);
        for (BudgetEntity item : list) {
            RecalculateVO vo = new RecalculateVO(item.getProjectId(), null);
            CommonResponse<RecalculateVO> recalculate = recalculate(vo, 3);
            if (!recalculate.isSuccess())
                logger.info("数据不需要更新，ProjectId:" + item.getProjectId());
        }
        return CommonResponse.success("更新成功！");
    }
}
